/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSineWave
extends BNumericPoint {
    public static final Property enabled = BSineWave.newProperty((int)0, (boolean)true, null);
    public static final Property period = BSineWave.newProperty((int)0, (BValue)BRelTime.make((long)30000L), null);
    public static final Property amplitude = BSineWave.newProperty((int)0, (int)50, null);
    public static final Property offset = BSineWave.newProperty((int)0, (int)50, null);
    public static final Property updateInterval = BSineWave.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private long start;
    private Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$kitControl$util$BSineWave;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public BRelTime getPeriod() {
        return (BRelTime)this.get(period);
    }

    public void setPeriod(BRelTime bRelTime) {
        this.set(period, (BValue)bRelTime, null);
    }

    public double getAmplitude() {
        return this.getDouble(amplitude);
    }

    public void setAmplitude(double d) {
        this.setDouble(amplitude, d, null);
    }

    public double getOffset() {
        return this.getDouble(offset);
    }

    public void setOffset(double d) {
        this.setDouble(offset, d, null);
    }

    public BRelTime getUpdateInterval() {
        return (BRelTime)this.get(updateInterval);
    }

    public void setUpdateInterval(BRelTime bRelTime) {
        this.set(updateInterval, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.execute();
        this.initTimer();
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    private final void initTimer() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.start = Clock.ticks();
        if (this.getEnabled()) {
            this.ticket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdateInterval(), (Action)execute, null);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == updateInterval || property == enabled) {
            if (this.getUpdateInterval().getMillis() < 1000L) {
                this.setUpdateInterval(BRelTime.make((long)1000L));
            }
            if (this.isRunning()) {
                this.initTimer();
            }
        }
    }

    public void onExecute(BStatusValue bStatusValue, Context context) {
        if (this.getEnabled()) {
            bStatusValue.setStatus(BStatus.makeDisabled((BStatus)bStatusValue.getStatus(), (boolean)false));
            long l = this.getPeriod().getMillis();
            if (l == 0L) {
                l = 1000L;
            }
            long l2 = Clock.ticks() - this.start;
            long l3 = l2 % l;
            double d = (double)l3 / (double)l;
            double d2 = this.getAmplitude();
            double d3 = this.getOffset();
            double d4 = (double)2 * Math.PI * d;
            double d5 = Math.sin(d4) * d2 + d3;
            BStatusNumeric bStatusNumeric = (BStatusNumeric)bStatusValue;
            bStatusNumeric.setValue(d5);
        } else {
            bStatusValue.setStatus(BStatus.makeDisabled((BStatus)bStatusValue.getStatus(), (boolean)true));
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$kitControl$util$BSineWave;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$util$BSineWave = BSineWave.class("[Lcom.tridium.kitControl.util.BSineWave;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"control/util/sine.png");
    }
}

