/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

public abstract class Psychrometric {
    private static float[] p = new float[]{0.01083f, 0.011438f, 0.012078f, 0.01275f, 0.013456f, 0.014198f, 0.014977f, 0.015795f, 0.016655f, 0.017556f, 0.018502f, 0.019496f, 0.020537f, 0.021629f, 0.022775f, 0.023975f, 0.025233f, 0.026552f, 0.027933f, 0.02938f, 0.030894f, 0.03248f, 0.03414f, 0.035878f, 0.037697f, 0.039598f, 0.041587f, 0.043667f, 0.045841f, 0.048114f, 0.050489f, 0.052971f, 0.055564f, 0.058273f, 0.061097f, 0.064053f, 0.067133f, 0.070349f, 0.073705f, 0.077208f, 0.080859f, 0.08467f, 0.088643f, 0.09229f, 0.09607f, 0.09998f, 0.10403f, 0.10823f, 0.11257f, 0.11707f, 0.12173f, 0.12655f, 0.13153f, 0.13669f, 0.14203f, 0.14755f, 0.15327f, 0.15917f, 0.16528f, 0.17159f, 0.17811f, 0.18485f, 0.19181f, 0.199f, 0.20643f, 0.2141f, 0.22203f, 0.2302f, 0.23865f, 0.24736f, 0.25635f, 0.26563f, 0.2752f, 0.28507f, 0.29525f, 0.30575f, 0.31657f, 0.32772f, 0.33922f, 0.35107f, 0.36329f, 0.37587f, 0.38883f, 0.40217f, 0.41593f, 0.43009f, 0.44466f, 0.45967f, 0.47511f, 0.491f, 0.50737f, 0.5242f, 0.5415f, 0.55933f, 0.57763f, 0.59648f, 0.61585f, 0.63576f, 0.65625f, 0.67726f, 0.6989f, 0.72113f, 0.74395f, 0.76742f, 0.79151f, 0.81628f, 0.8417f, 0.86779f, 0.89459f, 0.92211f, 0.95034f, 0.97934f, 1.00906f, 1.03958f, 1.0709f, 1.10304f, 1.13602f, 1.1698f, 1.20446f, 1.24003f, 1.27646f, 1.31383f, 1.35219f, 1.39139f, 1.43167f, 1.47288f, 1.51515f, 1.55845f, 1.60281f, 1.64824f, 1.69473f, 1.74243f, 1.79125f, 1.84119f, 1.8924f, 1.94477f, 1.99832f, 2.05324f, 2.10939f, 2.16687f, 2.22565f, 2.28581f, 2.34731f, 2.41036f, 2.47464f, 2.54053f, 2.60789f, 2.67671f, 2.74713f, 2.81907f, 2.89262f, 2.96782f, 3.04475f, 3.12324f, 3.2035f, 3.28548f, 3.36935f, 3.45494f, 3.54239f, 3.63165f, 3.72283f};

    public static float dewpointTemperature(float f, float f2) {
        if (!Psychrometric.isTempValid(f) || !Psychrometric.isRHValid(f2)) {
            return -9999.99f;
        }
        return Psychrometric.vaporTemperature(Psychrometric.vaporPressure(f, f2));
    }

    public static float enthalpy(float f, float f2) {
        if (!Psychrometric.isTempValid(f) || !Psychrometric.isRHValid(f2)) {
            return -9999.99f;
        }
        float f3 = Psychrometric.vaporPressure(f, f2);
        float f4 = 0.62198f * f3 / (14.696f - f3);
        return 0.24f * f + f4 * (1061.0f + 0.444f * f);
    }

    public static float relativeHumidity(float f, float f2) {
        if (!Psychrometric.isTempValid(f) || !Psychrometric.isDewpointValid(f2)) {
            return -9999.99f;
        }
        float f3 = Psychrometric.saturationPressure(f2) / Psychrometric.saturationPressure(f) * 100.0f;
        if (f3 > 100.0f) {
            f3 = 100.0f;
        }
        return f3;
    }

    public static float saturationPressure(float f) {
        if (!Psychrometric.isTempValid(f)) {
            return -9999.99f;
        }
        float f2 = 0.01f;
        if (f < 0.0f) {
            f2 = 0.0f - f2;
        }
        int n = (int)f * 10;
        int n2 = (int)(f * 10.0f + f2);
        int n3 = n2 - n;
        int n4 = n / 10 + 10;
        return (p[n4 + 1] - p[n4]) * ((float)(n3 * 10) / 100.0f) + p[n4];
    }

    public static float vaporPressure(float f, float f2) {
        if (!Psychrometric.isTempValid(f) || !Psychrometric.isRHValid(f2)) {
            return -9999.99f;
        }
        return Psychrometric.saturationPressure(f) * f2 / 100.0f;
    }

    public static float vaporTemperature(float f) {
        if (!Psychrometric.isPressureValid(f)) {
            return -9999.99f;
        }
        int n = 0;
        while (f > p[n]) {
            ++n;
        }
        if (f == p[n]) {
            return n - 10;
        }
        return (f - p[n - 1]) / (p[n] - p[n - 1]) + (float)(n - 11);
    }

    public static float wetbulbTemperature(float f, float f2) {
        float f3 = 0.0f;
        int n = 0;
        if (!Psychrometric.isTempValid(f) || !Psychrometric.isRHValid(f2)) {
            return -9999.99f;
        }
        float f4 = f2 * Psychrometric.saturationPressure(f) / 100.0f;
        float f5 = 0.62198f * f4 / (14.7f - f4);
        float f6 = 1.0f;
        float f7 = f;
        float f8 = -11.0f;
        while (f6 > 1.0E-6f && n < 20) {
            ++n;
            f3 = (f7 + f8) * 0.5f;
            float f9 = Psychrometric.saturationPressure(f3);
            float f10 = 0.62198f * f9 / (14.7f - f9);
            float f11 = ((1093.0f - 0.556f * f3) * f10 - 0.24f * (f - f3)) / (1093.0f + 0.444f * f - f3);
            if (f11 < 0.0f) {
                f8 = (float)((double)f8 + (double)5);
                continue;
            }
            f6 = f5 - f11;
            if ((double)f6 < 0.0) {
                f7 = f3;
            } else {
                f8 = f3;
            }
            float f12 = f6 = f6 < 0.0f ? 0.0f - f6 : f6;
        }
        return f3;
    }

    public static boolean isTempValid(float f) {
        boolean bl = false;
        if (f < -10.0f || f > 150.0f || Float.isNaN(f)) {
            bl = true;
        }
        return bl ^ true;
    }

    public static boolean isRHValid(float f) {
        boolean bl = false;
        if (f < 0.1f || f > 100.0f || Float.isNaN(f)) {
            bl = true;
        }
        return bl ^ true;
    }

    public static boolean isDewpointValid(float f) {
        boolean bl = false;
        if (f < -10.0f || f > 150.0f || Float.isNaN(f)) {
            bl = true;
        }
        return bl ^ true;
    }

    public static boolean isPressureValid(float f) {
        boolean bl = false;
        if (f < 0.01083f || f > 3.72283f || Float.isNaN(f)) {
            bl = true;
        }
        return bl ^ true;
    }
}

