/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import com.tridium.kitControl.enums.BEnglishMetric;
import com.tridium.kitControl.hvac.Psychrometric;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BPsychrometric
extends BComponent {
    public static final Property unitSelect = BPsychrometric.newProperty((int)0, (BValue)BEnglishMetric.english, null);
    public static final Property temperatureFacets = BPsychrometric.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    public static final Property humidityFacets = BPsychrometric.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent relative humidity"), (int)1), null);
    public static final Property inTemp = BPsychrometric.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property inHumidity = BPsychrometric.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property outDewPoint = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property outEnthalpy = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)2));
    public static final Property outSatPress = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"pounds per square inch"), (int)3));
    public static final Property outVaporPress = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"pounds per square inch"), (int)3));
    public static final Property outWetBulbTemp = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Action calculate = BPsychrometric.newAction((int)4, null);
    public static final Type TYPE;
    private static double fiveNineths;
    private static BFacets pressureEnglishFacets;
    private static BFacets pressureMetricFacets;
    private static BFacets enthalpyEnglishFacets;
    private static BFacets enthalpyMetricFacets;
    Clock.Ticket ticket;
    private boolean isEnglish;
    static /* synthetic */ Class class$com$tridium$kitControl$energy$BPsychrometric;

    public BEnglishMetric getUnitSelect() {
        return (BEnglishMetric)this.get(unitSelect);
    }

    public void setUnitSelect(BEnglishMetric bEnglishMetric) {
        this.set(unitSelect, (BValue)bEnglishMetric, null);
    }

    public BFacets getTemperatureFacets() {
        return (BFacets)this.get(temperatureFacets);
    }

    public void setTemperatureFacets(BFacets bFacets) {
        this.set(temperatureFacets, (BValue)bFacets, null);
    }

    public BFacets getHumidityFacets() {
        return (BFacets)this.get(humidityFacets);
    }

    public void setHumidityFacets(BFacets bFacets) {
        this.set(humidityFacets, (BValue)bFacets, null);
    }

    public BStatusNumeric getInTemp() {
        return (BStatusNumeric)this.get(inTemp);
    }

    public void setInTemp(BStatusNumeric bStatusNumeric) {
        this.set(inTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getInHumidity() {
        return (BStatusNumeric)this.get(inHumidity);
    }

    public void setInHumidity(BStatusNumeric bStatusNumeric) {
        this.set(inHumidity, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutDewPoint() {
        return (BStatusNumeric)this.get(outDewPoint);
    }

    public void setOutDewPoint(BStatusNumeric bStatusNumeric) {
        this.set(outDewPoint, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutEnthalpy() {
        return (BStatusNumeric)this.get(outEnthalpy);
    }

    public void setOutEnthalpy(BStatusNumeric bStatusNumeric) {
        this.set(outEnthalpy, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutSatPress() {
        return (BStatusNumeric)this.get(outSatPress);
    }

    public void setOutSatPress(BStatusNumeric bStatusNumeric) {
        this.set(outSatPress, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutVaporPress() {
        return (BStatusNumeric)this.get(outVaporPress);
    }

    public void setOutVaporPress(BStatusNumeric bStatusNumeric) {
        this.set(outVaporPress, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutWetBulbTemp() {
        return (BStatusNumeric)this.get(outWetBulbTemp);
    }

    public void setOutWetBulbTemp(BStatusNumeric bStatusNumeric) {
        this.set(outWetBulbTemp, (BValue)bStatusNumeric, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.getName().startsWith("in") || property.equals((Object)unitSelect)) {
            this.doCalculate();
        }
        if (property.equals((Object)unitSelect)) {
            this.isEnglish = this.getUnitSelect().equals((Object)BEnglishMetric.english);
            int n = this.getTemperatureFacets().geti("precision", 1);
            if (this.isEnglish) {
                this.setTemperatureFacets(BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)n));
            } else {
                this.setTemperatureFacets(BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)n));
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        this.isEnglish = this.getUnitSelect().equals((Object)BEnglishMetric.english);
        if (slot.equals((Object)inTemp) || slot.equals((Object)outDewPoint) || slot.equals((Object)outWetBulbTemp)) {
            return this.getTemperatureFacets();
        }
        if (slot.equals((Object)inHumidity)) {
            return this.getHumidityFacets();
        }
        if (slot.equals((Object)outEnthalpy)) {
            if (this.isEnglish) {
                return enthalpyEnglishFacets;
            }
            return enthalpyMetricFacets;
        }
        if (slot.equals((Object)outSatPress) || slot.equals((Object)outVaporPress)) {
            if (this.isEnglish) {
                return pressureEnglishFacets;
            }
            return pressureMetricFacets;
        }
        return super.getSlotFacets(slot);
    }

    public void atSteadyState() {
        this.doCalculate();
    }

    public void doCalculate() {
        boolean bl;
        this.isEnglish = this.getUnitSelect().equals((Object)BEnglishMetric.english);
        float f = this.getInTempEnglish();
        float f2 = (float)this.getInHumidity().getValue();
        BStatusNumeric bStatusNumeric = new BStatusNumeric();
        BStatusNumeric bStatusNumeric2 = new BStatusNumeric();
        BStatusNumeric bStatusNumeric3 = new BStatusNumeric();
        BStatusNumeric bStatusNumeric4 = new BStatusNumeric();
        BStatusNumeric bStatusNumeric5 = new BStatusNumeric();
        boolean bl2 = false;
        if (this.isTempValid() && this.isRHValid()) {
            bl2 = true;
        }
        if (bl = bl2) {
            bStatusNumeric.setValue((double)Psychrometric.dewpointTemperature(f, f2));
            bStatusNumeric2.setValue((double)Psychrometric.enthalpy(f, f2));
            bStatusNumeric3.setValue((double)Psychrometric.vaporPressure(f, f2));
            bStatusNumeric4.setValue((double)Psychrometric.wetbulbTemperature(f, f2));
        } else {
            bStatusNumeric.setValue(Double.NaN);
            bStatusNumeric2.setValue(Double.NaN);
            bStatusNumeric3.setValue(Double.NaN);
            bStatusNumeric4.setValue(Double.NaN);
        }
        bStatusNumeric.setStatus(BStatus.makeFault((BStatus)this.getOutDewPoint().getStatus(), (boolean)(bl ^ true)));
        bStatusNumeric2.setStatus(BStatus.makeFault((BStatus)this.getOutEnthalpy().getStatus(), (boolean)(bl ^ true)));
        bStatusNumeric3.setStatus(BStatus.makeFault((BStatus)this.getOutVaporPress().getStatus(), (boolean)(bl ^ true)));
        bStatusNumeric4.setStatus(BStatus.makeFault((BStatus)this.getOutWetBulbTemp().getStatus(), (boolean)(bl ^ true)));
        if (this.isTempValid()) {
            bStatusNumeric5.setValue((double)Psychrometric.saturationPressure(f));
        } else {
            bStatusNumeric5.setValue(Double.NaN);
        }
        bStatusNumeric5.setStatus(BStatus.makeFault((BStatus)this.getOutSatPress().getStatus(), (boolean)(this.isTempValid() ^ true)));
        if (!this.isEnglish) {
            bStatusNumeric.setValue(this.convertTemp(bStatusNumeric.getValue()));
            bStatusNumeric2.setValue(this.convertEnthalpy(bStatusNumeric2.getValue()));
            bStatusNumeric3.setValue(this.convertPress(bStatusNumeric3.getValue()));
            bStatusNumeric4.setValue(this.convertTemp(bStatusNumeric4.getValue()));
            bStatusNumeric5.setValue(this.convertPress(bStatusNumeric5.getValue()));
        }
        this.setOutDewPoint(bStatusNumeric);
        this.setOutEnthalpy(bStatusNumeric2);
        this.setOutVaporPress(bStatusNumeric3);
        this.setOutWetBulbTemp(bStatusNumeric4);
        this.setOutSatPress(bStatusNumeric5);
    }

    private final boolean isTempValid() {
        boolean bl = false;
        if (this.getInTemp().getStatus().isValid() && Psychrometric.isTempValid(this.getInTempEnglish())) {
            bl = true;
        }
        return bl;
    }

    private final boolean isRHValid() {
        boolean bl = false;
        if (this.getInHumidity().getStatus().isValid() && Psychrometric.isRHValid((float)this.getInHumidity().getValue())) {
            bl = true;
        }
        return bl;
    }

    private final float getInTempEnglish() {
        float f = (float)this.getInTemp().getValue();
        if (this.isEnglish) {
            return f;
        }
        return 1.8f * f + 32.0f;
    }

    private final double convertTemp(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return (d - 32.0) * fiveNineths;
    }

    private final double convertEnthalpy(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return (d - 7.68152) * 2.326;
    }

    private final double convertPress(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return d * 6.89475729;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.ticket = null;
        this.isEnglish = true;
    }

    public BPsychrometric() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$energy$BPsychrometric;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$energy$BPsychrometric = BPsychrometric.class("[Lcom.tridium.kitControl.energy.BPsychrometric;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        fiveNineths = 0.5555555555555556;
        pressureEnglishFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"pounds per square inch"), (int)3);
        pressureMetricFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilopascal"), (int)3);
        enthalpyEnglishFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)3);
        enthalpyMetricFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilojoule per kilogram"), (int)3);
    }
}

