/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import com.tridium.kitControl.enums.BNightPurgeMode;
import com.tridium.kitControl.hvac.Psychrometric;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNightPurge
extends BComponent {
    public static final Property temperatureFacets = BNightPurge.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    public static final Property humidityFacets = BNightPurge.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent relative humidity"), (int)1), null);
    public static final Property purgeEnabled = BNightPurge.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property outsideTemp = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property outsideHumidity = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property insideTemp = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property insideHumidity = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property lowTemperatureLimit = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property nightSetpoint = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property outsideEnthalpy = BNightPurge.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)2));
    public static final Property insideEnthalpy = BNightPurge.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)2));
    public static final Property freeCooling = BNightPurge.newProperty((int)11, (BValue)new BStatusBoolean(), null);
    public static final Property currentMode = BNightPurge.newProperty((int)11, (BValue)new BStatusEnum((BEnum)BNightPurgeMode.disabled), null);
    public static final Property setpointDeadband = BNightPurge.newProperty((int)0, (float)1.0f, null);
    public static final Property thresholdSpan = BNightPurge.newProperty((int)0, (float)1.0f, null);
    public static final Property useEnthalpy = BNightPurge.newProperty((int)0, (boolean)true, null);
    public static final Property freeCoolingCommand = BNightPurge.newProperty((int)0, (boolean)true, null);
    public static final Property useNullOutput = BNightPurge.newProperty((int)0, (boolean)true, null);
    public static final Action calculate = BNightPurge.newAction((int)4, null);
    public static final Type TYPE;
    private static final int DISABLED = 0;
    private static final int INPUT_ERROR = 1;
    private static final int LOW_TEMPERATURE = 2;
    private static final int ENTHALPY_NO_FREE_COOLING = 3;
    private static final int ENTHALPY_FREE_COOLING = 4;
    private static final int TEMP_NO_FREE_COOLING = 5;
    private static final int TEMP_FREE_COOLING = 6;
    private static final int SATISFIED = 7;
    int mode;
    Clock.Ticket ticket;
    static /* synthetic */ Class class$com$tridium$kitControl$energy$BNightPurge;

    public BFacets getTemperatureFacets() {
        return (BFacets)this.get(temperatureFacets);
    }

    public void setTemperatureFacets(BFacets bFacets) {
        this.set(temperatureFacets, (BValue)bFacets, null);
    }

    public BFacets getHumidityFacets() {
        return (BFacets)this.get(humidityFacets);
    }

    public void setHumidityFacets(BFacets bFacets) {
        this.set(humidityFacets, (BValue)bFacets, null);
    }

    public BStatusBoolean getPurgeEnabled() {
        return (BStatusBoolean)this.get(purgeEnabled);
    }

    public void setPurgeEnabled(BStatusBoolean bStatusBoolean) {
        this.set(purgeEnabled, (BValue)bStatusBoolean, null);
    }

    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    public void setOutsideTemp(BStatusNumeric bStatusNumeric) {
        this.set(outsideTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutsideHumidity() {
        return (BStatusNumeric)this.get(outsideHumidity);
    }

    public void setOutsideHumidity(BStatusNumeric bStatusNumeric) {
        this.set(outsideHumidity, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getInsideTemp() {
        return (BStatusNumeric)this.get(insideTemp);
    }

    public void setInsideTemp(BStatusNumeric bStatusNumeric) {
        this.set(insideTemp, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getInsideHumidity() {
        return (BStatusNumeric)this.get(insideHumidity);
    }

    public void setInsideHumidity(BStatusNumeric bStatusNumeric) {
        this.set(insideHumidity, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getLowTemperatureLimit() {
        return (BStatusNumeric)this.get(lowTemperatureLimit);
    }

    public void setLowTemperatureLimit(BStatusNumeric bStatusNumeric) {
        this.set(lowTemperatureLimit, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getNightSetpoint() {
        return (BStatusNumeric)this.get(nightSetpoint);
    }

    public void setNightSetpoint(BStatusNumeric bStatusNumeric) {
        this.set(nightSetpoint, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getOutsideEnthalpy() {
        return (BStatusNumeric)this.get(outsideEnthalpy);
    }

    public void setOutsideEnthalpy(BStatusNumeric bStatusNumeric) {
        this.set(outsideEnthalpy, (BValue)bStatusNumeric, null);
    }

    public BStatusNumeric getInsideEnthalpy() {
        return (BStatusNumeric)this.get(insideEnthalpy);
    }

    public void setInsideEnthalpy(BStatusNumeric bStatusNumeric) {
        this.set(insideEnthalpy, (BValue)bStatusNumeric, null);
    }

    public BStatusBoolean getFreeCooling() {
        return (BStatusBoolean)this.get(freeCooling);
    }

    public void setFreeCooling(BStatusBoolean bStatusBoolean) {
        this.set(freeCooling, (BValue)bStatusBoolean, null);
    }

    public BStatusEnum getCurrentMode() {
        return (BStatusEnum)this.get(currentMode);
    }

    public void setCurrentMode(BStatusEnum bStatusEnum) {
        this.set(currentMode, (BValue)bStatusEnum, null);
    }

    public float getSetpointDeadband() {
        return this.getFloat(setpointDeadband);
    }

    public void setSetpointDeadband(float f) {
        this.setFloat(setpointDeadband, f, null);
    }

    public float getThresholdSpan() {
        return this.getFloat(thresholdSpan);
    }

    public void setThresholdSpan(float f) {
        this.setFloat(thresholdSpan, f, null);
    }

    public boolean getUseEnthalpy() {
        return this.getBoolean(useEnthalpy);
    }

    public void setUseEnthalpy(boolean bl) {
        this.setBoolean(useEnthalpy, bl, null);
    }

    public boolean getFreeCoolingCommand() {
        return this.getBoolean(freeCoolingCommand);
    }

    public void setFreeCoolingCommand(boolean bl) {
        this.setBoolean(freeCoolingCommand, bl, null);
    }

    public boolean getUseNullOutput() {
        return this.getBoolean(useNullOutput);
    }

    public void setUseNullOutput(boolean bl) {
        this.setBoolean(useNullOutput, bl, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals((Object)purgeEnabled) || property.equals((Object)nightSetpoint) || property.equals((Object)lowTemperatureLimit) || property.equals((Object)outsideTemp) || property.equals((Object)outsideHumidity) || property.equals((Object)insideTemp) || property.equals((Object)insideHumidity) || property.equals((Object)thresholdSpan) || property.equals((Object)freeCoolingCommand) || property.equals((Object)useEnthalpy)) {
            this.doCalculate();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)insideTemp) || slot.equals((Object)outsideTemp) || slot.equals((Object)nightSetpoint) || slot.equals((Object)setpointDeadband) || slot.equals((Object)lowTemperatureLimit)) {
            return this.getTemperatureFacets();
        }
        if (slot.equals((Object)insideHumidity) || slot.equals((Object)outsideHumidity)) {
            return this.getHumidityFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void atSteadyState() {
        this.doCalculate();
    }

    public void doCalculate() {
        double d = this.getNightSetpoint().getValue();
        if (!this.getPurgeEnabled().getValue()) {
            this.setOutput(false);
            this.mode = 0;
        } else if (!(this.getOutsideTemp().getStatus().isValid() && this.getOutsideHumidity().getStatus().isValid() && this.getInsideTemp().getStatus().isValid() && this.getInsideHumidity().getStatus().isValid())) {
            this.mode = 1;
        } else if (this.getOutsideTemp().getValue() < this.getLowTemperatureLimit().getValue()) {
            this.mode = 2;
        } else {
            if (this.mode == 7) {
                d = this.getNightSetpoint().getValue() + (double)this.getSetpointDeadband();
            }
            if (this.getInsideTemp().getValue() < d) {
                this.mode = 7;
            } else if (this.getUseEnthalpy()) {
                this.getOutsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getOutsideTemp().getValue(), (float)this.getOutsideHumidity().getValue()));
                this.getInsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getInsideTemp().getValue(), (float)this.getInsideHumidity().getValue()));
                boolean bl = false;
                if (this.getOutsideEnthalpy().getValue() <= 0.0) {
                    bl = true;
                }
                boolean bl2 = bl;
                this.getOutsideEnthalpy().setStatus(BStatus.makeFault((BStatus)BStatus.make((int)0), (boolean)bl2));
                boolean bl3 = false;
                if (this.getInsideEnthalpy().getValue() <= 0.0) {
                    bl3 = true;
                }
                boolean bl4 = bl3;
                this.getInsideEnthalpy().setStatus(BStatus.makeFault((BStatus)BStatus.make((int)0), (boolean)bl4));
                if (bl2 || bl4) {
                    this.mode = 1;
                } else if (this.getOutsideEnthalpy().getValue() >= this.getInsideEnthalpy().getValue()) {
                    this.mode = 3;
                } else if (this.getOutsideEnthalpy().getValue() <= this.getInsideEnthalpy().getValue() - Math.abs((double)this.getThresholdSpan())) {
                    this.mode = 4;
                }
            } else {
                this.getOutsideEnthalpy().setValue(0.0);
                this.getInsideEnthalpy().setValue(0.0);
                this.getOutsideEnthalpy().setStatus(BStatus.make((int)0, (BFacets)BFacets.make((String)"unused", (boolean)true)));
                this.getInsideEnthalpy().setStatus(BStatus.make((int)0, (BFacets)BFacets.make((String)"unused", (boolean)true)));
                if (this.getOutsideTemp().getValue() >= this.getInsideTemp().getValue()) {
                    this.mode = 5;
                } else if (this.getOutsideTemp().getValue() <= this.getInsideTemp().getValue() - Math.abs((double)this.getThresholdSpan())) {
                    this.mode = 6;
                }
            }
        }
        switch (this.mode) {
            case 0: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.disabled);
                break;
            }
            case 1: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.inputError);
                break;
            }
            case 2: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.lowTemperature);
                break;
            }
            case 3: 
            case 5: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.noFreeCooling);
                break;
            }
            case 4: 
            case 6: {
                this.setOutput(true);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.freeCooling);
                break;
            }
            case 7: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.satisfied);
                break;
            }
        }
    }

    private final void setOutput(boolean bl) {
        if (bl) {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand(), BStatus.ok));
        } else if (this.getUseNullOutput()) {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand() ^ true, BStatus.nullStatus));
        } else {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand() ^ true, BStatus.ok));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mode = 0;
        this.ticket = null;
    }

    public BNightPurge() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$kitControl$energy$BNightPurge;
        if (clazz == null) {
            clazz = class$com$tridium$kitControl$energy$BNightPurge = BNightPurge.class("[Lcom.tridium.kitControl.energy.BNightPurge;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

