/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.nv.cache.BNvaEntry;
import java.util.Comparator;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NvaEncoder {
    private static final BString version = BString.make((String)"1.0.0.0");
    private static final String fileName = "cache";
    private static final int defaultNvaFileEntryLimit = 3000;
    private static int nvaFileEntryLimit = 3000;
    private BOrd dirOrd;
    private BFileSpace space;
    private BDirectory dir;
    private BComponent root;
    private int limit;
    private int count;
    static /* synthetic */ Class class$javax$baja$file$BIFile;

    public static final NvaEncoder make(BFileSpace bFileSpace, BOrd bOrd) {
        return new NvaEncoder(bFileSpace, bOrd);
    }

    public static final NvaEncoder make(BOrd bOrd) {
        return NvaEncoder.make((BFileSpace)BFileSystem.INSTANCE, bOrd);
    }

    public final void add(BNvaEntry bNvaEntry) throws Exception {
        if (this.root == null) {
            this.root = new BComponent();
            this.root.add("version", (BValue)version, 1);
        }
        this.root.add("entry?", (BValue)bNvaEntry, 1);
        if (++this.limit >= nvaFileEntryLimit) {
            this.save();
        }
    }

    public final void close() throws Exception {
        this.save();
    }

    private final void initDir() throws Exception {
        FilePath filePath = null;
        OrdQuery[] ordQueryArray = this.dirOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n] instanceof FilePath) {
                filePath = (FilePath)ordQueryArray[n];
                break;
            }
            ++n;
        }
        if (filePath == null) {
            throw new Exception("Could not find valid path in Cache Directory ORD!");
        }
        BIFile bIFile = this.space.findFile(filePath);
        if (bIFile == null) {
            bIFile = this.space.makeDir(filePath);
        }
        if (!bIFile.isDirectory()) {
            throw new Exception("Cache Dir does not point to a valid Directory!");
        }
        this.dir = (BDirectory)bIFile;
        BIFile[] bIFileArray = NvaEncoder.getCacheFilesFromDir((BIDirectory)this.dir);
        int n2 = 0;
        while (n2 < bIFileArray.length) {
            bIFileArray[n2].delete();
            ++n2;
        }
    }

    private final void save() throws Exception {
        if (this.dir == null) {
            this.initDir();
        }
        if (this.root == null) {
            return;
        }
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        FilePath filePath = this.dir.getFilePath().merge(fileName + String.valueOf(++this.count) + ".nva");
        BIFile bIFile = bFileSystem.findFile(filePath);
        if (bIFile != null) {
            bIFile.delete();
        }
        bIFile = bFileSystem.makeFile(filePath);
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(bIFile.getOutputStream());
        valueDocEncoder.setZipped(true);
        valueDocEncoder.encodeDocument((BValue)this.root);
        valueDocEncoder.close();
        this.root = null;
        this.limit = 0;
    }

    static final BIFile[] getCacheFilesFromDir(BIDirectory bIDirectory) {
        Class clazz = class$javax$baja$file$BIFile;
        if (clazz == null) {
            clazz = class$javax$baja$file$BIFile = NvaEncoder.class("[Ljavax.baja.file.BIFile;", false);
        }
        Array array = new Array(clazz);
        array.addAll((Object[])bIDirectory.listFiles());
        array = array.filter(new IFilter(){

            public final boolean accept(Object object) {
                BIFile bIFile = (BIFile)object;
                return bIFile.getExtension().toLowerCase().equals("nva");
            }
        });
        array = array.sort(new Comparator(){

            public final int compare(Object object, Object object2) {
                int n;
                BIFile bIFile = (BIFile)object;
                BIFile bIFile2 = (BIFile)object2;
                int n2 = NvaEncoder.parseOutInt(bIFile.getFileName());
                if (n2 == (n = NvaEncoder.parseOutInt(bIFile2.getFileName()))) {
                    return 0;
                }
                if (n2 < n) {
                    return -1;
                }
                return 1;
            }
        });
        return (BIFile[])array.trim();
    }

    private static final int parseOutInt(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] >= '0' && cArray[n] <= '9') {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append('0');
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.root = null;
        this.limit = 0;
        this.count = 0;
    }

    private NvaEncoder(BFileSpace bFileSpace, BOrd bOrd) {
        this.this();
        this.space = bFileSpace;
        this.dirOrd = bOrd;
    }

    static {
        String string = System.getProperty("niagara.niagaraVirtuals.nvaFileEntryLimit", String.valueOf(3000));
        try {
            nvaFileEntryLimit = Integer.parseInt(string);
            if (nvaFileEntryLimit < 5) {
                nvaFileEntryLimit = 5;
            }
        }
        catch (NumberFormatException numberFormatException) {
            nvaFileEntryLimit = 3000;
        }
    }
}

