/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.nv.BSlotInfo;
import com.tridium.nv.cache.BNiagaraVirtualCache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDefaultNiagaraVirtualCache
extends BNiagaraVirtualCache {
    public static final Property persistCache = BDefaultNiagaraVirtualCache.newProperty((int)0, (boolean)true, null);
    public static final Property cacheDirectory = BDefaultNiagaraVirtualCache.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IDirectory"));
    public static final Type TYPE;
    private static final Log log;
    private static final int defaultHardReferenceLimit = 1000;
    private static int hardReferenceLimit;
    private static boolean useSoftRefs;
    private BAbsTime lastUpdate;
    private BAbsTime lastLookup;
    private RefMap refMap;
    static /* synthetic */ Class class$com$tridium$nv$cache$BDefaultNiagaraVirtualCache;

    public final boolean getPersistCache() {
        return this.getBoolean(persistCache);
    }

    public final void setPersistCache(boolean bl) {
        this.setBoolean(persistCache, bl, null);
    }

    public final BOrd getCacheDirectory() {
        return (BOrd)this.get(cacheDirectory);
    }

    public final void setCacheDirectory(BOrd bOrd) {
        this.set(cacheDirectory, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void stopped() throws Exception {
        this.saveToFiles();
    }

    public final void atSteadyState() throws Exception {
        this.getVirtualPolicies().postAsync(new Runnable(){

            public final void run() {
                BDefaultNiagaraVirtualCache.this.loadFromFiles();
            }
        });
    }

    public final void update(String string, BOrd bOrd, BSlotInfo bSlotInfo) {
        if (log.isTraceOn()) {
            log.trace("Updating Cache: " + string + ' ' + bOrd);
        }
        this.lastUpdate = BAbsTime.now();
        this.refMap.put(new Key(string, bOrd), bSlotInfo);
    }

    public final BSlotInfo doLookup(String string, BOrd bOrd) throws Exception {
        if (log.isTraceOn()) {
            log.trace("Looking up from Cache: " + string + ' ' + bOrd);
        }
        this.lastLookup = BAbsTime.now();
        return this.refMap.get(new Key(string, bOrd));
    }

    protected final BNiagaraVirtualCache.CachedSlotInfo[] lookup(String string) {
        if (log.isTraceOn()) {
            log.trace("Looking up from Cache for Station: " + string);
        }
        return this.refMap.lookup(string);
    }

    public final void remove(String string, BOrd[] bOrdArray) {
        if (log.isTraceOn()) {
            int n = 0;
            while (n < bOrdArray.length) {
                log.trace("Removing from Cache: " + string + ' ' + bOrdArray[n]);
                ++n;
            }
        }
        Key[] keyArray = new Key[bOrdArray.length];
        int n = 0;
        while (n < keyArray.length) {
            keyArray[n] = new Key(string, bOrdArray[n]);
            ++n;
        }
        this.refMap.remove(keyArray);
    }

    public final void doClear() throws Exception {
        if (log.isTraceOn()) {
            log.trace("Clearing entire Cache");
        }
        this.refMap.clear();
    }

    /*
     * Exception decompiling
     */
    private final void loadFromFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 172->176)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void saveToFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 74->402)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final BOrd getDefaultCacheDirectory() {
        BOrd bOrd = this.getCacheDirectory();
        if (bOrd.isNull()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("file:^");
            stringBuffer.append(this.getVirtualPolicies().getType().getModule().getModuleName());
            stringBuffer.append("_");
            stringBuffer.append("nVirtual");
            bOrd = BOrd.make((String)stringBuffer.toString());
        }
        return bOrd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void spy(SpyWriter spyWriter) throws Exception {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            this.refMap.processQueue();
            spyWriter.startProps("Cache");
            spyWriter.prop((Object)"Size", (Object)new Long(this.getCacheSize()));
            spyWriter.prop((Object)"Hard Ref Limit", hardReferenceLimit);
            spyWriter.prop((Object)"Soft Refs Enabled", useSoftRefs);
            spyWriter.prop((Object)"Total Hard Refs", this.refMap.hardMap.size());
            spyWriter.prop((Object)"Total Soft Refs", this.refMap.softMap.size());
            spyWriter.prop((Object)"Total Collected Soft Refs", (Object)new Long(this.refMap.totalCollectedSoftReferences));
            spyWriter.prop((Object)"Last Update", (Object)this.lastUpdate);
            spyWriter.prop((Object)"Last Lookup", (Object)this.lastLookup);
            spyWriter.endProps();
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"Hard References", 11);
            spyWriter.w((Object)"<tr>");
            spyWriter.th((Object)"ORD");
            spyWriter.th((Object)"slotName");
            spyWriter.th((Object)"slotDisplayName");
            spyWriter.th((Object)"slotType");
            spyWriter.th((Object)"slotOrd");
            spyWriter.th((Object)"isFrozen");
            spyWriter.th((Object)"isComponent");
            spyWriter.th((Object)"typeSpec");
            spyWriter.th((Object)"facets");
            spyWriter.th((Object)"slotFlags");
            spyWriter.th((Object)"returnTypeSpec");
            spyWriter.w((Object)"</tr>");
            Map.Entry[] entryArray = this.refMap.hardMap.entrySet().toArray(new Map.Entry[this.refMap.hardMap.size()]);
            int n = entryArray.length - 1;
            while (true) {
                if (n < 0) {
                    spyWriter.endTable();
                    break;
                }
                spyWriter.w((Object)"<tr>");
                BOrd bOrd = ((Key)entryArray[n].getKey()).vOrd;
                BSlotInfo bSlotInfo = (BSlotInfo)((Object)entryArray[n].getValue());
                spyWriter.td((Object)bOrd);
                spyWriter.td((Object)bSlotInfo.getSlotName());
                spyWriter.td((Object)bSlotInfo.getSlotDisplayName());
                spyWriter.td((Object)bSlotInfo.getSlotType());
                spyWriter.td((Object)bSlotInfo.getSlotOrd());
                spyWriter.td((Object)BBoolean.make((boolean)bSlotInfo.getIsFrozen()));
                spyWriter.td((Object)BBoolean.make((boolean)bSlotInfo.getIsComponent()));
                spyWriter.td((Object)bSlotInfo.getTypeSpec());
                spyWriter.td((Object)bSlotInfo.getFacets());
                spyWriter.td((Object)Flags.encodeToString((int)bSlotInfo.getSlotFlags()));
                spyWriter.td((Object)bSlotInfo.getReturnTypeSpec());
                spyWriter.w((Object)"</tr><br />");
                --n;
            }
        }
        super.spy(spyWriter);
    }

    public static final void setHardReferenceLimit(int n) {
        hardReferenceLimit = Math.abs(n);
    }

    public static final void setUseSoftRefs(boolean bl) {
        useSoftRefs = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getCacheSize() {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            this.refMap.processQueue();
            return this.refMap.hardMap.size() + this.refMap.softMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getTotalCollectedSoftReferences() {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            return this.refMap.totalCollectedSoftReferences;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final BSlotInfo getMostAccessedSlotInfo() {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            Set set = this.refMap.hardMap.entrySet();
            Map.Entry[] entryArray = set.toArray(new Map.Entry[set.size()]);
            return (BSlotInfo)((Object)entryArray[set.size() - 1].getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isHardRef(String string, BOrd bOrd) throws Exception {
        RefMap refMap = this.refMap;
        synchronized (refMap) {
            boolean bl = false;
            if (this.refMap.hardMap.get(new Key(string, bOrd)) == null) return bl;
            return true;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastUpdate = BAbsTime.NULL;
        this.lastLookup = BAbsTime.NULL;
        this.refMap = new RefMap();
    }

    public BDefaultNiagaraVirtualCache() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nv$cache$BDefaultNiagaraVirtualCache;
        if (clazz == null) {
            clazz = class$com$tridium$nv$cache$BDefaultNiagaraVirtualCache = BDefaultNiagaraVirtualCache.class("[Lcom.tridium.nv.cache.BDefaultNiagaraVirtualCache;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"niagaraVirtualCache.default");
        hardReferenceLimit = 1000;
        useSoftRefs = true;
        String string = System.getProperty("niagara.niagaraVirtuals.cacheHardRefLimit", String.valueOf(1000));
        try {
            BDefaultNiagaraVirtualCache.setHardReferenceLimit(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            BDefaultNiagaraVirtualCache.setHardReferenceLimit(1000);
        }
        BDefaultNiagaraVirtualCache.setUseSoftRefs(System.getProperty("niagara.niagaraVirtuals.useSoftRefs", "true").equals("false") ^ true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Key {
        String stationName;
        BOrd vOrd;
        int hashCode;

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            boolean bl = false;
            if (((Key)object).hashCode() == this.hashCode()) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = new String(this.stationName + this.vOrd.toString()).hashCode();
            }
            return this.hashCode;
        }

        private final /* synthetic */ void this() {
            this.stationName = "";
            this.vOrd = BOrd.NULL;
            this.hashCode = -1;
        }

        Key(String string, BOrd bOrd) {
            this.this();
            this.stationName = string;
            this.vOrd = bOrd;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class RefMap {
        private Map hardMap;
        private Map softMap;
        private final ReferenceQueue queue;
        long totalCollectedSoftReferences;
        static /* synthetic */ Class class$com$tridium$nv$cache$BNiagaraVirtualCache$CachedSlotInfo;

        synchronized BSlotInfo get(Key key) {
            this.processQueue();
            BSlotInfo bSlotInfo = (BSlotInfo)((Object)this.hardMap.get(key));
            if (useSoftRefs && bSlotInfo == null) {
                SoftValue softValue = (SoftValue)this.softMap.get(key);
                if (softValue != null) {
                    bSlotInfo = (BSlotInfo)((Object)softValue.get());
                }
                if (bSlotInfo != null) {
                    this.softMap.remove(softValue);
                    this.hardMap.put(key, bSlotInfo);
                }
            }
            return bSlotInfo;
        }

        synchronized void put(Key key, BSlotInfo bSlotInfo) {
            this.processQueue();
            if (useSoftRefs) {
                this.softMap.remove(key);
            }
            this.hardMap.put(key, bSlotInfo);
        }

        synchronized void clear() {
            this.processQueue();
            this.hardMap.clear();
            this.softMap.clear();
        }

        synchronized void remove(Key[] keyArray) {
            this.processQueue();
            int n = 0;
            while (n < keyArray.length) {
                this.hardMap.remove(keyArray[n]);
                this.softMap.remove(keyArray[n]);
                ++n;
            }
        }

        synchronized BNiagaraVirtualCache.CachedSlotInfo[] lookup(String string) {
            Object object;
            Object object2;
            Class clazz = class$com$tridium$nv$cache$BNiagaraVirtualCache$CachedSlotInfo;
            if (clazz == null) {
                clazz = class$com$tridium$nv$cache$BNiagaraVirtualCache$CachedSlotInfo = RefMap.class("[Lcom.tridium.nv.cache.BNiagaraVirtualCache$CachedSlotInfo;", false);
            }
            Array array = new Array(clazz);
            this.processQueue();
            Map.Entry[] entryArray = this.hardMap.entrySet().toArray(new Map.Entry[this.hardMap.size()]);
            int n = entryArray.length - 1;
            while (n >= 0) {
                object2 = (Key)entryArray[n].getKey();
                object = (BSlotInfo)((Object)entryArray[n].getValue());
                if (((Key)object2).stationName.equals(string)) {
                    array.add((Object)new BNiagaraVirtualCache.CachedSlotInfo(((Key)object2).vOrd, (BSlotInfo)((Object)object)));
                }
                --n;
            }
            if (useSoftRefs) {
                Iterator iterator = this.softMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    object = (Key)object2.getKey();
                    BSlotInfo bSlotInfo = (BSlotInfo)((Object)((SoftValue)object2.getValue()).get());
                    if (bSlotInfo == null || !((Key)object).stationName.equals(string)) continue;
                    array.add((Object)new BNiagaraVirtualCache.CachedSlotInfo(((Key)object).vOrd, bSlotInfo));
                }
            }
            return (BNiagaraVirtualCache.CachedSlotInfo[])array.trim();
        }

        /*
         * Unable to fully structure code
         */
        private final void processQueue() {
            if (BDefaultNiagaraVirtualCache.access$1()) ** GOTO lbl7
            return;
lbl-1000:
            // 1 sources

            {
                this.softMap.remove(SoftValue.access$0(var1_1));
                if (++this.totalCollectedSoftReferences != 0x7FFFFFFFFFFFFFFFL) continue;
                this.totalCollectedSoftReferences = 0L;
lbl7:
                // 3 sources

                ** while ((var1_1 = (SoftValue)this.queue.poll()) != null)
            }
lbl8:
            // 1 sources

        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.hardMap = new LinkedHashMap(16, 0.75f, true){

                protected final boolean removeEldestEntry(Map.Entry entry) {
                    if (this.size() > hardReferenceLimit) {
                        if (useSoftRefs) {
                            SoftValue softValue = new SoftValue((Key)entry.getKey(), (BSlotInfo)((Object)entry.getValue()), RefMap.this.queue);
                            RefMap.this.softMap.put(softValue.key, softValue);
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.softMap = new LinkedHashMap();
            this.queue = new ReferenceQueue();
            this.totalCollectedSoftReferences = 0L;
        }

        private RefMap() {
            this.this();
        }
    }

    private static class SoftValue
    extends SoftReference {
        private final Key key;

        SoftValue(Key key, BSlotInfo bSlotInfo, ReferenceQueue referenceQueue) {
            super(bSlotInfo, referenceQueue);
            this.key = key;
        }
    }
}

