/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.VirtualSlotNameParser;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class VirtualSlotNameBuilder {
    private String slotName;
    private boolean frozen;
    private boolean isComponent;
    private String typeSpec;
    private BFacets facets;
    private int flags;
    private boolean isAction;
    private String returnTypeSpec;

    public static final VirtualSlotNameBuilder make() {
        return new VirtualSlotNameBuilder();
    }

    public static final VirtualSlotNameBuilder make(BComplex bComplex, String string) throws Exception {
        return VirtualSlotNameBuilder.make(bComplex, string, true);
    }

    public static final VirtualSlotNameBuilder make(BComplex bComplex, String string, boolean bl) throws Exception {
        Action action;
        Slot slot = bComplex.getSlot(string);
        if (slot == null) {
            throw new Exception("Slot doesn't exist!");
        }
        if (slot.isTopic()) {
            throw new Exception("Topics not supported by Niagara Virtuals");
        }
        VirtualSlotNameBuilder virtualSlotNameBuilder = VirtualSlotNameBuilder.make();
        virtualSlotNameBuilder.setSlotName(string);
        virtualSlotNameBuilder.setFrozen(slot.isFrozen());
        if (slot.isAction()) {
            Type type;
            virtualSlotNameBuilder.setIsAction(true);
            action = slot.asAction();
            Type type2 = action.getParameterType();
            if (type2 != null) {
                virtualSlotNameBuilder.setTypeSpec(type2.toString());
            }
            if ((type = action.getReturnType()) != null) {
                virtualSlotNameBuilder.setReturnTypeSpec(type.toString());
            }
        } else if (slot.isProperty()) {
            action = bComplex.get(slot.asProperty());
            virtualSlotNameBuilder.setTypeSpec(action.getType().toString());
            if (action instanceof BComponent) {
                virtualSlotNameBuilder.setIsComponent(true);
            }
        }
        if (!virtualSlotNameBuilder.isComponent) {
            virtualSlotNameBuilder.setFlags(bComplex.getFlags(slot));
            action = bComplex.getSlotFacets(slot);
            action = BFacets.make((BFacets)action, (String)"nVirtualW", (BIDataValue)BBoolean.make((boolean)bl));
            virtualSlotNameBuilder.setFacets((BFacets)action);
        }
        return virtualSlotNameBuilder;
    }

    public static final BOrd buildVirtualSlotPath(OrdTarget ordTarget) throws Exception {
        BComponent bComponent = ordTarget.getComponent();
        SlotPath slotPath = bComponent.getSlotPath();
        if (slotPath == null) {
            throw new Exception("No valid Slot Path available!");
        }
        bComponent = (BComponent)BOrd.make((String)"station:|slot:/").get((BObject)bComponent);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("virtual:");
        String[] stringArray = slotPath.getNames();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("/");
            stringBuffer.append(SlotPath.unescape((String)VirtualSlotNameBuilder.make((BComplex)bComponent, stringArray[n]).buildName()));
            bComponent = (BComponent)bComponent.get(stringArray[n]);
            ++n;
        }
        Slot slot = ordTarget.getSlotInComponent();
        if (slot != null && slot.isAction()) {
            stringBuffer.append("/");
            stringBuffer.append(SlotPath.unescape((String)VirtualSlotNameBuilder.make((BComplex)bComponent, slot.getName()).buildName()));
        } else {
            Property[] propertyArray = ordTarget.getPropertyPathInComponent();
            if (propertyArray != null) {
                BComponent bComponent2 = bComponent;
                boolean bl = false;
                int n2 = 0;
                while (n2 < propertyArray.length) {
                    BValue bValue = bComponent2.get(propertyArray[n2]);
                    stringBuffer.append("/");
                    if (bl) {
                        stringBuffer.append(propertyArray[n2].getName());
                    } else {
                        stringBuffer.append(SlotPath.unescape((String)VirtualSlotNameBuilder.make((BComplex)bComponent2, propertyArray[n2].getName()).buildName()));
                    }
                    if (bValue.isComplex()) {
                        bComponent2 = (BComplex)bValue;
                        if (!bl && bValue.isStruct()) {
                            bl = true;
                        }
                    }
                    ++n2;
                }
            }
        }
        return BOrd.make((String)stringBuffer.toString());
    }

    public final void setSlotName(String string) {
        this.slotName = string;
    }

    public final void setFrozen(boolean bl) {
        this.frozen = bl;
    }

    public final void setIsComponent(boolean bl) {
        this.isComponent = bl;
    }

    public final void setTypeSpec(String string) {
        this.typeSpec = string;
    }

    public final void setFacets(BFacets bFacets) {
        this.facets = bFacets;
    }

    public final void setFlags(int n) {
        this.flags = n;
    }

    public final void setIsAction(boolean bl) {
        this.isAction = bl;
    }

    public final void setReturnTypeSpec(String string) {
        this.returnTypeSpec = string;
    }

    public final String buildName() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(VirtualSlotNameParser.escape(this.slotName));
        stringBuffer.append(';');
        stringBuffer.append(this.frozen ? (char)'f' : 'd');
        if (this.isComponent) {
            stringBuffer.append(';');
            stringBuffer.append('c');
            stringBuffer.append(';');
            stringBuffer.append(VirtualSlotNameParser.escape(this.typeSpec));
        } else {
            stringBuffer.append(';');
            stringBuffer.append(this.isAction ? (char)'a' : 'p');
            stringBuffer.append(';');
            stringBuffer.append(VirtualSlotNameParser.escape(this.typeSpec));
            stringBuffer.append(';');
            stringBuffer.append(this.flags);
            stringBuffer.append(';');
            stringBuffer.append(VirtualSlotNameParser.escape(this.facets.encodeToString()));
            if (this.isAction) {
                stringBuffer.append(';');
                stringBuffer.append(VirtualSlotNameParser.escape(this.returnTypeSpec));
            }
        }
        return SlotPath.escape((String)stringBuffer.toString());
    }

    private final /* synthetic */ void this() {
        this.slotName = "";
        this.frozen = false;
        this.isComponent = false;
        this.typeSpec = "";
        this.facets = BFacets.NULL;
        this.flags = 0;
        this.isAction = false;
        this.returnTypeSpec = "";
    }

    private VirtualSlotNameBuilder() {
        this.this();
    }
}

