/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.INiagaraVirtualCommsAdapter;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.NiagaraVirtualAddOp;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.cache.BNiagaraVirtualCache;
import com.tridium.sys.schema.ComponentSlotMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.virtual.VirtualPath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BNiagaraVirtualGateway
extends BVirtualGateway {
    public static final Action refresh = BNiagaraVirtualGateway.newAction((int)256, null);
    public static final Type TYPE;
    private static boolean disableAddVirtualSlot;
    private static boolean disableEnsureVirtualsLoaded;
    private boolean licensed;
    private INiagaraVirtualStationAdapter adapter;
    private IVirtualRootFactory rootFactory;
    private BIcon icon;
    private INiagaraVirtualCommsAdapter commsAdapter;
    static /* synthetic */ Class class$com$tridium$nv$BNiagaraVirtualGateway;
    static /* synthetic */ Class class$com$tridium$nv$BNiagaraVirtualComponent;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$sys$Property;
    static /* synthetic */ Class class$javax$baja$naming$BOrd;

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 11) {
            this.fwNvStarted();
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private final void fwNvStarted() {
        this.licensed = this.getNiagaraVirtualPolicies().isLicensed();
    }

    public final BIcon getIcon() {
        if (this.icon == null) {
            return super.getIcon();
        }
        return this.icon;
    }

    public final void setIcon(BIcon bIcon) {
        this.icon = bIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doClientClosed() {
        BNiagaraVirtualComponent bNiagaraVirtualComponent = this.getRootComponent();
        if (bNiagaraVirtualComponent == null) return;
        Class clazz = class$com$tridium$nv$BNiagaraVirtualComponent;
        if (clazz == null) {
            clazz = class$com$tridium$nv$BNiagaraVirtualComponent = BNiagaraVirtualGateway.class("[Lcom.tridium.nv.BNiagaraVirtualComponent;", false);
        }
        Array array = new Array(clazz);
        NiagaraVirtualUtil.findVirtualComponents(array, bNiagaraVirtualComponent);
        BNiagaraVirtualComponent[] bNiagaraVirtualComponentArray = (BNiagaraVirtualComponent[])array.trim();
        Object object = this.adapter.getStateLock();
        synchronized (object) {
            int n = 0;
            while (n < bNiagaraVirtualComponentArray.length) {
                bNiagaraVirtualComponentArray[n].close();
                ++n;
            }
            return;
        }
    }

    protected final Property addVirtualSlot(BVirtualComponent bVirtualComponent, String string) {
        PartialSlotInfo[] partialSlotInfoArray;
        if (!this.isLicensed()) {
            return null;
        }
        if (!this.adapter.isVirtualsEnabled()) {
            return null;
        }
        if (this.adapter.getStationStatus().getStatus().isDisabled()) {
            return null;
        }
        if (disableAddVirtualSlot) {
            this.adapter.getLog().message("addVirtualSlot disabled via System.properties setting");
            return null;
        }
        BNiagaraVirtualComponent bNiagaraVirtualComponent = (BNiagaraVirtualComponent)bVirtualComponent;
        BOrd bOrd = bNiagaraVirtualComponent.formVirtualOrd(string);
        BSlotInfo bSlotInfo = null;
        try {
            bSlotInfo = this.getNiagaraVirtualPolicies().getCache().lookup(this.adapter.getStationName(), bOrd);
        }
        catch (Exception exception) {
            this.adapter.getLog().error("Add Virtual Slot: Error looking up from Cache", (Throwable)exception);
        }
        if (bSlotInfo == null) {
            try {
                if (this.commsAdapter.isTraceOn()) {
                    this.commsAdapter.trace("Add Virtual Slot: Running Partial Discovery");
                }
                if ((partialSlotInfoArray = this.getComms().loadPartial(this.getRootComponent().getNiagaraVirtualCompInfo().getSlotOrd(), new BOrd[]{bOrd}, "addVirtualSlot")).length > 0) {
                    bSlotInfo = partialSlotInfoArray[0].getSlotInfo();
                    this.getNiagaraVirtualPolicies().getCache().update(this.adapter.getStationName(), bOrd, bSlotInfo);
                }
            }
            catch (Exception exception) {
                this.commsAdapter.error("Add Virtual Slot: Opening connection for partially loading virtual information", exception);
            }
        }
        partialSlotInfoArray = null;
        if (bSlotInfo != null) {
            String string2 = SlotPath.escape((String)string);
            partialSlotInfoArray = NiagaraVirtualAddOp.make(bSlotInfo, string2).run(bNiagaraVirtualComponent);
            if (partialSlotInfoArray != null) {
                if (this.adapter.getLog().isTraceOn()) {
                    this.adapter.getLog().trace("Add Virtual Slot: " + bOrd);
                }
            } else if (this.adapter.getLog().isTraceOn()) {
                this.adapter.getLog().trace("Add Virtual Slot: Could not add new Property: " + bOrd);
            }
        } else if (this.adapter.getLog().isTraceOn()) {
            this.adapter.getLog().trace("Add Virtual Slot: Could not find Slot Information: " + bOrd);
        }
        return partialSlotInfoArray;
    }

    public final void loadVirtualSlots(BVirtualComponent bVirtualComponent) {
        this.loadVirtualSlots(((BNiagaraVirtualComponent)bVirtualComponent).getNiagaraVirtualCompInfo().getSlotOrd(), bVirtualComponent);
    }

    private final void loadVirtualSlots(BOrd bOrd, BVirtualComponent bVirtualComponent) {
        Property[] propertyArray;
        if (this.commsAdapter.isTraceOn()) {
            this.commsAdapter.trace("Load Virtual Slots: " + bOrd + " -> " + bVirtualComponent.getName());
        }
        BSlotInfo[] bSlotInfoArray = new BSlotInfo[]{};
        BNiagaraVirtualComponent bNiagaraVirtualComponent = (BNiagaraVirtualComponent)bVirtualComponent;
        if (this.adapter.getStationStatus().isDisabled()) {
            bNiagaraVirtualComponent.discoveryFail("Niagara Station is disabled (" + Sys.getStation().getStationName() + ") -> " + this.adapter.getStationName(), false);
            return;
        }
        if (!this.adapter.isVirtualsEnabled()) {
            bNiagaraVirtualComponent.discoveryFail("Niagara Virtual Components are disabled (" + Sys.getStation().getStationName() + ") -> " + this.adapter.getStationName(), false);
            return;
        }
        if (!this.isLicensed()) {
            bNiagaraVirtualComponent.discoveryFail("Niagara Virtual Components are not licensed! (" + Sys.getStation().getStationName() + ')', true);
            return;
        }
        try {
            bSlotInfoArray = this.getComms().loadSlots(bOrd, "loadVirtualSlots: " + bNiagaraVirtualComponent.getVirtualOrd().toString());
            bNiagaraVirtualComponent.niagaraVirtualCompCheckActions();
            bNiagaraVirtualComponent.discoveryOk();
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "";
            }
            bNiagaraVirtualComponent.discoveryFail(string, true);
            this.commsAdapter.error("Load Virtual Slots: Opening Connection for loadSlots: " + string, exception);
            return;
        }
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BNiagaraVirtualGateway.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        BNiagaraVirtualCache bNiagaraVirtualCache = this.getNiagaraVirtualPolicies().getCache();
        boolean bl = false;
        int n = 0;
        while (n < bSlotInfoArray.length) {
            propertyArray = bSlotInfoArray[n].getSlotName();
            try {
                bNiagaraVirtualCache.update(this.adapter.getStationName(), bNiagaraVirtualComponent.formVirtualOrd(SlotPath.unescape((String)propertyArray)), bSlotInfoArray[n]);
            }
            catch (Exception exception) {
                this.adapter.getLog().error("Load Virtual Slots: Updating Cache with Slot Information " + bSlotInfoArray[n].getName(), (Throwable)exception);
            }
            if (NiagaraVirtualAddOp.make(bSlotInfoArray[n], (String)propertyArray).run(bNiagaraVirtualComponent) == null) {
                bl = true;
            }
            array.add((Object)propertyArray);
            ++n;
        }
        if (bl) {
            Class clazz2 = class$javax$baja$sys$Property;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$sys$Property = BNiagaraVirtualGateway.class("[Ljavax.baja.sys.Property;", false);
            }
            Array array2 = new Array(clazz2);
            propertyArray = bNiagaraVirtualComponent.getDynamicPropertiesArray();
            int n2 = 0;
            while (n2 < propertyArray.length) {
                if (propertyArray[n2].isAction()) {
                    array.add((Object)propertyArray[n2].getName());
                }
                ++n2;
            }
            final String[] stringArray = (String[])array.trim();
            array2.addAll((Object[])bNiagaraVirtualComponent.getDynamicPropertiesArray());
            array2 = array2.sort(new Comparator(){

                public final int compare(Object object, Object object2) {
                    Property property = (Property)object;
                    Property property2 = (Property)object2;
                    int n = -1;
                    int n2 = -1;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].equals(property.getName())) {
                            n = n3;
                        } else if (stringArray[n3].equals(property2.getName())) {
                            n2 = n3;
                        }
                        if (n > -1 && n2 > -1) break;
                        ++n3;
                    }
                    return n > n2 ? 1 : -1;
                }
            });
            bNiagaraVirtualComponent.reorder((Property[])array2.trim());
        }
    }

    protected final BVirtualComponent makeVirtualRoot() {
        return this.rootFactory.makeVirtualRoot();
    }

    public final void ensureVirtualsLoaded(BOrd[] bOrdArray) {
        BValue bValue;
        VirtualPath virtualPath;
        BOrd bOrd;
        if (!this.isLicensed()) {
            return;
        }
        if (!this.adapter.isVirtualsEnabled()) {
            return;
        }
        if (this.adapter.getStationStatus().isDisabled()) {
            return;
        }
        if (disableEnsureVirtualsLoaded) {
            this.adapter.getLog().message("ensureVirtualsLoaded disabled via System.properties setting");
            return;
        }
        final LinkedHashMap<Object, NiagaraVirtualAddOp> linkedHashMap = new LinkedHashMap<Object, NiagaraVirtualAddOp>();
        int n = 0;
        while (n < bOrdArray.length) {
            linkedHashMap.put(BOrd.make((OrdQuery)NiagaraVirtualUtil.toVirtualPath(bOrdArray[n])), null);
            ++n;
        }
        if (this.adapter.getLog().isTraceOn()) {
            Iterator iterator = linkedHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.adapter.getLog().trace("Ensure Virtuals Loaded: Loading ORD: " + iterator.next().toString());
            }
        }
        String string = this.adapter.getStationName();
        BNiagaraVirtualCache bNiagaraVirtualCache = this.getNiagaraVirtualPolicies().getCache();
        Class clazz = class$javax$baja$naming$BOrd;
        if (clazz == null) {
            clazz = class$javax$baja$naming$BOrd = BNiagaraVirtualGateway.class("[Ljavax.baja.naming.BOrd;", false);
        }
        Array array = new Array(clazz);
        boolean bl = false;
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            bOrd = (BOrd)iterator.next();
            BSlotInfo bSlotInfo = null;
            try {
                bSlotInfo = bNiagaraVirtualCache.lookup(string, bOrd);
            }
            catch (Exception exception) {
                this.adapter.getLog().error("Ensure Virtuals Loaded: Error looking up from Cache: " + bOrd, (Throwable)exception);
            }
            if (bSlotInfo == null) {
                array.add((Object)bOrd);
                if (!this.adapter.getLog().isTraceOn()) continue;
                this.adapter.getLog().trace("Ensure Virtuals Loaded: Could not find in Niagara Virtual Cache: " + bOrd);
                continue;
            }
            virtualPath = NiagaraVirtualUtil.toVirtualPath(bOrd);
            bValue = NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), virtualPath.getParent());
            NiagaraVirtualAddOp niagaraVirtualAddOp = NiagaraVirtualAddOp.make(bSlotInfo, NiagaraVirtualUtil.getSlotNameFromVirtualPath(virtualPath));
            if (bValue != null && bValue instanceof BNiagaraVirtualComponent && !bSlotInfo.getIsNiagaraVirtual()) {
                niagaraVirtualAddOp.run((BNiagaraVirtualComponent)bValue);
                iterator.remove();
                bl = true;
                if (!this.adapter.getLog().isTraceOn()) continue;
                if (NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), (SlotPath)NiagaraVirtualUtil.toVirtualPath(bOrd)) == null) {
                    this.adapter.getLog().trace("Ensure Virtuals Loaded: Unable to Add from Cache: " + bOrd);
                    continue;
                }
                this.adapter.getLog().trace("Ensure Virtuals Loaded: Added from Cache: " + bOrd);
                continue;
            }
            if (bSlotInfo.getIsNiagaraVirtual()) {
                array.add((Object)bOrd);
            }
            linkedHashMap.put(bOrd, niagaraVirtualAddOp);
            if (!this.adapter.getLog().isTraceOn()) continue;
            if (bSlotInfo.getIsNiagaraVirtual()) {
                this.adapter.getLog().trace("Ensure Virtuals Loaded: Loading Niagara Virtual to Niagara Virtual through Batch network call: " + bOrd);
                continue;
            }
            this.adapter.getLog().trace("Ensure Virtuals Loaded: Found in Cache but could not find parent: " + bOrd);
        }
        if (array.size() > 0) {
            if (bl) {
                array = array.filter(new IFilter(){

                    public final boolean accept(Object object) {
                        boolean bl;
                        BOrd bOrd = (BOrd)object;
                        boolean bl2 = false;
                        if (NiagaraVirtualUtil.resolvePath((BComplex)BNiagaraVirtualGateway.this.getRootComponent(), (SlotPath)NiagaraVirtualUtil.toVirtualPath(bOrd)) != null) {
                            bl2 = true;
                        }
                        if (bl = bl2) {
                            linkedHashMap.remove(bOrd);
                            if (BNiagaraVirtualGateway.this.adapter.getLog().isTraceOn()) {
                                BNiagaraVirtualGateway.this.adapter.getLog().trace("Ensure Virtuals Loaded: Now resolves (from prior Add): " + bOrd);
                            }
                        }
                        return bl ^ true;
                    }
                });
            }
            if (array.size() > 0) {
                bOrd = null;
                try {
                    bOrd = this.getComms().loadPartial(this.getRootComponent().getNiagaraVirtualCompInfo().getSlotOrd(), (BOrd[])array.trim(), "ensureVirtualsLoaded");
                }
                catch (Exception exception) {
                    this.commsAdapter.error("Opening Connection for partially loading virtual information", exception);
                }
                if (bOrd != null) {
                    int n2 = 0;
                    while (n2 < ((PartialSlotInfo[])bOrd).length) {
                        virtualPath = NiagaraVirtualUtil.fromServerOrdToClientVirtual(this.getRootComponent().getNiagaraVirtualCompInfo().getSlotOrd(), bOrd[n2].getOrd());
                        bValue = BOrd.make((OrdQuery)virtualPath);
                        linkedHashMap.put(bValue, NiagaraVirtualAddOp.make(bOrd[n2].getSlotInfo(), NiagaraVirtualUtil.getSlotNameFromVirtualPath(virtualPath)));
                        bNiagaraVirtualCache.update(this.adapter.getStationName(), (BOrd)bValue, bOrd[n2].getSlotInfo());
                        ++n2;
                    }
                }
            }
        }
        iterator = linkedHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            bOrd = (BOrd)iterator.next();
            NiagaraVirtualAddOp niagaraVirtualAddOp = (NiagaraVirtualAddOp)linkedHashMap.get(bOrd);
            if (niagaraVirtualAddOp != null && (virtualPath = NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), NiagaraVirtualUtil.toVirtualPath(bOrd).getParent())) != null && virtualPath instanceof BNiagaraVirtualComponent) {
                niagaraVirtualAddOp.run((BNiagaraVirtualComponent)virtualPath);
            }
            if (!this.adapter.getLog().isTraceOn()) continue;
            if (NiagaraVirtualUtil.resolvePath((BComplex)this.getRootComponent(), (SlotPath)NiagaraVirtualUtil.toVirtualPath(bOrd)) == null) {
                this.adapter.getLog().trace("Ensure Virtuals Loaded: Unable to Add: " + bOrd);
                continue;
            }
            this.adapter.getLog().trace("Ensure Virtuals Loaded: Added: " + bOrd);
        }
    }

    public final BNiagaraVirtualPolicies getNiagaraVirtualPolicies() {
        return this.adapter.getNiagaraVirtualPolicies();
    }

    public final void doRefresh() {
        if (!this.adapter.getStationStatus().isDisabled() && this.adapter.isVirtualsEnabled() && this.isLicensed()) {
            HashSet hashSet = new HashSet();
            this.findFirstNiagaraVirtualGateways(hashSet, this.getRootComponent());
            BNiagaraVirtualComponent[] bNiagaraVirtualComponentArray = hashSet.toArray(new BNiagaraVirtualComponent[hashSet.size()]);
            int n = 0;
            while (n < bNiagaraVirtualComponentArray.length) {
                bNiagaraVirtualComponentArray[n].niagaraVirtualCompCheckActions();
                Action action = bNiagaraVirtualComponentArray[n].getAction("refresh");
                if (action != null) {
                    try {
                        bNiagaraVirtualComponentArray[n].invoke(action, null);
                    }
                    catch (ActionInvokeException actionInvokeException) {}
                }
                ++n;
            }
            this.reloadAllLoadedComponents(this.getRootComponent());
        } else {
            BNiagaraVirtualComponent bNiagaraVirtualComponent = this.getRootComponent();
            bNiagaraVirtualComponent.removeAll();
            this.loadVirtualSlots(bNiagaraVirtualComponent.getNiagaraVirtualCompInfo().getSlotOrd(), bNiagaraVirtualComponent);
        }
    }

    private final void reloadAllLoadedComponents(BNiagaraVirtualComponent bNiagaraVirtualComponent) {
        if (((ComponentSlotMap)bNiagaraVirtualComponent.fw(1)).isBrokerPropsLoaded()) {
            this.loadVirtualSlots(bNiagaraVirtualComponent.getNiagaraVirtualCompInfo().getSlotOrd(), bNiagaraVirtualComponent);
            bNiagaraVirtualComponent.unsubscribeHandlers();
            bNiagaraVirtualComponent.reloadActionsIfLoaded();
            Class clazz = class$com$tridium$nv$BNiagaraVirtualComponent;
            if (clazz == null) {
                clazz = class$com$tridium$nv$BNiagaraVirtualComponent = BNiagaraVirtualGateway.class("[Lcom.tridium.nv.BNiagaraVirtualComponent;", false);
            }
            BNiagaraVirtualComponent[] bNiagaraVirtualComponentArray = (BNiagaraVirtualComponent[])bNiagaraVirtualComponent.getChildren(clazz);
            int n = 0;
            while (n < bNiagaraVirtualComponentArray.length) {
                this.reloadAllLoadedComponents(bNiagaraVirtualComponentArray[n]);
                ++n;
            }
        }
    }

    private final void findFirstNiagaraVirtualGateways(Set set, BNiagaraVirtualComponent bNiagaraVirtualComponent) {
        Type type = null;
        try {
            type = Sys.getType((String)bNiagaraVirtualComponent.getTypeSpec());
        }
        catch (Exception exception) {}
        if (type != null && type.is(TYPE)) {
            set.add(bNiagaraVirtualComponent);
        } else {
            Class clazz = class$com$tridium$nv$BNiagaraVirtualComponent;
            if (clazz == null) {
                clazz = class$com$tridium$nv$BNiagaraVirtualComponent = BNiagaraVirtualGateway.class("[Lcom.tridium.nv.BNiagaraVirtualComponent;", false);
            }
            BNiagaraVirtualComponent[] bNiagaraVirtualComponentArray = (BNiagaraVirtualComponent[])bNiagaraVirtualComponent.getChildren(clazz);
            int n = 0;
            while (n < bNiagaraVirtualComponentArray.length) {
                this.findFirstNiagaraVirtualGateways(set, bNiagaraVirtualComponentArray[n]);
                ++n;
            }
        }
    }

    public final void doDeviceStatusChanged() {
        BNiagaraVirtualComponent bNiagaraVirtualComponent = this.getRootComponent();
        Class clazz = class$com$tridium$nv$BNiagaraVirtualComponent;
        if (clazz == null) {
            clazz = class$com$tridium$nv$BNiagaraVirtualComponent = BNiagaraVirtualGateway.class("[Lcom.tridium.nv.BNiagaraVirtualComponent;", false);
        }
        Array array = new Array(clazz);
        NiagaraVirtualUtil.findVirtualComponents(array, bNiagaraVirtualComponent);
        BNiagaraVirtualComponent[] bNiagaraVirtualComponentArray = (BNiagaraVirtualComponent[])array.trim();
        int n = 0;
        while (n < bNiagaraVirtualComponentArray.length) {
            bNiagaraVirtualComponentArray[n].niagaraVirtualCompDeviceStatusChanged();
            ++n;
        }
    }

    public final boolean isLicensed() {
        if (!this.licensed) {
            this.adapter.getLog().error("*** Niagara Virtual Components not licensed! ***");
        }
        return this.licensed;
    }

    public final BNiagaraVirtualComponent[] getNiagaraVirtualComponents() {
        Class clazz = class$com$tridium$nv$BNiagaraVirtualComponent;
        if (clazz == null) {
            clazz = class$com$tridium$nv$BNiagaraVirtualComponent = BNiagaraVirtualGateway.class("[Lcom.tridium.nv.BNiagaraVirtualComponent;", false);
        }
        Array array = new Array(clazz);
        NiagaraVirtualUtil.findVirtualComponents(array, this.getRootComponent());
        return (BNiagaraVirtualComponent[])array.trim();
    }

    public final BNiagaraVirtualComponent getRootComponent() {
        BComponentSpace bComponentSpace = this.getVirtualSpace();
        return bComponentSpace == null ? null : (BNiagaraVirtualComponent)bComponentSpace.getRootComponent();
    }

    public final INiagaraVirtualStationAdapter getStationAdapter() {
        return this.adapter;
    }

    public final void setStationAdapter(INiagaraVirtualStationAdapter iNiagaraVirtualStationAdapter) {
        this.adapter = iNiagaraVirtualStationAdapter;
    }

    public final INiagaraVirtualCommsAdapter getComms() {
        return this.commsAdapter;
    }

    public final void setCommsAdapter(INiagaraVirtualCommsAdapter iNiagaraVirtualCommsAdapter) {
        this.commsAdapter = iNiagaraVirtualCommsAdapter;
    }

    public final void setVirtualRootFactory(IVirtualRootFactory iVirtualRootFactory) {
        this.rootFactory = iVirtualRootFactory;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.licensed = false;
        this.rootFactory = new DefaultVirtualRootFactory();
        this.icon = null;
    }

    public BNiagaraVirtualGateway() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nv$BNiagaraVirtualGateway;
        if (clazz == null) {
            clazz = class$com$tridium$nv$BNiagaraVirtualGateway = BNiagaraVirtualGateway.class("[Lcom.tridium.nv.BNiagaraVirtualGateway;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        disableAddVirtualSlot = false;
        disableEnsureVirtualsLoaded = false;
        disableAddVirtualSlot = System.getProperty("niagara.niagaraVirtuals.disableAddVirtualSlot", "false").equals("false") ^ true;
        disableEnsureVirtualsLoaded = System.getProperty("niagara.niagaraVirtuals.disableEnsureVirtualsLoaded", "false").equals("false") ^ true;
    }

    public static final class PartialSlotInfo {
        private BOrd ord;
        private BSlotInfo info;

        final BOrd getOrd() {
            return this.ord;
        }

        final BSlotInfo getSlotInfo() {
            return this.info;
        }

        public PartialSlotInfo(BOrd bOrd, BSlotInfo bSlotInfo) {
            this.ord = bOrd;
            this.info = bSlotInfo;
        }
    }

    public static interface IVirtualRootFactory {
        public BNiagaraVirtualComponent makeVirtualRoot();
    }

    private static final class DefaultVirtualRootFactory
    implements IVirtualRootFactory {
        public final BNiagaraVirtualComponent makeVirtualRoot() {
            BNiagaraVirtualComponent bNiagaraVirtualComponent = new BNiagaraVirtualComponent();
            bNiagaraVirtualComponent.getNiagaraVirtualCompInfo().setSlotOrd(BOrd.make((String)"slot:/"));
            bNiagaraVirtualComponent.setIcon(BIcon.std((String)"database.png"));
            return bNiagaraVirtualComponent;
        }

        private DefaultVirtualRootFactory() {
        }
    }
}

