/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndedicatedMicros.util;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndedicatedMicros.BDedicatedMicrosNetwork;
import com.tridium.ndedicatedMicros.IDedicatedVideoServer;
import com.tridium.ndedicatedMicros.camera.BDedicatedCamera;
import com.tridium.ndedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.ndedicatedMicros.datatypes.BDmIpAddress;
import com.tridium.ndedicatedMicros.dvr.BDedicatedDvr;
import com.tridium.ndedicatedMicros.util.DmHttpUtil;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.HttpUtil;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.comm.http.NHttpStream;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.VideoStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;

public class DmVideoStreamUtil {
    public static void streamToDestination(BDedicatedCamera bDedicatedCamera, BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        DmVideoStreamUtil.streamToDestination(bDedicatedCamera.getDedicatedDvr(), bDedicatedCamera, DmVideoStreamUtil.getDmCameraNbr(bDedicatedCamera), bPlaybackParams, iVideoDestination);
    }

    public static void streamToDestination(BDedicatedDvr bDedicatedDvr, BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        DmVideoStreamUtil.streamToDestination(bDedicatedDvr, bDedicatedDvr, -1, bPlaybackParams, iVideoDestination);
    }

    static void streamToDestination(BDedicatedDvr bDedicatedDvr, IDedicatedVideoServer iDedicatedVideoServer, int n, BPlaybackParams bPlaybackParams, IVideoDestination iVideoDestination) {
        try {
            BIpAddress bIpAddress = ((BDmIpAddress)bDedicatedDvr.getAddress()).httpAddress();
            HttpComm httpComm = ((BDedicatedMicrosNetwork)DrUtil.getParent((BComplex)bDedicatedDvr, (Type)BDedicatedMicrosNetwork.TYPE)).hcomm();
            String string = DmVideoStreamUtil.makeUri(iDedicatedVideoServer, n, bPlaybackParams);
            NHttpRequest nHttpRequest = new NHttpRequest(bIpAddress, "GET", string);
            nHttpRequest.setUsernamePassword((BUsernameAndPassword)bDedicatedDvr.getCredentials());
            nHttpRequest.setResponseTimeOut(15000);
            NHttpStream nHttpStream = httpComm.openStream(nHttpRequest);
            BFacets bFacets = HttpUtil.responseHeaderToFacets((NHttpResponse)nHttpStream);
            bFacets = BFacets.make((BFacets)bPlaybackParams.getVideoFacets(), (BFacets)bFacets);
            bPlaybackParams.setHttpRspHeader(bFacets);
            DmVideoSteam dmVideoSteam = new DmVideoSteam(bPlaybackParams, nHttpStream.getInputStream(), nHttpStream);
            iVideoDestination.receiveVideoStream((IVideoStream)dmVideoSteam);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Unable to establish stream", (Throwable)exception);
        }
    }

    static int getDmCameraNbr(BDedicatedCamera bDedicatedCamera) {
        BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)bDedicatedCamera.getVideoDeviceId();
        return bDedicatedCameraDeviceId.getCameraId();
    }

    static void addLiveParametersToUrl(StringBuffer stringBuffer, IDedicatedVideoServer iDedicatedVideoServer, BPlaybackParams bPlaybackParams) {
        BVideoCompressionEnum bVideoCompressionEnum;
        int n;
        if (DmVideoStreamUtil.isMultistreamStream(bPlaybackParams)) {
            n = DmVideoStreamUtil.getMultistreamStreamMask((BComponent)iDedicatedVideoServer, bPlaybackParams);
            stringBuffer.append("/display_pic.cgi?seq=").append(Integer.toString(n, 16));
        } else {
            n = DmVideoStreamUtil.getDmCameraNbr((BDedicatedCamera)iDedicatedVideoServer);
            stringBuffer.append("/display_pic.cgi?cam=").append(n);
        }
        long l = bPlaybackParams.getVideoFacets().geti("dmId", -1) & 0xFFFFFFFF;
        if (l != (long)-1) {
            stringBuffer.append("&id=" + l);
        }
        if ((bVideoCompressionEnum = bPlaybackParams.getCompression()) != BVideoCompressionEnum.high) {
            int n2;
            if (bPlaybackParams.getFrameRate() == BVideoFrameRateEnum.low) {
                n2 = iDedicatedVideoServer.getLoFrameRate();
            } else if (bPlaybackParams.getFrameRate() == BVideoFrameRateEnum.medium) {
                n2 = iDedicatedVideoServer.getMedFrameRate();
            } else if (bPlaybackParams.getFrameRate() == BVideoFrameRateEnum.high) {
                n2 = iDedicatedVideoServer.getHiFrameRate();
            } else {
                throw new BajaRuntimeException("Unsupported frameRate: " + bPlaybackParams.getFrameRate());
            }
            stringBuffer.append("&pps=").append(n2);
        }
    }

    static void addReplayParametersToUrl(StringBuffer stringBuffer, int n, BPlaybackParams bPlaybackParams, long l) {
        stringBuffer.append("/replay_pic.cgi?cam=").append(n);
        long l2 = bPlaybackParams.getVideoFacets().geti("dmId", -1) & 0xFFFFFFFF;
        if (l2 != (long)-1) {
            stringBuffer.append("&id=" + l2);
        }
        stringBuffer.append("&control=");
        switch (bPlaybackParams.getPlaybackType().getOrdinal()) {
            case 1: {
                stringBuffer.append("PLAY");
                if (l == (long)-1) break;
                stringBuffer.append("&time=" + l);
                break;
            }
            case 2: {
                stringBuffer.append("FFWD&ffmult=");
                stringBuffer.append(4 << bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 3: {
                stringBuffer.append("FFWD&ffmult=");
                stringBuffer.append(-2 - bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 4: {
                stringBuffer.append("RWND&ffmult=");
                stringBuffer.append(4 << bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 5: {
                stringBuffer.append("RWND&ffmult=");
                stringBuffer.append(-2 - bPlaybackParams.getPlaybackSpeed().getOrdinal());
                break;
            }
            case 6: {
                stringBuffer.append("STOP");
                if (l == (long)-1) break;
                stringBuffer.append("&time=" + l);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported playback type: " + bPlaybackParams.getPlaybackType());
            }
        }
    }

    static void addCommonParametersToUrl(StringBuffer stringBuffer, BPlaybackParams bPlaybackParams) {
        BVideoCompressionEnum bVideoCompressionEnum = bPlaybackParams.getCompression();
        if (bVideoCompressionEnum == BVideoCompressionEnum.high) {
            stringBuffer.append("&res=").append(bPlaybackParams.getResolution().getTag());
            stringBuffer.append("&format=mp4");
            stringBuffer.append("&txmode=binary");
        } else {
            stringBuffer.append("&res=").append(bPlaybackParams.getResolution().getTag());
            stringBuffer.append("&format=jfif");
        }
    }

    static boolean isMultistreamStream(BPlaybackParams bPlaybackParams) {
        return bPlaybackParams.getVideoSourceOrds().equals((Object)BOrdList.NULL) ^ true;
    }

    static int getMultistreamStreamMask(BComponent bComponent, BPlaybackParams bPlaybackParams) {
        BOrdList bOrdList = bPlaybackParams.getVideoSourceOrds();
        int n = 0;
        int n2 = 0;
        while (n2 < bOrdList.size()) {
            BOrd bOrd = bOrdList.get(n2);
            BDedicatedCamera bDedicatedCamera = (BDedicatedCamera)bOrd.get((BObject)bComponent);
            BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)bDedicatedCamera.getVideoDeviceId();
            int n3 = bDedicatedCameraDeviceId.getCameraId();
            int n4 = 1 << n3 - 1;
            n |= n4;
            ++n2;
        }
        if (n == 0) {
            throw new IllegalStateException("Expected the multistreamStreamMask not be zero.");
        }
        return n;
    }

    static String makeUri(IDedicatedVideoServer iDedicatedVideoServer, int n, BPlaybackParams bPlaybackParams) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = DmHttpUtil.getControlTimeStampUtc(bPlaybackParams);
        switch (bPlaybackParams.getPlaybackType().getOrdinal()) {
            case 0: {
                DmVideoStreamUtil.addLiveParametersToUrl(stringBuffer, iDedicatedVideoServer, bPlaybackParams);
                break;
            }
            case 6: {
                if (l == (long)-1) {
                    DmVideoStreamUtil.addLiveParametersToUrl(stringBuffer, iDedicatedVideoServer, bPlaybackParams);
                    stringBuffer.append("&fields=1");
                    break;
                }
                DmVideoStreamUtil.addReplayParametersToUrl(stringBuffer, n, bPlaybackParams, l);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                DmVideoStreamUtil.addReplayParametersToUrl(stringBuffer, n, bPlaybackParams, l);
                break;
            }
            default: {
                throw new BajaRuntimeException("Unrecognized playback type " + bPlaybackParams.getPlaybackType());
            }
        }
        DmVideoStreamUtil.addCommonParametersToUrl(stringBuffer, bPlaybackParams);
        return stringBuffer.toString();
    }

    private static class DmVideoSteam
    extends VideoStream {
        NHttpStream hstream;

        public void closeVideoStream() throws IOException {
            this.hstream.close();
        }

        DmVideoSteam(BPlaybackParams bPlaybackParams, InputStream inputStream, NHttpStream nHttpStream) {
            super(bPlaybackParams, inputStream);
            this.hstream = nHttpStream;
        }
    }
}

