/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndedicatedMicros.messages;

import com.tridium.ndedicatedMicros.camera.BDedicatedCamera;
import com.tridium.ndedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.sys.BajaRuntimeException;

public class DedicatedIrisControlReq
extends NMessage {
    BDedicatedCamera camera;
    BVideoIrisEnum irisEnum;

    public boolean toOutputStream(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write("*2");
        BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)this.camera.getVideoDeviceId();
        int n = bDedicatedCameraDeviceId.getCameraId();
        if (n >= 100 || n < 0) {
            throw new BajaRuntimeException(this.camera.getSlotPath().toDisplayString() + ":Camera Id must be between 0 and 99.");
        }
        if (n < 10) {
            printWriter.write(48);
        }
        printWriter.write(Integer.toString(n));
        int n2 = this.irisEnum.getOrdinal();
        printWriter.write(this.getIrisCtrlCmd(n2));
        printWriter.flush();
        return false;
    }

    public String getIrisCtrlCmd(int n) {
        if (n >= 0 && n <= 1) {
            return "D";
        }
        if (n >= 2 && n <= 4) {
            return "0";
        }
        if (n >= 5 && n <= 7) {
            return "5";
        }
        throw new BajaRuntimeException("Unsupported BVideoIrisEnum ordinal - " + n);
    }

    public DedicatedIrisControlReq(BDedicatedCamera bDedicatedCamera, BVideoIrisEnum bVideoIrisEnum) {
        this.camera = bDedicatedCamera;
        this.irisEnum = bVideoIrisEnum;
    }
}

