/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndedicatedMicros.messages;

import com.tridium.ndedicatedMicros.camera.BDedicatedCamera;
import com.tridium.ndedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.sys.BajaRuntimeException;

public class DedicatedFocusControlReq
extends NMessage {
    BDedicatedCamera camera;
    BVideoFocusEnum focusEnum;

    public boolean toOutputStream(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.write("*2");
        BDedicatedCameraDeviceId bDedicatedCameraDeviceId = (BDedicatedCameraDeviceId)this.camera.getVideoDeviceId();
        int n = bDedicatedCameraDeviceId.getCameraId();
        if (n >= 100 || n < 0) {
            throw new BajaRuntimeException(this.camera.getSlotPath().toDisplayString() + ":Camera Id must be between 0 and 99.");
        }
        if (n < 10) {
            printWriter.write(48);
        }
        printWriter.write(Integer.toString(n));
        int n2 = this.focusEnum.getOrdinal();
        printWriter.write(this.getFocusCtrlCmd(n2));
        printWriter.flush();
        return false;
    }

    public String getFocusCtrlCmd(int n) {
        if (n >= 0 && n <= 1) {
            return "D";
        }
        if (n >= 2 && n <= 4) {
            return "7";
        }
        if (n >= 5 && n <= 7) {
            return "9";
        }
        throw new BajaRuntimeException("Unsupported BVideoFocusEnum ordinal - " + n);
    }

    public DedicatedFocusControlReq(BDedicatedCamera bDedicatedCamera, BVideoFocusEnum bVideoFocusEnum) {
        this.camera = bDedicatedCamera;
        this.focusEnum = bVideoFocusEnum;
    }
}

