/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndedicatedMicros.display;

import com.tridium.ndedicatedMicros.BDedicatedMicrosNetwork;
import com.tridium.ndedicatedMicros.camera.BDedicatedCamera;
import com.tridium.ndedicatedMicros.camera.BDedicatedCameraDeviceId;
import com.tridium.ndedicatedMicros.display.BDedicatedVideoDisplay;
import com.tridium.ndedicatedMicros.display.enums.BDedicatedDisplayPlaybackSpeedEnum;
import com.tridium.ndedicatedMicros.display.enums.BDedicatedDisplayPrimaryModeEnum;
import com.tridium.ndedicatedMicros.dvr.BDedicatedDvr;
import com.tridium.ndedicatedMicros.dvr.BDedicatedDvrChannelEnum;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.datatypes.BNWorker;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.VideoDisplayController;
import com.tridium.videoDriver.ui.display.BIVideoDisplayLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DedicatedVideoDisplayController
extends VideoDisplayController {
    public static final Log log = Log.getLog((String)"dm.videoDisplay");
    private static final int RESPONSE_TIMEOUT = 2000;
    private static final int SD_ADVANCED_PORT = 4020;
    private static final String ENCODED_BACK_SLASH = "%5C";
    private static final String PRIMARY_MODE_LIVE = "/mci.cgi?command=M\\PRI_MODE\\00";
    private static final String PRIMARY_MODE_PLAYBACK = "/mci.cgi?command=M\\PRI_MODE\\02";
    private static final String SECONDARY_MODE_COMMAND_PREFIX = "/mci.cgi?command=M\\SEC_MODE\\";
    private static final String SET_SEGMENT_CAMERA_COMMAND_PREFIX = "/mci.cgi?command=M\\SET\\SEG_CAM\\";
    private static final String SEQUENCE_OFF_COMMAND_ALL_CAMERAS = "/mci.cgi?command=M\\SEQ\\0\\FFFF";
    private static final String SEQUENCE_ON_COMMAND_ALL_CAMERAS = "/mci.cgi?command=M\\SEQ\\1\\FFFF";
    private static final String HOLD_MODE_OFF = "/mci.cgi?command=M\\HOLD\\0";
    private static final String HOLD_MODE_ON = "/mci.cgi?command=M\\HOLD\\1";
    private static final String PLAYBACK_SPEED_COMMAND_PREFIX = "/mci.cgi?command=M\\PLAY_SPEED\\";
    private static final String GOTO_PLAYBACK_TIME_COMMAND_PREFIX = "/mci.cgi?command=M\\PLAY_GOTO\\";
    private static final String SELECT_CHANNEL_COMMAND_PREFIX = "/mci.cgi?command=M\\SEL_CHAN\\";
    private static final HashMap layoutToScreenModeMap = new HashMap();
    private static final Integer FULL = new Integer(1);
    private static final Integer QUAD = new Integer(2);
    private static final Integer MULT_9 = new Integer(3);
    private static final Integer MULT_16 = new Integer(4);
    private static final Integer MULT_8_PLUS_2 = new Integer(5);
    private static final Integer MULT_12_PLUS_1 = new Integer(6);
    private static final Integer MULT_4_PLUS_3 = new Integer(7);
    private static final Integer P_IN_P_TOP_LEFT = new Integer(8);
    private static final Integer SM_FULL = new Integer(0);
    private static final Integer SM_QUAD = new Integer(1);
    private static final Integer SM_MULT_8_PLUS_2 = new Integer(2);
    private static final Integer SM_MULT_12_PLUS_1 = new Integer(3);
    private static final Integer SM_MULT_16 = new Integer(4);
    private static final Integer SM_MULT_4_PLUS_3 = new Integer(5);
    private static final Integer SM_MULT_9 = new Integer(6);
    private static final Integer SM_P_IN_P_TOP_LEFT = new Integer(7);
    private Map segmentToCameraIdMap;
    private BDedicatedMicrosNetwork network;
    private BDedicatedDvr dvr;
    private BNWorker worker;

    public void switchDisplayToLayout(BIVideoDisplayLayout bIVideoDisplayLayout) {
        int n = DedicatedVideoDisplayController.translateLayoutToSecondaryMode(bIVideoDisplayLayout);
        this.setSecondaryMode(n);
    }

    private static final int translateLayoutToSecondaryMode(BIVideoDisplayLayout bIVideoDisplayLayout) {
        switch (bIVideoDisplayLayout.getNumberOfSegments()) {
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 2: {
                return 7;
            }
        }
        return 1;
    }

    public void mapCamerasToLayout(BOrd[] bOrdArray, BIVideoDisplayLayout bIVideoDisplayLayout) {
        Object object;
        BIVideoCamera bIVideoCamera;
        if (bOrdArray == null) {
            return;
        }
        this.segmentToCameraIdMap.clear();
        int n = 0;
        while (n < bIVideoDisplayLayout.getNumberOfSegments()) {
            if (n <= bOrdArray.length - 1 && !bOrdArray[n].equals((Object)BOrd.NULL) && (bIVideoCamera = (BIVideoCamera)bOrdArray[n].get(this.display.asObject())) != null && bIVideoCamera instanceof BDedicatedCamera) {
                bIVideoCamera.asObject().asComponent().lease();
                BDedicatedCamera bDedicatedCamera = (BDedicatedCamera)bIVideoCamera;
                object = (BDedicatedCameraDeviceId)bDedicatedCamera.getVideoDeviceId();
                Integer n2 = new Integer(n + 1);
                Integer n3 = new Integer(((BDedicatedCameraDeviceId)((Object)object)).getCameraId());
                this.segmentToCameraIdMap.put(n2, n3);
            }
            ++n;
        }
        Iterator iterator = this.segmentToCameraIdMap.keySet().iterator();
        bIVideoCamera = null;
        int n4 = this.getScreenModeForLayout(bIVideoDisplayLayout);
        while (iterator.hasNext()) {
            object = (Integer)iterator.next();
            int n5 = (Integer)object;
            int n6 = (Integer)this.segmentToCameraIdMap.get(object);
            bIVideoCamera = this.setSegmentCamera(n4, n5, n6);
        }
        if (bIVideoCamera != null && this.isSdAdvanced()) {
            this.sendRequest((NHttpRequest)bIVideoCamera);
        }
    }

    private final int getScreenModeForLayout(BIVideoDisplayLayout bIVideoDisplayLayout) {
        int n = DedicatedVideoDisplayController.translateLayoutToSecondaryMode(bIVideoDisplayLayout);
        return this.isSdAdvanced() ? this.translateScreenMode(n) : n;
    }

    protected int translateScreenMode(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)layoutToScreenModeMap.get(n2);
        return n3;
    }

    public void setPrimaryMode(BDedicatedDisplayPrimaryModeEnum bDedicatedDisplayPrimaryModeEnum) {
        NHttpRequest nHttpRequest = null;
        if (bDedicatedDisplayPrimaryModeEnum.equals((Object)BDedicatedDisplayPrimaryModeEnum.live)) {
            nHttpRequest = this.makeHttpRequest(PRIMARY_MODE_LIVE);
        } else if (bDedicatedDisplayPrimaryModeEnum.equals((Object)BDedicatedDisplayPrimaryModeEnum.playback)) {
            nHttpRequest = this.makeHttpRequest(PRIMARY_MODE_PLAYBACK);
        }
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    public void setSecondaryMode(int n) {
        NHttpRequest nHttpRequest = this.makeHttpRequest(SECONDARY_MODE_COMMAND_PREFIX + n);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    public NHttpRequest setSegmentCamera(int n, int n2, int n3) {
        NHttpRequest nHttpRequest = this.makeHttpRequest(SET_SEGMENT_CAMERA_COMMAND_PREFIX + n + '\\' + n2 + '\\' + n3);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
        return nHttpRequest;
    }

    public void setSequenceMode(boolean bl) {
        NHttpRequest nHttpRequest = null;
        nHttpRequest = bl ? this.makeHttpRequest(SEQUENCE_ON_COMMAND_ALL_CAMERAS) : this.makeHttpRequest(SEQUENCE_OFF_COMMAND_ALL_CAMERAS);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    public void setHoldMode(boolean bl) {
        NHttpRequest nHttpRequest = null;
        nHttpRequest = bl ? this.makeHttpRequest(HOLD_MODE_ON) : this.makeHttpRequest(HOLD_MODE_OFF);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    public void setPlaybackSpeed(BDedicatedDisplayPlaybackSpeedEnum bDedicatedDisplayPlaybackSpeedEnum) {
        NHttpRequest nHttpRequest = null;
        String string = PLAYBACK_SPEED_COMMAND_PREFIX;
        string = bDedicatedDisplayPlaybackSpeedEnum.getOrdinal() > 0 ? string + '+' + bDedicatedDisplayPlaybackSpeedEnum.getOrdinal() : string + bDedicatedDisplayPlaybackSpeedEnum.getOrdinal();
        nHttpRequest = this.makeHttpRequest(string);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    public void gotoPlaybackTime(BAbsTime bAbsTime, int n) {
        int n2 = bAbsTime.getYear();
        if (n2 < 1999 || n2 > 2037) {
            return;
        }
        if (n < -11 || n > 11) {
            return;
        }
        int n3 = bAbsTime.getMonth().getMonthOfYear();
        int n4 = bAbsTime.getDay();
        int n5 = bAbsTime.getHour();
        int n6 = bAbsTime.getMinute();
        int n7 = bAbsTime.getSecond();
        String string = "" + n2 + '\\' + n3 + '\\' + n4 + '\\' + n5 + '\\' + n6 + '\\' + n7 + '\\' + n;
        String string2 = GOTO_PLAYBACK_TIME_COMMAND_PREFIX + string;
        NHttpRequest nHttpRequest = this.makeHttpRequest(string2);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    public void selectChannel(BDedicatedDvrChannelEnum bDedicatedDvrChannelEnum) {
        int n = bDedicatedDvrChannelEnum.getOrdinal() + 1;
        NHttpRequest nHttpRequest = this.makeHttpRequest(SELECT_CHANNEL_COMMAND_PREFIX + n);
        if (nHttpRequest != null) {
            this.sendRequest(nHttpRequest);
        }
    }

    private final BNWorker worker() {
        if (this.worker == null) {
            this.worker = this.network().getAsync();
        }
        return this.worker;
    }

    private final BDedicatedMicrosNetwork network() {
        if (this.network == null) {
            this.network = (BDedicatedMicrosNetwork)this.dvr().getNetwork();
        }
        return this.network;
    }

    private final BDedicatedDvr dvr() {
        if (this.dvr == null) {
            this.dvr = (BDedicatedDvr)((BComponent)this.display.getDisplayDeviceExt()).getParent();
        }
        return this.dvr;
    }

    private final BDedicatedVideoDisplay display() {
        return (BDedicatedVideoDisplay)this.display;
    }

    private final HttpComm comm() {
        try {
            return this.network().hcomm();
        }
        catch (Exception exception) {
            if (log.isTraceOn()) {
                log.trace("Error retrieving HTTP comm", (Throwable)exception);
            }
            return null;
        }
    }

    private final NHttpRequest makeHttpRequest(String string) {
        if (this.display().getEscapeCommands()) {
            string = TextUtil.replace((String)string, (String)"\\", (String)ENCODED_BACK_SLASH);
        }
        BIpAddress bIpAddress = this.dvr().httpAddress();
        bIpAddress.setPort(this.display().getPort());
        NHttpRequest nHttpRequest = new NHttpRequest(bIpAddress, "GET", string);
        nHttpRequest.setUsernamePassword((BUsernameAndPassword)this.dvr().getCredentials());
        nHttpRequest.setResponseTimeOut(2000);
        return nHttpRequest;
    }

    private final NHttpResponse sendRequest(final NHttpRequest nHttpRequest) {
        Runnable runnable = new Runnable(){

            public final void run() {
                block4: {
                    BDedicatedDvr bDedicatedDvr = DedicatedVideoDisplayController.this.dvr();
                    if (!bDedicatedDvr.getStatus().isValid()) {
                        if (log.isTraceOn()) {
                            log.trace("Cannot send request. Dvr status is " + bDedicatedDvr.getStatus());
                        }
                        return;
                    }
                    HttpComm httpComm = DedicatedVideoDisplayController.this.comm();
                    try {
                        httpComm.sendRequest(nHttpRequest);
                    }
                    catch (Exception exception) {
                        if (!log.isTraceOn()) break block4;
                        log.trace("Error sending request", (Throwable)exception);
                    }
                }
            }
        };
        this.worker().post(runnable);
        return null;
    }

    private final boolean isSdAdvanced() {
        boolean bl = false;
        if (this.display().getPort() == 4020) {
            bl = true;
        }
        return bl;
    }

    public void cleanup() {
        this.segmentToCameraIdMap.clear();
    }

    private final /* synthetic */ void this() {
        this.segmentToCameraIdMap = new HashMap();
    }

    protected DedicatedVideoDisplayController(BIVideoDisplay bIVideoDisplay) {
        super(bIVideoDisplay);
        this.this();
    }

    static {
        layoutToScreenModeMap.put(FULL, SM_FULL);
        layoutToScreenModeMap.put(QUAD, SM_QUAD);
        layoutToScreenModeMap.put(MULT_9, SM_MULT_9);
        layoutToScreenModeMap.put(MULT_16, SM_MULT_16);
        layoutToScreenModeMap.put(MULT_8_PLUS_2, SM_MULT_8_PLUS_2);
        layoutToScreenModeMap.put(MULT_12_PLUS_1, SM_MULT_12_PLUS_1);
        layoutToScreenModeMap.put(MULT_4_PLUS_3, SM_MULT_4_PLUS_3);
        layoutToScreenModeMap.put(P_IN_P_TOP_LEFT, SM_P_IN_P_TOP_LEFT);
    }
}

