/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.analyzer.ui;

import com.tridium.box.BBoxRecordType;
import com.tridium.box.analyzer.BBoxAnalyzer;
import com.tridium.box.analyzer.BBoxFrameRecord;
import com.tridium.ui.UiEnv;
import java.io.PrintWriter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import javax.baja.util.TextUtil;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBoxAnalyzerView
extends BWbComponentView {
    public static final Type TYPE;
    private static final Lexicon lex;
    private static final BImage requestIcon;
    private static final BImage responseIcon;
    private static final BImage blankIcon;
    private static final BBrush requestBrush;
    private static final BBrush responseBrush;
    private static final BBrush statusBrush;
    private static final BBrush errorBrush;
    private static final int maxCellStrSize = 200;
    private Array records;
    private TableModel model;
    private BTable table;
    private Renderer renderer;
    private volatile boolean pause;
    static /* synthetic */ Class class$com$tridium$box$analyzer$ui$BBoxAnalyzerView;
    static /* synthetic */ Class class$com$tridium$box$analyzer$BBoxFrameRecord;

    public final Type getType() {
        return TYPE;
    }

    protected final void doLoadValue(BObject bObject, Context context) throws Exception {
        this.pause = false;
    }

    public final void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() == this.getAnalyzer() && bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BBoxAnalyzer.newFrame) {
            if (this.pause) {
                return;
            }
            final BBoxFrameRecord bBoxFrameRecord = (BBoxFrameRecord)bComponentEvent.getValue();
            if (bBoxFrameRecord == null) {
                return;
            }
            UiEnv.get().invokeLater(new Runnable(){

                public final void run() {
                    BBoxAnalyzerView.this.records.add((Object)bBoxFrameRecord);
                    while (BBoxAnalyzerView.this.records.size() > BBoxAnalyzerView.this.getAnalyzer().getViewLogLimit()) {
                        BBoxAnalyzerView.this.records.remove(0);
                    }
                    BBoxAnalyzerView.this.updateTable();
                }
            });
        }
    }

    private final void updateTable() {
        this.model.updateTable();
        this.table.ensureRowIsVisible(this.model.getRowCount());
        this.table.sizeColumnsToFit();
    }

    private final BValue getValFromProp(BBoxFrameRecord bBoxFrameRecord, Property property, boolean bl) {
        return bBoxFrameRecord.propToString(property, this.getCurrentContext(), bl);
    }

    private final BBoxAnalyzer getAnalyzer() {
        return (BBoxAnalyzer)this.getCurrentValue();
    }

    public final void writeExport(PrintWriter printWriter) {
        BBoxFrameRecord[] bBoxFrameRecordArray = (BBoxFrameRecord[])this.records.copy().trim();
        if (bBoxFrameRecordArray.length == 0) {
            return;
        }
        Property[] propertyArray = bBoxFrameRecordArray[0].getFrozenPropertiesArray();
        int n = 0;
        while (n < bBoxFrameRecordArray.length) {
            int n2 = 0;
            while (n2 < propertyArray.length) {
                printWriter.print(propertyArray[n2].getDefaultDisplayName(null));
                printWriter.print(": ");
                String string = this.getValFromProp(bBoxFrameRecordArray[n], propertyArray[n2], false).toString();
                String[] stringArray = TextUtil.splitAndTrim((String)string, (char)'\n');
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (n3 > 0) {
                        printWriter.print("      ");
                    }
                    printWriter.println(stringArray[n3]);
                    ++n3;
                }
                ++n2;
            }
            printWriter.println();
            ++n;
        }
    }

    static final /* synthetic */ int access$4() {
        return 200;
    }

    static final /* synthetic */ boolean access$13(BBoxAnalyzerView bBoxAnalyzerView) {
        return bBoxAnalyzerView.pause;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$box$analyzer$BBoxFrameRecord;
        if (clazz == null) {
            clazz = class$com$tridium$box$analyzer$BBoxFrameRecord = BBoxAnalyzerView.class("[Lcom.tridium.box.analyzer.BBoxFrameRecord;", false);
        }
        this.records = new Array(clazz);
        this.model = new Model();
        this.table = new BTable(this.model);
        this.renderer = new Renderer();
        this.pause = false;
    }

    public BBoxAnalyzerView() {
        this.this();
        this.table.setCellRenderer((TableCellRenderer)this.renderer);
        this.table.setMultipleSelection(false);
        this.table.setController((TableController)new Controller());
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("box.analyzer.view.title"), (BTable)this.table));
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.setColumnGap(10.0);
        bGridPane.add(null, (BValue)new BToggleButton((Command)new PauseCmd((BWidget)this)));
        bGridPane.add(null, (BValue)new BButton((Command)new ClearCmd((BWidget)this)));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, (double)5, (double)5, (double)5, (double)5));
        this.setContent((BWidget)bEdgePane);
    }

    static {
        Class clazz = class$com$tridium$box$analyzer$ui$BBoxAnalyzerView;
        if (clazz == null) {
            clazz = class$com$tridium$box$analyzer$ui$BBoxAnalyzerView = BBoxAnalyzerView.class("[Lcom.tridium.box.analyzer.ui.BBoxAnalyzerView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$box$analyzer$ui$BBoxAnalyzerView;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$box$analyzer$ui$BBoxAnalyzerView = BBoxAnalyzerView.class("[Lcom.tridium.box.analyzer.ui.BBoxAnalyzerView;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        requestIcon = BImage.make((BIcon)BIcon.std((String)"arrowRight.png"));
        responseIcon = BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
        blankIcon = BImage.make((BIcon)BIcon.std((String)"blank.png"));
        requestBrush = BColor.make((int)255, (int)220, (int)220).toBrush();
        responseBrush = BColor.make((int)230, (int)255, (int)230).toBrush();
        statusBrush = BColor.lightYellow.toBrush();
        errorBrush = BColor.tomato.toBrush();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Model
    extends TableModel {
        private BBoxFrameRecord dummyEvent;
        private Property[] props;

        public int getColumnCount() {
            return this.props.length;
        }

        public String getColumnName(int n) {
            return this.props[n].getDefaultDisplayName(null);
        }

        public int getRowCount() {
            return BBoxAnalyzerView.this.records.size();
        }

        public Object getValueAt(int n, int n2) {
            BString bString;
            BValue bValue = BBoxAnalyzerView.this.getValFromProp((BBoxFrameRecord)((Object)BBoxAnalyzerView.this.records.get(n)), this.props[n2], true);
            if (bValue instanceof BString && (bString = (BString)bValue).getString().length() > 200) {
                return BString.make((String)(bString.getString().substring(0, 199) + "..."));
            }
            return bValue;
        }

        public BImage getRowIcon(int n) {
            BBoxRecordType bBoxRecordType = ((BBoxFrameRecord)((Object)BBoxAnalyzerView.this.records.get(n))).getRecordType();
            if (bBoxRecordType == BBoxRecordType.request) {
                return requestIcon;
            }
            if (bBoxRecordType == BBoxRecordType.response) {
                return responseIcon;
            }
            return blankIcon;
        }

        private final /* synthetic */ void this() {
            this.dummyEvent = new BBoxFrameRecord();
            this.props = this.dummyEvent.getFrozenPropertiesArray();
        }

        private Model() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Renderer
    extends TableCellRenderer {
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBoxRecordType bBoxRecordType = ((BBoxFrameRecord)((Object)BBoxAnalyzerView.this.records.get(cell.row))).getRecordType();
            if (bBoxRecordType == BBoxRecordType.request) {
                return requestBrush;
            }
            if (bBoxRecordType == BBoxRecordType.response) {
                return responseBrush;
            }
            if (bBoxRecordType == BBoxRecordType.error) {
                return errorBrush;
            }
            return statusBrush;
        }

        private Renderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Controller
    extends TableController {
        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BGridPane bGridPane = new BGridPane(2);
            BBoxFrameRecord bBoxFrameRecord = (BBoxFrameRecord)((Object)BBoxAnalyzerView.this.records.get(n));
            Property[] propertyArray = bBoxFrameRecord.getFrozenPropertiesArray();
            int n3 = 0;
            while (n3 < propertyArray.length) {
                bGridPane.add(null, (BValue)new BLabel(propertyArray[n3].getDefaultDisplayName(null) + ": ", BHalign.left));
                bGridPane.add(null, (BValue)new BLabel(BBoxAnalyzerView.this.getValFromProp(bBoxFrameRecord, propertyArray[n3], false).toString(), BHalign.left));
                ++n3;
            }
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BScrollPane((BWidget)bGridPane));
            bConstrainedPane.setMinSize(550.0, 600.0);
            BDialog.open((BWidget)BBoxAnalyzerView.this, (String)lex.getText("box.analyzer.view.dlg.title"), (Object)bConstrainedPane, (int)1);
        }

        private Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PauseCmd
    extends ToggleCommand {
        public synchronized void setSelected(boolean bl) {
            super.setSelected(bl);
            BBoxAnalyzerView.this.pause = bl;
        }

        private PauseCmd(BWidget bWidget) {
            super(bWidget, lex.getText("box.analyzer.view.cmd.pause.label"), BImage.make((BIcon)BIcon.std((String)"mediaPause.png")), BAccelerator.DEFAULT, lex.getText("box.analyzer.view.cmd.pause.description"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ClearCmd
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BBoxAnalyzerView.this.records.clear();
            BBoxAnalyzerView.this.updateTable();
            return null;
        }

        private ClearCmd(BWidget bWidget) {
            super(bWidget, lex.getText("box.analyzer.view.cmd.clear.label"), BImage.make((BIcon)BIcon.std((String)"delete.png")), BAccelerator.DEFAULT, lex.getText("box.analyzer.view.cmd.clear.description"));
        }
    }
}

