/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup.ui;

import com.tridium.backup.BBackupRecord;
import com.tridium.backup.BFoxBackupJob;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.ui.theme.Theme;
import com.tridium.util.TimeFormat;
import com.tridium.workbench.job.BJobBar;
import javax.baja.backup.BBackupService;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBackupManager
extends BWbComponentView {
    public static final Type TYPE;
    static final Lexicon lex;
    static final BImage icon;
    static BOrd defaultDir;
    static JobCompleteSubscriber jobCompleteSubscriber;
    BJobBar jobBar;
    BTable table;
    Command cmdBackup;
    BBackupService backupService;
    BBackupRecord[] recs;
    static /* synthetic */ Class class$com$tridium$backup$ui$BBackupManager;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.backupService = (BBackupService)bObject;
        this.reload();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        this.reload();
    }

    public void reload() {
        this.recs = BBackupRecord.list(this.backupService);
        this.table.getModel().updateTable();
    }

    public static void stationBackupCommand(BWidget bWidget, BObject bObject) throws Exception {
        try {
            BBackupService bBackupService = (BBackupService)BOrd.make((String)"service:backup:BackupService").get(bObject);
            BBackupManager.promptAndSubmit(bWidget, bBackupService);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            throw new LocalizableRuntimeException("backup", "BackupManager.error.noBackupService");
        }
    }

    public static BOrd promptAndSubmit(BWidget bWidget, BBackupService bBackupService) throws Exception {
        String string;
        String string2;
        BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)bBackupService);
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        if (defaultDir == null) {
            string2 = new FilePath("!backups");
            string = bFileSystem.makeDir((FilePath)string2);
            defaultDir = BOrd.make((OrdQuery)string2);
        }
        string2 = bFoxSession.getStationName();
        string = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
        String string3 = "backup_" + string2 + '_' + string + ".dist";
        BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)bWidget);
        bFileChooser.setCurrentDirectory(defaultDir);
        bFileChooser.setDefaultFileName(string3);
        bFileChooser.addFilter((IFileFilter)new ExtFileFilter(BDistributionFile.TYPE.getDisplayName(null), "dist"));
        BOrd bOrd = bFileChooser.show();
        if (bOrd == null) {
            return null;
        }
        defaultDir = bFileChooser.getCurrentDirectory();
        String string4 = BBackupManager.toFilePath(bOrd).getBody();
        return BBackupManager.submitBackupJob(string4, bFoxSession);
    }

    public static BOrd submitBackupJob(String string, BFoxSession bFoxSession) {
        int n = bFoxSession.getConnection().session().getRemoteId();
        BFoxBackupJob bFoxBackupJob = new BFoxBackupJob();
        bFoxBackupJob.setPostSessionId(n);
        bFoxBackupJob.setPostPath(string);
        bFoxSession.getConnection().getChannels().getFileChannel().fw(901, (Object)string, null, null, null);
        BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get((BObject)bFoxSession);
        BOrd bOrd = bJobService.submit((BJob)bFoxBackupJob, null);
        BBackupManager.finishFoxBackupJob(bOrd, (BComponent)bJobService);
        return bOrd;
    }

    public static void finishFoxBackupJob(BOrd bOrd, BComponent bComponent) {
        try {
            ((BComponentSpace)bComponent.getSpace()).sync();
            BFoxBackupJob bFoxBackupJob = (BFoxBackupJob)BOrd.make((String)("station:|" + bOrd)).get((BObject)bComponent);
            if (jobCompleteSubscriber == null) {
                jobCompleteSubscriber = new JobCompleteSubscriber();
            }
            jobCompleteSubscriber.subscribe((BComponent)bFoxBackupJob);
        }
        catch (Exception exception) {
            BBackupService.log.error("Cannot finish cleaning up backup job", (Throwable)exception);
        }
    }

    static FilePath toFilePath(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n] instanceof FilePath) {
                return (FilePath)ordQueryArray[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cmdBackup = new Backup((BWidget)this);
        this.recs = new BBackupRecord[0];
    }

    public BBackupManager() {
        this.this();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        this.table = new BTable((TableModel)new Model());
        BTitlePane bTitlePane = BTitlePane.makePane((String)lex.getText("backups"), (BTable)this.table);
        BGridPane bGridPane = new BGridPane();
        bGridPane.add(null, (BValue)new BButton(this.cmdBackup));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5, (double)0.0)));
        bEdgePane.setCenter((BWidget)bTitlePane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 10.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)bEdgePane);
    }

    static {
        Class clazz = class$com$tridium$backup$ui$BBackupManager;
        if (clazz == null) {
            clazz = class$com$tridium$backup$ui$BBackupManager = BBackupManager.class("[Lcom.tridium.backup.ui.BBackupManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$backup$ui$BBackupManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$backup$ui$BBackupManager = BBackupManager.class("[Lcom.tridium.backup.ui.BBackupManager;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        icon = BImage.make((String)"module://icons/x16/backup.png");
        defaultDir = null;
    }

    private static class JobCompleteSubscriber
    extends Subscriber {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void event(BComponentEvent bComponentEvent) {
            if (!(bComponentEvent.getSourceComponent() instanceof BFoxBackupJob)) return;
            BFoxBackupJob bFoxBackupJob = (BFoxBackupJob)bComponentEvent.getSourceComponent();
            if (bComponentEvent.getId() != 0) return;
            if (!bComponentEvent.getSlot().equals((Object)BJob.jobState)) return;
            if (!((BJobState)bComponentEvent.getValue()).isComplete()) return;
            try {
                try {
                    BFoxSession bFoxSession = (BFoxSession)BOrd.toSession((BObject)bFoxBackupJob);
                    FilePath filePath = new FilePath(bFoxBackupJob.getPostPath());
                    bFoxSession.getConnection().getChannels().getFileChannel().fw(902, (Object)filePath, null, null, null);
                }
                catch (Exception exception) {
                    BBackupService.log.error("Cannot finish cleaning up backup job", (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.unsubscribe((BComponent)bFoxBackupJob);
                throw throwable;
            }
            {
                Object var4_8 = null;
            }
            this.unsubscribe((BComponent)bFoxBackupJob);
        }

        private JobCompleteSubscriber() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Backup
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BOrd bOrd = BBackupManager.promptAndSubmit(this.getOwner(), BBackupManager.this.backupService);
            if (bOrd == null) {
                return null;
            }
            BBackupManager.this.backupService.getComponentSpace().sync();
            BFoxBackupJob bFoxBackupJob = (BFoxBackupJob)bOrd.get((BObject)BBackupManager.this.backupService);
            BBackupManager.this.registerForComponentEvents((BComponent)bFoxBackupJob);
            BBackupManager.this.jobBar.load((BJob)bFoxBackupJob);
            return null;
        }

        Backup(BWidget bWidget) {
            super(bWidget, lex, "backup");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TableModel {
        public int getRowCount() {
            return BBackupManager.this.recs.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BBackupRecord.timestamp.getDefaultDisplayName(null);
                }
                case 1: {
                    return BBackupRecord.host.getDefaultDisplayName(null);
                }
                case 2: {
                    return BBackupRecord.path.getDefaultDisplayName(null);
                }
                case 3: {
                    return BBackupRecord.user.getDefaultDisplayName(null);
                }
            }
            return "???";
        }

        public Object getSubject(int n) {
            return BBackupManager.this.recs[n];
        }

        public Object getValueAt(int n, int n2) {
            BBackupRecord bBackupRecord = BBackupManager.this.recs[n];
            switch (n2) {
                case 0: {
                    return bBackupRecord.getTimestamp();
                }
                case 1: {
                    return bBackupRecord.getHost();
                }
                case 2: {
                    return bBackupRecord.getPath();
                }
                case 3: {
                    return bBackupRecord.getUser();
                }
            }
            return "???";
        }

        public BImage getRowIcon(int n) {
            return icon;
        }

        Model() {
        }
    }
}

