/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup.hx;

import com.tridium.backup.BBackupRecord;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import com.tridium.util.TimeFormat;
import javax.baja.backup.BBackupService;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHxBackupManager
extends BHxView {
    public static final BHxBackupManager INSTANCE = new BHxBackupManager();
    public static final Type TYPE;
    public static final Lexicon lexicon;
    static final BImage icon;
    static /* synthetic */ Class class$com$tridium$backup$hx$BHxBackupManager;

    public Type getType() {
        return TYPE;
    }

    public void write(HxOp hxOp) throws Exception {
        ViewQuery viewQuery = hxOp.getViewQuery();
        if (viewQuery == null || viewQuery.getParameter("startBackup", null) == null) {
            this.doWrite(hxOp);
        } else {
            this.backup(hxOp);
        }
    }

    public void doWrite(HxOp hxOp) throws Exception {
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        hxOp.setDynamic();
        htmlWriter.w((Object)"<div ").attr("id", hxOp.scope("content"));
        if (hxOp.getUserAgent().isIE()) {
            htmlWriter.print(" hollyHack");
        }
        htmlWriter.println("'>");
        this.writeBackupTable(hxOp);
        BOrd bOrd = BOrd.make((BOrd)hxOp.getOrdWithoutViewQuery(), (OrdQuery)new ViewQuery("?startBackup=true"));
        htmlWriter.w((Object)"<div class='hx-AbstractManager-toolbar' style='margin-top: 10px;'>");
        htmlWriter.println("<input class='button' type=button name='" + hxOp.scope("backup") + "' value='" + lexicon.getText("backup.label") + "' onclick='window.location=\"" + hxOp.toUri(bOrd) + "\"' />");
        htmlWriter.w((Object)"</div>");
        htmlWriter.println("</div>");
    }

    void writeBackupTable(HxOp hxOp) throws Exception {
        BBackupService bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        BBackupRecord[] bBackupRecordArray = BBackupRecord.list(bBackupService);
        HtmlWriter htmlWriter = hxOp.getHtmlWriter();
        htmlWriter.w((Object)"<div class='controlShadow-bg tableViewHeader'>");
        htmlWriter.w((Object)"<span style='float:right'>").w(bBackupRecordArray.length).w((Object)(" " + lexicon.getText("backups") + "</span>"));
        htmlWriter.w((Object)lexicon.getText("backups"));
        htmlWriter.w((Object)"</div>");
        htmlWriter.w((Object)"<div ").attr("id", hxOp.scope("content")).w((Object)">");
        htmlWriter.w((Object)"<table width='100%' cellpadding='0' cellspacing='0'>");
        htmlWriter.w((Object)"<tr>");
        htmlWriter.w((Object)"<td class='tableHeader' style='white-space:nowrap; padding-right: 20px;'>").safe(BBackupRecord.timestamp.getDefaultDisplayName(null)).w((Object)"</td>");
        htmlWriter.w((Object)"<td class='tableHeader' style='white-space:nowrap; padding-right: 20px;'>").safe(BBackupRecord.host.getDefaultDisplayName(null)).w((Object)"</td>");
        htmlWriter.w((Object)"<td class='tableHeader' style='white-space:nowrap; padding-right: 20px;'>").safe(BBackupRecord.path.getDefaultDisplayName(null)).w((Object)"</td>");
        htmlWriter.w((Object)"<td class='tableHeader' style='white-space:nowrap; width: 100%;'>").safe(BBackupRecord.user.getDefaultDisplayName(null)).w((Object)"</td>");
        htmlWriter.w((Object)"</tr>");
        int n = 0;
        while (n < bBackupRecordArray.length) {
            BBackupRecord bBackupRecord = bBackupRecordArray[n];
            htmlWriter.w((Object)"<tr>");
            htmlWriter.w((Object)"<td>");
            BOrd bOrd = icon.getOrdList().get(0);
            htmlWriter.w((Object)"<img alt='' ").attr("src", (Object)bOrd).w((Object)" style='vertical-align:middle;'/> ");
            htmlWriter.w((Object)bBackupRecord.getTimestamp());
            htmlWriter.w((Object)"</td>");
            htmlWriter.w((Object)("<td>" + bBackupRecord.getHost() + "</td>"));
            htmlWriter.w((Object)("<td>" + bBackupRecord.getPath() + "</td>"));
            htmlWriter.w((Object)("<td>" + bBackupRecord.getUser() + "</td>"));
            htmlWriter.w((Object)"</tr>");
            ++n;
        }
        htmlWriter.w((Object)"</table>");
    }

    void backup(HxOp hxOp) throws Exception {
        BBackupService bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        String string = Sys.getStation().getStationName();
        String string2 = TimeFormat.format((BAbsTime)Clock.time(), (String)"YYMMDD_HHmm");
        String string3 = "backup_" + string + '_' + string2 + ".dist";
        BStationSaveJob bStationSaveJob = new BStationSaveJob();
        Station.saveSync((BJob)bStationSaveJob);
        hxOp.setRaw();
        hxOp.setContentType("application/x-zip-compressed");
        hxOp.getResponse().setHeader("Content-Disposition", "attachment;filename=" + string3);
        bBackupService.zip(null, hxOp.getOutputStream(), true);
        BBackupRecord bBackupRecord = new BBackupRecord();
        bBackupRecord.setTimestamp(BAbsTime.make());
        bBackupRecord.setHost(hxOp.getRequest().getRemoteHost());
        bBackupRecord.setPath("hx:" + string3);
        bBackupRecord.setUser(hxOp.getUser().toString());
        bBackupRecord.append(bBackupService);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BHxBackupManager() {
    }

    static {
        Class clazz = class$com$tridium$backup$hx$BHxBackupManager;
        if (clazz == null) {
            clazz = class$com$tridium$backup$hx$BHxBackupManager = BHxBackupManager.class("[Lcom.tridium.backup.hx.BHxBackupManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$backup$hx$BHxBackupManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$backup$hx$BHxBackupManager = BHxBackupManager.class("[Lcom.tridium.backup.hx.BHxBackupManager;", false);
        }
        lexicon = Lexicon.make((Class)clazz2);
        icon = BImage.make((String)"module://icons/x16/backup.png");
    }
}

