/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup;

import com.tridium.backup.BBackupRecord;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.sys.station.Station;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.backup.BBackupService;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxBackupJob
extends BSimpleJob {
    public static final Property postSessionId = BFoxBackupJob.newProperty((int)4, (int)-1, null);
    public static final Property postPath = BFoxBackupJob.newProperty((int)4, (String)"", null);
    public static final Type TYPE;
    private static final BIcon icon;
    String host;
    FilePath path;
    String user;
    static /* synthetic */ Class class$com$tridium$backup$BFoxBackupJob;

    public int getPostSessionId() {
        return this.getInt(postSessionId);
    }

    public void setPostSessionId(int n) {
        this.setInt(postSessionId, n, null);
    }

    public String getPostPath() {
        return this.getString(postPath);
    }

    public void setPostPath(String string) {
        this.setString(postPath, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        BBackupService bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        int n = this.getPostSessionId();
        FoxSession foxSession = Fox.getSession((int)n);
        if (foxSession == null) {
            throw new Exception("Invalid fox session id: " + n);
        }
        BFoxConnection bFoxConnection = (BFoxConnection)foxSession.conn();
        BFileChannel bFileChannel = bFoxConnection.getChannels().getFileChannel();
        Context context2 = bFileChannel.getSessionContext();
        if (!bBackupService.getPermissions(context2).has(48)) {
            throw new PermissionException();
        }
        this.host = foxSession.getRemoteHost();
        this.path = new FilePath(this.getPostPath());
        this.user = context == null ? "unknown" : String.valueOf(context.getUser());
        this.log().message("Host: " + this.host);
        this.log().message("Path: " + this.path);
        this.log().message("User: " + this.user);
        Station.saveSync((BJob)this, (int)10);
        bFileChannel.makeFile(null, this.path);
        OutputStream outputStream = bFileChannel.write(new BFoxFileStore(null, this.path));
        bBackupService.zip((BJob)this, outputStream, true);
        BBackupRecord bBackupRecord = new BBackupRecord();
        bBackupRecord.setTimestamp(BAbsTime.make());
        bBackupRecord.setHost(this.host);
        bBackupRecord.setPath(this.path.toString());
        bBackupRecord.setUser(this.user);
        bBackupRecord.append(bBackupService);
    }

    public void writeBackupLog(PrintWriter printWriter) {
        printWriter.println("post.host=" + this.host);
        printWriter.println("post.path=" + this.path);
        printWriter.println("post.user=" + this.user);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$backup$BFoxBackupJob;
        if (clazz == null) {
            clazz = class$com$tridium$backup$BFoxBackupJob = BFoxBackupJob.class("[Lcom.tridium.backup.BFoxBackupJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"backup.png");
    }
}

