/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.sys.station.Station;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.security.PermissionException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBackupChannel
extends BFoxChannel {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$backup$BBackupChannel;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Exception {
        String string = foxRequest.command;
        throw new InvalidCommandException(string);
    }

    public void circuitOpened(FoxCircuit foxCircuit) throws Exception {
        String string = foxCircuit.command;
        if (string == "backup") {
            this.backup(foxCircuit);
            return;
        }
        if (string == "restore") {
            this.restore(foxCircuit);
            return;
        }
        throw new InvalidCommandException(string);
    }

    public InputStream backup(boolean bl) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:backup save=" + bl);
        }
        FoxCircuit foxCircuit = this.openCircuit("backup");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("save", bl);
        foxCircuit.writeMessage(foxMessage);
        FoxMessage foxMessage2 = foxCircuit.readMessage();
        return foxCircuit.getInputStream();
    }

    public void backup(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        boolean bl = foxMessage.getBoolean("save", false);
        FoxMessage foxMessage2 = new FoxMessage();
        foxCircuit.writeMessage(foxMessage2);
        BBackupService bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        if (!bBackupService.getPermissions(this.getSessionContext()).has(48)) {
            throw new PermissionException();
        }
        if (this.isTraceOn()) {
            this.trace("s:backup save=" + bl);
        }
        if (bl) {
            Station.saveSync();
        }
        OutputStream outputStream = foxCircuit.getOutputStream();
        bBackupService.zip(null, outputStream, true);
    }

    public void restore(BOrd bOrd, boolean bl, boolean bl2) throws Exception {
        if (this.isTraceOn()) {
            this.trace("c:rstore file=" + bOrd + " ignoreDependencies=" + bl + " deleteFile=" + bl2);
        }
        FoxCircuit foxCircuit = this.openCircuit("backup");
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("file", bOrd.encodeToString());
        foxMessage.add("ignoreDependencies", bl);
        foxMessage.add("deleteFile", bl2);
        foxCircuit.writeMessage(foxMessage);
        foxCircuit.readMessage();
    }

    public void restore(FoxCircuit foxCircuit) throws Exception {
        FoxMessage foxMessage = foxCircuit.readMessage();
        BOrd bOrd = (BOrd)BOrd.DEFAULT.decodeFromString(foxMessage.getString("file", BOrd.NULL.encodeToString()));
        boolean bl = foxMessage.getBoolean("ignoreDependencies", false);
        boolean bl2 = foxMessage.getBoolean("deleteFile", false);
        FoxMessage foxMessage2 = new FoxMessage();
        foxCircuit.writeMessage(foxMessage2);
        BBackupService bBackupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        if (!bBackupService.getPermissions(this.getSessionContext()).has(48)) {
            throw new PermissionException();
        }
        if (this.isTraceOn()) {
            this.trace("s:restore file=" + bOrd + " ignoreDependencies=" + bl + " deleteFile=" + bl2);
        }
        bBackupService.restoreFiles((BIFile)bOrd.resolve().get(), bl, bl2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            System.out.println("usage: BackupChannel <host> <port> <user> <pass> <outfile>");
            return;
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        File file = new File(stringArray[4]);
        Fox.appName = "BackupTool";
        Fox.appVersion = "" + TYPE.getModule().getVendorVersion();
        BFoxClientConnection bFoxClientConnection = new BFoxClientConnection();
        bFoxClientConnection.setRemoteHost(BHost.getHost((String)string), n);
        bFoxClientConnection.setUsername(string2);
        bFoxClientConnection.setPassword(BPassword.make((String)string3));
        System.out.println("Connecting to " + string + ':' + n + "...");
        bFoxClientConnection.connect();
        System.out.println("Connected!");
        System.out.println("Backing up...");
        BBackupChannel bBackupChannel = (BBackupChannel)bFoxClientConnection.getChannels().get("backup", TYPE);
        InputStream inputStream = bBackupChannel.backup(false);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        FileUtil.pipe((InputStream)inputStream, (OutputStream)bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        System.out.println("Backed up!");
        System.exit(0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBackupChannel() {
        super("backup");
    }

    static {
        Class clazz = class$com$tridium$backup$BBackupChannel;
        if (clazz == null) {
            clazz = class$com$tridium$backup$BBackupChannel = BBackupChannel.class("[Lcom.tridium.backup.BBackupChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

