/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.OrdVariableProcessor;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nd.file.BNiagaraFileDeviceExt;
import com.tridium.nd.file.BNiagaraFileImport;
import com.tridium.nd.util.BSimpleMap;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFileImportTag
extends BNiagaraExportTag {
    public static final Property stationSlotPath = BFileImportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:files"), (BFacets)BFileImportTag.makeStationSlotPathFacets());
    public static final Property fileImportName = BFileImportTag.newProperty((int)0, (BValue)BFormat.make((String)"%defaultFileImportName%"), null);
    public static final Property file = BFileImportTag.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), null);
    public static final Property supervisorDirectory = BFileImportTag.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations$(stationName)$(currentLocation)"), (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:OrdVariableFE"));
    public static final Property fileOverwritePolicy = BFileImportTag.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    public static final Property executionTime = BFileImportTag.newProperty((int)0, (BValue)BManualTriggerMode.make(), null);
    public static final Property useCategoryMask = BFileImportTag.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE;
    private String cachedDefaultFileName;
    static /* synthetic */ Class class$com$tridium$exporttags$tags$BFileImportTag;

    public final BFormat getFileImportName() {
        return (BFormat)this.get(fileImportName);
    }

    public final void setFileImportName(BFormat bFormat) {
        this.set(fileImportName, (BValue)bFormat, null);
    }

    public final BOrd getFile() {
        return (BOrd)this.get(file);
    }

    public final void setFile(BOrd bOrd) {
        this.set(file, (BValue)bOrd, null);
    }

    public final BOrd getSupervisorDirectory() {
        return (BOrd)this.get(supervisorDirectory);
    }

    public final void setSupervisorDirectory(BOrd bOrd) {
        this.set(supervisorDirectory, (BValue)bOrd, null);
    }

    public final BFileOverwritePolicy getFileOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(fileOverwritePolicy);
    }

    public final void setFileOverwritePolicy(BFileOverwritePolicy bFileOverwritePolicy) {
        this.set(fileOverwritePolicy, (BValue)bFileOverwritePolicy, null);
    }

    public final BTriggerMode getExecutionTime() {
        return (BTriggerMode)this.get(executionTime);
    }

    public final void setExecutionTime(BTriggerMode bTriggerMode) {
        this.set(executionTime, (BValue)bTriggerMode, null);
    }

    public final boolean getUseCategoryMask() {
        return this.getBoolean(useCategoryMask);
    }

    public final void setUseCategoryMask(boolean bl) {
        this.setBoolean(useCategoryMask, bl, null);
    }

    public final Type getType() {
        return TYPE;
    }

    protected final void doJoin(BINiagaraStation bINiagaraStation, BJob bJob, Subscriber subscriber, BCategoryMask bCategoryMask, Context context) throws Exception {
        if (this.getFile().isNull()) {
            throw new ExportTagException("fileImpExpTag.noFileOrd");
        }
        OrdQuery[] ordQueryArray = this.getFile().parse();
        if (ordQueryArray.length > 1) {
            throw new ExportTagException("fileImpExpTag.invalidFileOrd", this.getFile().toString());
        }
        if (!(ordQueryArray[0] instanceof FilePath)) {
            throw new ExportTagException("fileImpExpTag.invalidFileOrd", this.getFile().toString());
        }
        BIFile bIFile = (BIFile)this.getFile().get((BObject)this);
        this.cachedDefaultFileName = FileUtil.getBase((String)bIFile.getFileName());
        if (this.getSupervisorDirectory().isNull()) {
            throw new ExportTagException("fileImpExpTag.noSupOrd");
        }
        BNiagaraStation bNiagaraStation = (BNiagaraStation)bINiagaraStation;
        OrdVariableProcessor ordVariableProcessor = new OrdVariableProcessor();
        ordVariableProcessor.add(new OrdVariableProcessor.Replace("stationName", "/" + bNiagaraStation.getName()));
        ordVariableProcessor.add(new CurrentLocationHandler(bIFile));
        BOrd bOrd = BOrd.make((String)ordVariableProcessor.process(this.getSupervisorDirectory()).toString());
        OrdQuery[] ordQueryArray2 = bOrd.parse();
        if (ordQueryArray2.length != 1) {
            throw new ExportTagException("fileImpExpTag.invalidSupDirOrd", bOrd.toString());
        }
        if (!(ordQueryArray2[0] instanceof FilePath)) {
            throw new ExportTagException("fileImpExpTag.invalidSupDirOrd", bOrd.toString());
        }
        if (!bIFile.isDirectory()) {
            bOrd = BOrd.make((OrdQuery)((FilePath)ordQueryArray2[0]).merge(bIFile.getFileName()));
        }
        BNiagaraFileDeviceExt bNiagaraFileDeviceExt = bNiagaraStation.getFiles();
        subscriber.subscribe((BComponent)bNiagaraFileDeviceExt);
        String string = this.getFileImportName().format((Object)this);
        if (!SlotPath.isValidName((String)string)) {
            string = SlotPath.escape((String)string);
        }
        BNiagaraFileImport bNiagaraFileImport = (BNiagaraFileImport)BFileImportTag.findInstance((BComponent)bNiagaraFileDeviceExt, string, BNiagaraFileImport.TYPE);
        bNiagaraFileImport.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)this.getExecutionTime(), context);
        bNiagaraFileImport.set(BNiagaraFileImport.files, (BValue)BSimpleMap.make((BSimpleMap)BSimpleMap.DEFAULT, (BSimple)bOrd, (BSimple)this.getFile()), context);
        bNiagaraFileImport.set(BNiagaraFileImport.fileOverwritePolicy, (BValue)this.getFileOverwritePolicy(), context);
        if (this.getUseCategoryMask()) {
            BCategoryService bCategoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
            bCategoryService.setOrdMap(bCategoryService.getOrdMap().setCategoryMask(bOrd, bCategoryMask));
        }
        this.addTarget(string, (BComplex)bNiagaraFileImport, context);
        bNiagaraFileImport.doExecute();
    }

    public final String getDefaultFileImportName() {
        return this.cachedDefaultFileName + "Import";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cachedDefaultFileName = "";
    }

    public BFileImportTag() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$exporttags$tags$BFileImportTag;
        if (clazz == null) {
            clazz = class$com$tridium$exporttags$tags$BFileImportTag = BFileImportTag.class("[Lcom.tridium.exporttags.tags.BFileImportTag;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static final class CurrentLocationHandler
    implements OrdVariableProcessor.IVarHandler {
        private BIFile sourceFile;

        public final boolean accept(String string) {
            return string.equals("currentLocation");
        }

        public final BFacets get() {
            String string;
            FilePath filePath = this.sourceFile.getFilePath().getParent();
            if (filePath == null) {
                filePath = this.sourceFile.getFilePath();
            }
            if ((string = filePath.getBody()).startsWith("^")) {
                string = string.substring(1, string.length());
            }
            if (string.startsWith("!")) {
                string = string.substring(1, string.length());
            }
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            if (string.length() > 0) {
                string = "/" + string;
            }
            return BFacets.make((String)"currentLocation", (BIDataValue)BString.make((String)string));
        }

        public CurrentLocationHandler(BIFile bIFile) {
            this.sourceFile = bIFile;
        }
    }
}

