/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.exporttags.BSubordinateExportTagNetworkExt;
import com.tridium.exporttags.BSubordinateJoinJob;
import com.tridium.exporttags.util.BJoinInfo;
import com.tridium.exporttags.util.BStationInformation;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.exporttags.util.ExportTagUtil;
import com.tridium.exporttags.util.OrdVariableProcessor;
import com.tridium.nd.BNiagaraStation;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.BogEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BJoinProfile
extends BComponent
implements BIStatus,
BIMixIn {
    public static final Property status = BJoinProfile.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property enabled = BJoinProfile.newProperty((int)0, (boolean)false, null);
    public static final Property lastJoin = BJoinProfile.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property stationDisplayName = BJoinProfile.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    public static final Property defaultUser = BJoinProfile.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:UserNamePickerFE"));
    public static final Property defaultUserPassword = BJoinProfile.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property defaultIpAddress = BJoinProfile.newProperty((int)0, (BValue)BFormat.DEFAULT, null);
    public static final Property defaultPort = BJoinProfile.newProperty((int)0, (BValue)BFormat.make((String)"%foxService.port%"), null);
    public static final Property defaultUseFoxs = BJoinProfile.newProperty((int)0, (boolean)false, null);
    public static final Property defaultFoxsPort = BJoinProfile.newProperty((int)0, (BValue)BFormat.make((String)"%foxService.foxsPort%"), null);
    public static final Property stationFile = BJoinProfile.newProperty((int)0, (BValue)BOrd.make((String)"file:^joinProfiles$(defaultStationFileName).bog"), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:OrdVariableFE"), (BFacets)BFacets.make((String)"showLink", (BIDataValue)BBoolean.TRUE)));
    public static final Property stationInfo = BJoinProfile.newProperty((int)0, (BValue)new BStationInformation(), null);
    public static final Action join = BJoinProfile.newAction((int)8, null);
    public static final Action joinCompleted = BJoinProfile.newAction((int)4, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$com$tridium$exporttags$BJoinProfile;

    public final BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public final void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public final boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public final void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public final BAbsTime getLastJoin() {
        return (BAbsTime)this.get(lastJoin);
    }

    public final void setLastJoin(BAbsTime bAbsTime) {
        this.set(lastJoin, (BValue)bAbsTime, null);
    }

    public final BFormat getStationDisplayName() {
        return (BFormat)this.get(stationDisplayName);
    }

    public final void setStationDisplayName(BFormat bFormat) {
        this.set(stationDisplayName, (BValue)bFormat, null);
    }

    public final String getDefaultUser() {
        return this.getString(defaultUser);
    }

    public final void setDefaultUser(String string) {
        this.setString(defaultUser, string, null);
    }

    public final BPassword getDefaultUserPassword() {
        return (BPassword)this.get(defaultUserPassword);
    }

    public final void setDefaultUserPassword(BPassword bPassword) {
        this.set(defaultUserPassword, (BValue)bPassword, null);
    }

    public final BFormat getDefaultIpAddress() {
        return (BFormat)this.get(defaultIpAddress);
    }

    public final void setDefaultIpAddress(BFormat bFormat) {
        this.set(defaultIpAddress, (BValue)bFormat, null);
    }

    public final BFormat getDefaultPort() {
        return (BFormat)this.get(defaultPort);
    }

    public final void setDefaultPort(BFormat bFormat) {
        this.set(defaultPort, (BValue)bFormat, null);
    }

    public final boolean getDefaultUseFoxs() {
        return this.getBoolean(defaultUseFoxs);
    }

    public final void setDefaultUseFoxs(boolean bl) {
        this.setBoolean(defaultUseFoxs, bl, null);
    }

    public final BFormat getDefaultFoxsPort() {
        return (BFormat)this.get(defaultFoxsPort);
    }

    public final void setDefaultFoxsPort(BFormat bFormat) {
        this.set(defaultFoxsPort, (BValue)bFormat, null);
    }

    public final BOrd getStationFile() {
        return (BOrd)this.get(stationFile);
    }

    public final void setStationFile(BOrd bOrd) {
        this.set(stationFile, (BValue)bOrd, null);
    }

    public final BStationInformation getStationInfo() {
        return (BStationInformation)this.get(stationInfo);
    }

    public final void setStationInfo(BStationInformation bStationInformation) {
        this.set(stationInfo, (BValue)bStationInformation, null);
    }

    public final BOrd join() {
        return (BOrd)this.invoke(join, null, null);
    }

    public final void joinCompleted() {
        this.invoke(joinCompleted, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        this.updateStatus();
        this.checkStationFileOrd();
    }

    public final void changed(Property property, Context context) {
        if (this.isRunning() && property == enabled) {
            this.updateStatus();
            this.checkStationFileOrd();
        } else {
            super.changed(property, context);
        }
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNiagaraStation;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final BFacets getSlotFacets(Slot slot) {
        if (slot == stationFile) {
            try {
                BString bString = BString.make((String)("defaultStationFileName;/" + this.getDefaultStationFileName()));
                return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"ordVariables", (BIDataValue)bString);
            }
            catch (Exception exception) {
                ExportTagUtil.log.error("Generating Station File facets", (Throwable)exception);
            }
        }
        return super.getSlotFacets(slot);
    }

    final BJoinInfo getJoinInfo(BOrd bOrd, Context context) throws Exception {
        BJoinInfo bJoinInfo = new BJoinInfo();
        BOrd bOrd2 = this.getProcessedStationFileOrd();
        if (bOrd2.isNull()) {
            throw new ExportTagException("noStationFileSelected");
        }
        OrdVariableProcessor ordVariableProcessor = new OrdVariableProcessor(new StationInfoHandler(this.getStationInfo()));
        bJoinInfo.setStationFolderPath(ordVariableProcessor.process(bOrd));
        bJoinInfo.setStationDisplayName(this.getStationDisplayName().format((Object)this));
        bJoinInfo.setSupervisorStation(this.getSupervisorStation().getSlotPathOrd());
        bJoinInfo.setStationFile(bOrd2);
        return bJoinInfo;
    }

    public final BNiagaraStation getSupervisorStation() {
        return (BNiagaraStation)this.getParent();
    }

    private final void checkStationFileOrd() {
        block9: {
            if (this.getStatus().isDisabled()) {
                return;
            }
            try {
                BOrd bOrd = this.getProcessedStationFileOrd();
                boolean bl = false;
                try {
                    bOrd.get((BObject)this);
                    bl = true;
                }
                catch (Exception exception) {}
                if (bl) break block9;
                OrdQuery[] ordQueryArray = bOrd.parse();
                int n = 0;
                while (n < ordQueryArray.length) {
                    if (ordQueryArray[n] instanceof FilePath) {
                        BIFile bIFile = (BIFile)BOrd.make((String)"file:^").get((BObject)this);
                        BFileSpace bFileSpace = bIFile.getFileSpace();
                        try {
                            BUnrestrictedFolder bUnrestrictedFolder = new BUnrestrictedFolder();
                            bUnrestrictedFolder.add("niagaraStation", (BValue)new BNiagaraStation());
                            BIFile bIFile2 = bFileSpace.makeFile((FilePath)ordQueryArray[n]);
                            BogEncoder bogEncoder = new BogEncoder(bIFile2.getOutputStream());
                            bogEncoder.setZipped(true);
                            bogEncoder.encodeDocument((BValue)bUnrestrictedFolder);
                            bogEncoder.close();
                        }
                        catch (IOException iOException) {
                            ExportTagUtil.log.error("Creating default Station BOG file", (Throwable)iOException);
                        }
                        break;
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                ExportTagUtil.log.error("Could not create Station BOG file for Profile: " + this.toPathString(), (Throwable)exception);
            }
        }
    }

    final void updateStatus() {
        BSubordinateExportTagNetworkExt bSubordinateExportTagNetworkExt = (BSubordinateExportTagNetworkExt)Sys.getService((Type)BSubordinateExportTagNetworkExt.TYPE);
        BStatus bStatus = bSubordinateExportTagNetworkExt.getStatus();
        bStatus = BStatus.makeDisabled((BStatus)bStatus, (boolean)(this.getEnabled() ^ true));
        this.setStatus(bStatus);
    }

    public final BOrd getProcessedStationFileOrd() throws Exception {
        return new OrdVariableProcessor(new OrdVariableProcessor.Replace("defaultStationFileName", "/" + this.getDefaultStationFileName())).process(this.getStationFile());
    }

    private final String getDefaultStationFileName() {
        return this.getSupervisorStation().getName() + "_profile";
    }

    public final BOrd doJoin(Context context) throws Exception {
        if (this.getStatus().isDisabled()) {
            return BOrd.NULL;
        }
        BSubordinateExportTagNetworkExt bSubordinateExportTagNetworkExt = (BSubordinateExportTagNetworkExt)Sys.getService((Type)BSubordinateExportTagNetworkExt.TYPE);
        return new BSubordinateJoinJob(bSubordinateExportTagNetworkExt, this).submit(context);
    }

    public final void doJoinCompleted(Context context) throws Exception {
        this.setLastJoin(BAbsTime.now());
    }

    public final String getDisplayNameInParent(Context context) {
        Lexicon lexicon = Lexicon.make((BModule)this.getType().getModule(), (Context)context);
        return lexicon.get("joinProfile");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$exporttags$BJoinProfile;
        if (clazz == null) {
            clazz = class$com$tridium$exporttags$BJoinProfile = BJoinProfile.class("[Lcom.tridium.exporttags.BJoinProfile;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"sync.png"), (BIcon)BIcon.std((String)"badges/add.png"));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class StationInfoHandler
    implements OrdVariableProcessor.IVarHandler {
        private BStationInformation info;
        private BValue value;
        private String var;

        public boolean accept(String string) {
            this.value = this.info.get(string);
            if (this.value != null) {
                this.var = string;
                return true;
            }
            return false;
        }

        public BFacets get() {
            String string = SlotPath.escape((String)this.value.toString());
            if (string.length() > 0) {
                string = "/" + string;
            }
            return BFacets.make((String)this.var, (BIDataValue)BString.make((String)string));
        }

        private final /* synthetic */ void this() {
            this.value = null;
            this.var = "";
        }

        private StationInfoHandler(BStationInformation bStationInformation) {
            this.this();
            this.info = bStationInformation;
        }
    }
}

