/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TypeNodeBuilder {
    private final Map typeNodeMap;
    private final TypeNodeVisitor superVisitor;
    private final TypeNodeVisitor interfaceVisitor;
    private final TypeNodeVisitor complexVisitor;

    public static final TypeNodeBuilder make() {
        return new TypeNodeBuilder();
    }

    public final TypeNode get(String string) throws TypeNotFoundException, TypeNotIncludedException, Exception {
        TypeNode typeNode = this.findTypeNode(string);
        if (typeNode == null) {
            TypeInfo typeInfo = Sys.getRegistry().getType(string);
            typeNode = this.makeTypeNode(typeInfo);
            if (typeNode != null) {
                this.putTypeNode(typeNode);
                this.runExpanderVisitors(typeNode);
            } else {
                throw new TypeNotIncludedException(string);
            }
        }
        return typeNode;
    }

    public final TypeNode[] get(String[] stringArray) throws TypeNotFoundException, TypeNotIncludedException, Exception {
        TypeNode[] typeNodeArray = new TypeNode[stringArray.length];
        int n = 0;
        while (n < typeNodeArray.length) {
            typeNodeArray[n] = this.get(stringArray[n]);
            ++n;
        }
        return typeNodeArray;
    }

    public final void clear() {
        this.typeNodeMap.clear();
        this.superVisitor.clear();
        this.interfaceVisitor.clear();
        this.complexVisitor.clear();
    }

    public final int getSize() {
        return this.typeNodeMap.size();
    }

    private final void runExpanderVisitors(TypeNode typeNode) throws Exception {
        typeNode.visit(this.superVisitor);
        typeNode.visit(this.interfaceVisitor);
        typeNode.visit(this.complexVisitor);
    }

    private final TypeNode makeTypeNode(TypeInfo typeInfo) {
        return new TypeNode(typeInfo);
    }

    private final void putTypeNode(TypeNode typeNode) {
        this.typeNodeMap.put(typeNode.toString(), typeNode);
    }

    private final TypeNode findTypeNode(String string) {
        return (TypeNode)this.typeNodeMap.get(string);
    }

    public static final void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            TypeNodeBuilder.make().get(stringArray[0]).visit(new TraceDependenciesVisitor());
        } else {
            System.out.println("Please enter a type spec as an argument!");
        }
        System.exit(0);
    }

    private final /* synthetic */ void this() {
        this.typeNodeMap = new HashMap();
        this.superVisitor = new SuperVisitor();
        this.interfaceVisitor = new InterfaceVisitor();
        this.complexVisitor = new ComplexVisitor();
    }

    private TypeNodeBuilder() {
        this.this();
    }

    public static final class TypeNotIncludedException
    extends TypeException {
        private TypeNotIncludedException(String string) {
            super("Type Not Included: " + string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class TypeNode {
        private int hashCode;
        private TypeInfo typeInfo;
        private Object cache;
        private String cacheKey;
        private Set dependencies;

        public final void visit(TypeNodeVisitor typeNodeVisitor) throws Exception {
            if (typeNodeVisitor.visit(this)) {
                this.visitDependencies(typeNodeVisitor);
            }
        }

        public final void visitDependencies(TypeNodeVisitor typeNodeVisitor) throws Exception {
            if (this.dependencies != null) {
                Iterator iterator = this.dependencies.iterator();
                while (iterator.hasNext()) {
                    TypeNode typeNode = (TypeNode)iterator.next();
                    typeNode.visit(typeNodeVisitor);
                }
            }
        }

        private final void addDependency(TypeNode typeNode) {
            if (this.dependencies == null) {
                this.dependencies = new HashSet();
            }
            if (!this.dependencies.contains(typeNode)) {
                this.dependencies.add(typeNode);
            }
        }

        public final String toString() {
            return this.typeInfo.toString();
        }

        public final boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof TypeNode)) {
                return false;
            }
            TypeNode typeNode = (TypeNode)object;
            boolean bl = false;
            if (typeNode.hashCode() == this.hashCode()) {
                bl = true;
            }
            return bl;
        }

        public final int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.typeInfo.toString().hashCode();
            }
            return this.hashCode;
        }

        public final TypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        public final boolean hasCache() {
            boolean bl = false;
            if (this.cache != null) {
                bl = true;
            }
            return bl;
        }

        public final Object getCache() {
            return this.cache;
        }

        public final String getCacheKey() {
            return this.cacheKey;
        }

        public final void setCache(String string, Object object) {
            this.cacheKey = string;
            this.cache = object;
        }

        private final /* synthetic */ void this() {
            this.hashCode = -1;
            this.cacheKey = "";
        }

        private TypeNode(TypeInfo typeInfo) {
            this.this();
            this.typeInfo = typeInfo;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class TraceDependenciesVisitor
    extends TypeNodeVisitor {
        private int indent;

        public final boolean doVisit(TypeNode typeNode) throws Exception {
            char[] cArray = new char[this.indent * 2];
            int n = 0;
            while (n < cArray.length) {
                cArray[n] = 32;
                ++n;
            }
            System.out.print(cArray);
            System.out.println(typeNode);
            TraceDependenciesVisitor traceDependenciesVisitor = new TraceDependenciesVisitor();
            traceDependenciesVisitor.indent = this.indent + 1;
            typeNode.visitDependencies(traceDependenciesVisitor);
            return false;
        }

        private final /* synthetic */ void this() {
            this.indent = 0;
        }

        public TraceDependenciesVisitor() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class SuperVisitor
    extends TypeNodeVisitor {
        public final boolean doVisit(TypeNode typeNode) throws Exception {
            TypeInfo typeInfo = typeNode.typeInfo.getSuperType();
            if (typeInfo != null) {
                TypeNode typeNode2 = TypeNodeBuilder.this.findTypeNode(typeInfo.toString());
                if (typeNode2 == null && (typeNode2 = TypeNodeBuilder.this.makeTypeNode(typeInfo)) != null) {
                    TypeNodeBuilder.this.putTypeNode(typeNode2);
                    typeNode2.visit(TypeNodeBuilder.this.interfaceVisitor);
                    typeNode2.visit(this);
                    typeNode2.visit(TypeNodeBuilder.this.complexVisitor);
                }
                if (typeNode2 != null) {
                    typeNode.addDependency(typeNode2);
                }
            }
            return true;
        }

        private SuperVisitor() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class InterfaceVisitor
    extends TypeNodeVisitor {
        public final boolean doVisit(TypeNode typeNode) throws Exception {
            TypeInfo[] typeInfoArray = typeNode.typeInfo.getInterfaces();
            if (typeInfoArray != null) {
                int n = 0;
                while (n < typeInfoArray.length) {
                    TypeNode typeNode2 = TypeNodeBuilder.this.findTypeNode(typeInfoArray[n].toString());
                    if (typeNode2 == null && (typeNode2 = TypeNodeBuilder.this.makeTypeNode(typeInfoArray[n])) != null) {
                        TypeNodeBuilder.this.putTypeNode(typeNode2);
                        typeNode2.visit(TypeNodeBuilder.this.superVisitor);
                        typeNode2.visit(this);
                    }
                    if (typeNode2 != null) {
                        typeNode.addDependency(typeNode2);
                    }
                    ++n;
                }
            }
            return true;
        }

        private InterfaceVisitor() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class ComplexVisitor
    extends TypeNodeVisitor {
        public final boolean doVisit(TypeNode typeNode) throws Exception {
            if (typeNode.typeInfo.is(BComplex.TYPE)) {
                ComplexType complexType = (ComplexType)typeNode.typeInfo.getTypeSpec().getResolvedType();
                NSlot[] nSlotArray = complexType.getFrozenSlots();
                int n = 0;
                while (n < nSlotArray.length) {
                    Property property;
                    NSlot nSlot = nSlotArray[n];
                    if (!nSlot.getDeclaringType().equals(complexType)) {
                        this.scan(typeNode, nSlot.getDeclaringType().getTypeInfo());
                    } else if (nSlot.isProperty()) {
                        property = nSlot.asProperty();
                        this.scanValue(typeNode, property instanceof NProperty ? ((NProperty)property).value : property.getDefaultValue());
                    } else if (nSlot.isAction()) {
                        property = nSlot.asAction();
                        if (property.getParameterDefault() != null) {
                            this.scanValue(typeNode, property.getParameterDefault());
                        }
                        if (property.getReturnType() != null) {
                            this.scan(typeNode, property.getReturnType().getTypeInfo());
                        }
                    } else if (nSlot.isTopic() && nSlot.asTopic().getEventType() != null) {
                        this.scan(typeNode, nSlot.asTopic().getEventType().getTypeInfo());
                    }
                    ++n;
                }
            }
            return true;
        }

        private final void scan(TypeNode typeNode, TypeInfo typeInfo) throws Exception {
            TypeNode typeNode2 = TypeNodeBuilder.this.findTypeNode(typeInfo.toString());
            if (typeNode2 == null && (typeNode2 = TypeNodeBuilder.this.makeTypeNode(typeInfo)) != null) {
                TypeNodeBuilder.this.putTypeNode(typeNode2);
                TypeNodeBuilder.this.runExpanderVisitors(typeNode2);
            }
            if (typeNode2 != null) {
                typeNode.addDependency(typeNode2);
            }
        }

        private final void scanValue(TypeNode typeNode, BValue bValue) throws Exception {
            this.scan(typeNode, bValue.getType().getTypeInfo());
            if (bValue instanceof BComplex) {
                BComplex bComplex = (BComplex)bValue;
                SlotCursor slotCursor = bComplex.getProperties();
                while (slotCursor.next()) {
                    this.scanValue(typeNode, bComplex.get(slotCursor.property()));
                }
            }
        }

        private ComplexVisitor() {
        }
    }
}

