/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.typenode;

import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.box.typenode.CommonTypes;
import com.tridium.box.typenode.TypeNodeBuilder;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Type;

public final class ContractEncoderVisitor
extends TypeNodeVisitor {
    private BoxWriter out;
    private Context cx;

    public final boolean doVisit(TypeNodeBuilder.TypeNode typeNode) throws Exception {
        String string = typeNode.toString();
        this.out.key(string);
        boolean bl = CommonTypes.isCommonType(string) ^ true;
        if (bl) {
            this.encode(typeNode, this.out);
        } else {
            this.out.array().endArray();
        }
        return bl;
    }

    final void encode(TypeNodeBuilder.TypeNode typeNode, BoxWriter boxWriter) throws Exception {
        EnumType enumType;
        int[] nArray;
        Type type = typeNode.getTypeInfo().getTypeSpec().getResolvedType();
        boxWriter.array();
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            NSlot[] nSlotArray = complexType.getFrozenSlots();
            if (nSlotArray != null) {
                int n = 0;
                while (n < nSlotArray.length) {
                    NSlot nSlot = nSlotArray[n];
                    if (nSlot.getDeclaringType().equals(type)) {
                        Property property;
                        BFacets bFacets;
                        String string;
                        if (nSlot.isProperty()) {
                            string = "p";
                        } else if (nSlot.isAction()) {
                            string = "a";
                        } else if (nSlot.isTopic()) {
                            string = "t";
                        } else {
                            throw new IllegalStateException();
                        }
                        boxWriter.object();
                        boxWriter.key("st").value((Object)string);
                        boxWriter.key("n").value((Object)nSlot.getName());
                        boxWriter.key("dn").value((Object)nSlot.getDefaultDisplayName(this.cx));
                        int n2 = nSlot.getDefaultFlags();
                        if (n2 > 0) {
                            boxWriter.key("f").value((Object)Flags.encodeToString((int)n2));
                        }
                        if (!(bFacets = nSlot.getFacets()).isNull()) {
                            boxWriter.key("x").value((Object)bFacets.encodeToString());
                        }
                        BsonEncoderPlugin.DisplayEncoder displayEncoder = null;
                        if (nSlot.isProperty()) {
                            boxWriter.key("v");
                            property = nSlot.asProperty();
                            BValue bValue = property instanceof NProperty ? ((NProperty)property).value : property.getDefaultValue();
                            displayEncoder = new BsonEncoderPlugin.DisplayEncoder(new BsonEncoderPlugin(boxWriter), (Context)new BasicContext(this.cx, bValue.isComponent() ? BFacets.DEFAULT : bFacets));
                            displayEncoder.encode(bValue);
                        } else {
                            displayEncoder = new BsonEncoderPlugin.DisplayEncoder(new BsonEncoderPlugin(boxWriter), (Context)new BasicContext(this.cx, bFacets));
                            if (nSlot.isAction()) {
                                property = nSlot.asAction();
                                BsonEncoderPlugin.encodeActionBson(displayEncoder, property.getParameterType(), property.getParameterDefault(), property.getReturnType());
                            }
                            if (nSlot.isTopic()) {
                                property = nSlot.asTopic();
                                BsonEncoderPlugin.encodeTopicBson(displayEncoder, property.getEventType());
                            }
                        }
                        boxWriter.endObject();
                    }
                    ++n;
                }
            }
        } else if (type instanceof EnumType && (nArray = (enumType = (EnumType)type).getOrdinals()) != null) {
            int n = 0;
            while (n < nArray.length) {
                boxWriter.object().key("t").value((Object)enumType.getTag(nArray[n]));
                boxWriter.key("dt").value((Object)enumType.getDisplayTag(nArray[n], this.cx));
                boxWriter.key("o").value((long)nArray[n]).endObject();
                ++n;
            }
        }
        boxWriter.endArray();
    }

    public ContractEncoderVisitor(BoxWriter boxWriter, Context context) {
        this.out = boxWriter;
        this.cx = context;
    }
}

