/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box.json;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import javax.baja.io.ValueDocDecoder;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BsonDecoderPlugin
implements ValueDocDecoder.IDecoderPlugin {
    public static final ValueDocDecoder.ITypeResolver defaultTypeResolver = new BsonTypeResolver();
    private static final Log defaultLog = Log.getLog((String)"sys.json");
    private Array elems;
    private int index;
    private ValueDocDecoder.ITypeResolver typeResolver;
    private Log log;
    private int warningCount;
    static /* synthetic */ Class class$com$tridium$box$json$BsonDecoderPlugin$BsonElement;

    public final BValue decodeDocument(ValueDocDecoder valueDocDecoder) throws Exception {
        this.next();
        return valueDocDecoder.decode();
    }

    public final int next() throws Exception {
        if (this.index >= this.elems.size()) {
            return -1;
        }
        ++this.index;
        return this.type();
    }

    public final ValueDocDecoder.IElement elem() {
        if (this.index >= this.elems.size()) {
            return null;
        }
        if (this.index < 0) {
            return null;
        }
        return (BsonElement)this.elems.get(this.index);
    }

    public final void skip() throws Exception {
        this.skip(this.depth());
    }

    public final void skip(int n) throws Exception {
        do {
            if (this.type() == 2 && this.depth() == n) {
                return;
            }
            this.next();
        } while (this.type() != -1);
        throw new EOFException();
    }

    public final int type() {
        if (this.index >= this.elems.size()) {
            return -1;
        }
        if (this.elem() != null) {
            return ((BsonElement)this.elem()).isEnd() + 1;
        }
        return -1;
    }

    public final int line() {
        return -1;
    }

    public final int column() {
        return -1;
    }

    public final void close() {
    }

    public final int depth() {
        if (this.index < 0) {
            return 0;
        }
        if (this.index >= this.elems.size()) {
            return 0;
        }
        return ((BsonElement)this.elems.get(this.index)).depth;
    }

    private final void add(JSONObject jSONObject, int n) throws Exception {
        Object object;
        BsonElement bsonElement = new BsonElement(jSONObject, n);
        this.elems.add((Object)bsonElement);
        ++n;
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            object = jSONObject.get(iterator.next().toString());
            if (object instanceof JSONObject) {
                this.add((JSONObject)object, n);
                continue;
            }
            if (!(object instanceof JSONArray)) continue;
            JSONArray jSONArray = (JSONArray)object;
            int n2 = 0;
            while (n2 < jSONArray.length()) {
                if (jSONArray.get(n2) instanceof JSONObject) {
                    this.add((JSONObject)jSONArray.get(n2), n);
                }
                ++n2;
            }
        }
        object = (BsonElement)bsonElement.copy();
        ((BsonElement)object).end = true;
        this.elems.add(object);
    }

    public final String getEncoding() throws IOException {
        return "";
    }

    public final boolean isZipped() throws IOException {
        return false;
    }

    public final ValueDocDecoder.IElement parse() throws Exception {
        return this.parse(true);
    }

    public final ValueDocDecoder.IElement parse(boolean bl) throws Exception {
        if (this.next() != 1) {
            if (bl) {
                this.close();
            }
            throw this.err("Expecting element start");
        }
        return this.parseCurrent(bl);
    }

    public final ValueDocDecoder.IElement parseCurrent() throws Exception {
        return this.parseCurrent(false);
    }

    public final ValueDocDecoder.IElement parseCurrent(boolean bl) throws Exception {
        return this.elem();
    }

    public final ValueDocDecoder.ITypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public final void setTypeResolver(ValueDocDecoder.ITypeResolver iTypeResolver) {
        this.typeResolver = iTypeResolver == null ? defaultTypeResolver : iTypeResolver;
    }

    public final RuntimeException err(String string, Throwable throwable) {
        return new BsonException(string, (BsonElement)this.elem(), throwable);
    }

    public final RuntimeException err(String string) {
        return new BsonException(string, (BsonElement)this.elem());
    }

    public final void warningAndSkip(String string) throws RuntimeException {
        this.warning(string);
        try {
            this.skip();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BsonException(exception);
        }
    }

    public final void warning(String string) throws RuntimeException {
        this.log.warning(string);
        ++this.warningCount;
    }

    public final Log getLog() {
        return this.log;
    }

    public final void setLog(Log log) {
        this.log = log;
    }

    public final int getWarningCount() {
        return this.warningCount;
    }

    public static final BValue unmarshal(String string) throws Exception {
        BsonDecoderPlugin bsonDecoderPlugin = new BsonDecoderPlugin(new ByteArrayInputStream(string.getBytes()));
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)bsonDecoderPlugin);
        valueDocDecoder.next();
        return valueDocDecoder.decode();
    }

    public static final BValue unmarshal(String string, ValueDocDecoder.ITypeResolver iTypeResolver) throws Exception {
        BsonDecoderPlugin bsonDecoderPlugin = new BsonDecoderPlugin(new ByteArrayInputStream(string.getBytes()));
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)bsonDecoderPlugin);
        valueDocDecoder.setTypeResolver(iTypeResolver);
        valueDocDecoder.next();
        return valueDocDecoder.decode();
    }

    public static final BValue unmarshal(JSONObject jSONObject) throws Exception {
        BsonDecoderPlugin bsonDecoderPlugin = new BsonDecoderPlugin(jSONObject);
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)bsonDecoderPlugin);
        valueDocDecoder.next();
        return valueDocDecoder.decode();
    }

    public static final BValue unmarshal(JSONObject jSONObject, ValueDocDecoder.ITypeResolver iTypeResolver) throws Exception {
        BsonDecoderPlugin bsonDecoderPlugin = new BsonDecoderPlugin(jSONObject);
        ValueDocDecoder valueDocDecoder = new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)bsonDecoderPlugin);
        valueDocDecoder.setTypeResolver(iTypeResolver);
        valueDocDecoder.next();
        return valueDocDecoder.decode();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$box$json$BsonDecoderPlugin$BsonElement;
        if (clazz == null) {
            clazz = class$com$tridium$box$json$BsonDecoderPlugin$BsonElement = BsonDecoderPlugin.class("[Lcom.tridium.box.json.BsonDecoderPlugin$BsonElement;", false);
        }
        this.elems = new Array(clazz);
        this.index = -1;
        this.typeResolver = new BsonTypeResolver();
        this.log = defaultLog;
    }

    public BsonDecoderPlugin(InputStream inputStream) throws Exception {
        this.this();
        JSONTokener jSONTokener = new JSONTokener((Reader)new InputStreamReader(new BufferedInputStream(inputStream)));
        JSONObject jSONObject = new JSONObject(jSONTokener);
        this.add(jSONObject, 0);
    }

    public BsonDecoderPlugin(JSONObject jSONObject) throws Exception {
        this.this();
        this.add(jSONObject, 0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class BsonElement
    implements ValueDocDecoder.IElement {
        private JSONObject obj;
        private int depth;
        private String[] keys;
        private boolean end;

        public final String name() {
            try {
                return this.obj.getString("nm");
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final String get(String string) {
            try {
                return this.obj.getString(string);
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final String get(String string, String string2) {
            try {
                if (this.obj.has(string)) {
                    return this.obj.getString(string);
                }
                return string2;
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final int geti(String string) {
            try {
                return this.obj.getInt(string);
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final int geti(String string, int n) {
            try {
                if (this.obj.has(string)) {
                    return this.obj.getInt(string);
                }
                return n;
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final double getd(String string) {
            try {
                return this.obj.getDouble(string);
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final double getd(String string, double d) {
            try {
                if (this.obj.has(string)) {
                    return this.obj.getDouble(string);
                }
                return d;
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final float getf(String string) {
            return (float)this.getd(string);
        }

        public final float getf(String string, float f) {
            return (float)this.getd(string, f);
        }

        public final long getl(String string) {
            try {
                return this.obj.getInt(string);
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final long getl(String string, long l) {
            try {
                if (this.obj.has(string)) {
                    return this.obj.getLong(string);
                }
                return l;
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final int attrSize() {
            return this.keys.length;
        }

        public final String attrName(int n) {
            return this.keys[n];
        }

        public final String attrValue(int n) {
            try {
                return this.obj.getString(this.keys[n]);
            }
            catch (JSONException jSONException) {
                throw new BsonException(jSONException);
            }
        }

        public final ValueDocDecoder.IElement copy() {
            return new BsonElement(this.obj, this.depth);
        }

        public final String toString() {
            try {
                return this.obj.toString(2);
            }
            catch (JSONException jSONException) {
                return "error in generating BSON";
            }
        }

        public final JSONObject getJsonObject() {
            return this.obj;
        }

        public final boolean isEnd() {
            return this.end;
        }

        static final /* synthetic */ boolean access$1(BsonElement bsonElement) {
            return bsonElement.end;
        }

        private final /* synthetic */ void this() {
            this.end = false;
        }

        private BsonElement(JSONObject jSONObject, int n) {
            this.this();
            this.obj = jSONObject;
            this.depth = n;
            this.keys = JSONObject.getNames((JSONObject)jSONObject);
            int n2 = 0;
            while (n2 < this.keys.length) {
                this.keys[n2] = this.keys[n2].intern();
                ++n2;
            }
        }
    }

    public static class BsonException
    extends RuntimeException {
        private static final String format(String string, BsonElement bsonElement) {
            if (bsonElement != null) {
                try {
                    return string + " -> " + bsonElement.obj.toString(2);
                }
                catch (JSONException jSONException) {}
            }
            return string;
        }

        public BsonException(Throwable throwable) {
            super(throwable);
        }

        public BsonException(String string, BsonElement bsonElement) {
            super(BsonException.format(string, bsonElement));
        }

        public BsonException(String string, BsonElement bsonElement, Throwable throwable) {
            super(BsonException.format(string, bsonElement), throwable);
        }
    }

    public static class BsonTypeResolver
    implements ValueDocDecoder.ITypeResolver {
        public BModule loadModule(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, String string2, String string3) {
            try {
                NModule nModule = Nre.moduleManager.loadModule(string2);
                return nModule.bmodule();
            }
            catch (ModuleException moduleException) {
                throw valueDocDecoder.err("Cannot load module '" + string3 + '\'', (Throwable)moduleException);
            }
            catch (Exception exception) {
                throw valueDocDecoder.err("Invalid Type '" + string3 + '\'');
            }
        }

        public BValue newInstance(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, Property property, String string2) {
            if (string2 == null) {
                if (property != null) {
                    return property.getDefaultValue();
                }
                valueDocDecoder.warningAndSkip("Missing frozen property: " + string);
                return null;
            }
            try {
                return (BValue)Sys.getType((String)string2).getInstance();
            }
            catch (TypeNotFoundException typeNotFoundException) {
                valueDocDecoder.warningAndSkip("Type \"" + typeNotFoundException.getMessage() + "\" not found: " + string);
                return null;
            }
            catch (Throwable throwable) {
                throw valueDocDecoder.err("Cannot instantiate type '" + string2 + '\'', throwable);
            }
        }
    }
}

