/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.json.BoxWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.nav.NavFileDecoder;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.json.JSONException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSysChannel
extends BBoxChannel {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$box$BSysChannel;

    public final Type getType() {
        return TYPE;
    }

    public final String getChannelName() {
        return "sys";
    }

    public final boolean service(String string, Object object, BoxWriter boxWriter, Context context) throws Exception {
        boolean bl = false;
        if (string == "props") {
            this.props(boxWriter, context);
            bl = true;
        } else if (string == "lex") {
            this.lex(object.toString(), boxWriter, context);
            bl = true;
        } else if (string == "navFile") {
            this.generateJsonNavFile(boxWriter, context);
            bl = true;
        } else if (string == "error") {
            this.clientError(object.toString(), context);
            boxWriter.value(null);
            bl = true;
        } else if (string == "hello") {
            boxWriter.value("world");
            bl = true;
        }
        return bl;
    }

    private final void props(BoxWriter boxWriter, Context context) throws Exception {
        boxWriter.object();
        boxWriter.key("userName").value((Object)context.getUser().getUsername());
        boxWriter.key("lang").value((Object)context.getLanguage());
        boxWriter.key("regLastBuildTime").value((Object)Sys.getRegistry().getLastBuildTime().encodeToString());
        boxWriter.key("enableWebStorage").value(this.getBoxService().getEnableWebStorage());
        boxWriter.key("userHome").value((Object)(context instanceof BBoxService.BoxContext ? ((BBoxService.BoxContext)context).getHomePage() : context.getUser().getHomePage()));
        boxWriter.key("timeFormat").value((Object)BSysChannel.getTimeFormat(context));
        boxWriter.key("logClientErrors").value(this.getBoxService().getLogClientErrors());
        boxWriter.endObject();
    }

    private final void lex(String string, BoxWriter boxWriter, Context context) throws Exception {
        Lexicon lexicon = Lexicon.make((String)string, (Context)context);
        Properties properties = lexicon.getModuleProperties();
        Properties properties2 = lexicon.getLanguageProperties();
        if ((properties == null || properties.isEmpty()) && (properties2 == null || properties2.isEmpty())) {
            throw new Exception("No Lexicon entries detected for module: " + string);
        }
        Properties properties3 = new Properties();
        if (properties != null) {
            properties3.putAll((Map<?, ?>)properties);
        }
        if (properties2 != null) {
            properties3.putAll((Map<?, ?>)properties2);
        }
        boxWriter.object();
        Iterator<Map.Entry<Object, Object>> iterator = properties3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            boxWriter.key((String)entry.getKey()).value(entry.getValue());
        }
        boxWriter.endObject();
    }

    private final void clientError(String string, Context context) {
        BBoxService bBoxService = this.getBoxService();
        if (bBoxService.getLogClientErrors()) {
            BBoxService.log.error(BBoxService.makeLogMsg("Client", context), (Throwable)new BoxClientException(string));
            if (bBoxService.hasListeners()) {
                bBoxService.notifyListeners(context, BBoxRecordType.error, string);
            }
        }
    }

    private final void generateJsonNavFile(BoxWriter boxWriter, Context context) throws Exception {
        BOrd bOrd = context.getUser().getNavFile();
        if (bOrd.isNull()) {
            boxWriter.value(null);
            return;
        }
        BIFile bIFile = (BIFile)bOrd.get((BObject)this);
        BNavFileSpace bNavFileSpace = new NavFileDecoder(bIFile).decodeDocument();
        BNavFileNode bNavFileNode = bNavFileSpace.getRootNode();
        this.encodeNavNodeToJson((BINavNode)bNavFileNode, boxWriter, context);
    }

    private final void encodeNavNodeToJson(BINavNode bINavNode, BoxWriter boxWriter, Context context) throws JSONException {
        boxWriter.object();
        boxWriter.key("n").value((Object)bINavNode.getNavName());
        boxWriter.key("d").value((Object)bINavNode.getNavDisplayName(context));
        boxWriter.key("e").value((Object)bINavNode.getNavDescription(context));
        boxWriter.key("o").value((Object)bINavNode.getNavOrd());
        boxWriter.key("i").value((Object)bINavNode.getNavIcon());
        if (bINavNode.hasNavChildren()) {
            BINavNode[] bINavNodeArray = bINavNode.getNavChildren();
            boxWriter.key("k").array();
            int n = 0;
            while (n < bINavNodeArray.length) {
                this.encodeNavNodeToJson(bINavNodeArray[n], boxWriter, context);
                ++n;
            }
            boxWriter.endArray();
        }
        boxWriter.endObject();
    }

    private static final String getTimeFormat(Context context) {
        String string = null;
        BObject bObject = context.getFacet("timeFormat");
        if (bObject != null) {
            string = bObject.toString();
        }
        if (string == null || string.length() == 0) {
            string = Lexicon.make((BModule)Sys.getBajaModule(), (Context)context).get("timeFormat");
        }
        if (string == null || string.length() == 0) {
            string = "DD-MMM-YY h:mm:ss a z";
        }
        return string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$box$BSysChannel;
        if (clazz == null) {
            clazz = class$com$tridium$box$BSysChannel = BSysChannel.class("[Lcom.tridium.box.BSysChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    private static final class BoxClientException
    extends Exception {
        private String err;

        public final void printStackTrace(PrintWriter printWriter) {
            printWriter.print(this.err);
        }

        private BoxClientException(String string) {
            this.err = string;
        }
    }
}

