/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxChannel;
import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.BServerSession;
import com.tridium.box.json.BoxWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BServerSessionChannel
extends BBoxChannel {
    public static final Type TYPE;
    private static final String serverSessionIdKey = "serverSessionId";
    private static final Object monitor;
    static /* synthetic */ Class class$com$tridium$box$BServerSessionChannel;

    public final Type getType() {
        return TYPE;
    }

    public final String getChannelName() {
        return "ssession";
    }

    public final boolean service(String string, Object object, BoxWriter boxWriter, Context context) throws Exception {
        boolean bl = false;
        if (string == "make") {
            this.makeServerSession(boxWriter, context);
            bl = true;
        } else if (string == "del") {
            this.deleteServerSession((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "pollchgs") {
            this.pollChanges((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "makessc") {
            this.makeServerSessionHandler((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "removessc") {
            this.removeServerSessionHandler((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "callssc") {
            this.serverSessionHandlerCall((JSONObject)object, boxWriter, context);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void makeServerSession(BoxWriter boxWriter, Context context) throws Exception {
        Property property;
        Object object;
        BServerSession bServerSession = new BServerSession();
        bServerSession.setUserName(context.getUser().getName());
        Object object2 = monitor;
        synchronized (object2) {
            object = this.getBoxService();
            int n = ((BBoxService)((Object)object)).getSessionLimit();
            if (n > -1 && ((BBoxService)((Object)object)).getSessionCount() >= n) {
                throw new SessionLimitException(context, n);
            }
            property = this.add(this.makeName(), (BValue)bServerSession, 3);
        }
        if (context instanceof BBoxService.BoxContext) {
            object = (BBoxService.BoxContext)context;
            ((BBoxService.BoxContext)((Object)object)).put(serverSessionIdKey, property.getName());
        }
        if (((BBoxService)((Object)(object = this.getBoxService()))).hasListeners()) {
            ((BBoxService)((Object)object)).notifyListeners(context, BBoxRecordType.status, "Created Server Session: " + property.getName());
        }
        boxWriter.value(property.getName());
    }

    private final void deleteServerSession(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BServerSession bServerSession = this.getServerSession(jSONObject, context);
        BBoxService bBoxService = this.getBoxService();
        if (bBoxService.hasListeners()) {
            bBoxService.notifyListeners(context, BBoxRecordType.status, "Removed Server Session: " + bServerSession.getName());
        }
        this.remove((BComplex)bServerSession);
        boxWriter.value(null);
    }

    private final void pollChanges(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BServerSession bServerSession = this.getServerSession(jSONObject, context);
        bServerSession.pollChanges(boxWriter, context);
    }

    private final void makeServerSessionHandler(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BServerSession bServerSession = this.getServerSession(jSONObject, context);
        bServerSession.makeServerSessionHandler(jSONObject, boxWriter, context);
    }

    private final void removeServerSessionHandler(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BServerSession bServerSession = this.getServerSession(jSONObject, context);
        bServerSession.removeServerSessionHandler(jSONObject, context);
        boxWriter.value(null);
    }

    private final void serverSessionHandlerCall(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BServerSession bServerSession = this.getServerSession(jSONObject, context);
        bServerSession.service(jSONObject, boxWriter, context);
    }

    private final BServerSession getServerSession(JSONObject jSONObject, Context context) throws Exception {
        Object object;
        String string = null;
        if (!jSONObject.has("id") && context instanceof BBoxService.BoxContext) {
            object = (BBoxService.BoxContext)context;
            string = (String)object.get(serverSessionIdKey);
        } else {
            string = jSONObject.getString("id").toString();
        }
        if (string == null) {
            throw new Exception("Could not find Server Session Id");
        }
        object = (BServerSession)this.get(string);
        if (object == null) {
            throw new Exception("Could not find Server Session: " + string);
        }
        if (!((BServerSession)((Object)object)).getUserName().equals(context.getUser().getName())) {
            throw new Exception("Security Exception: cannot access Server Session: " + string);
        }
        return object;
    }

    private final String makeName() {
        String string = null;
        int n = (int)System.currentTimeMillis();
        if (n < 0) {
            n = -n;
        }
        while (this.get(string = "serverSession" + n) != null) {
            ++n;
        }
        return string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$box$BServerSessionChannel;
        if (clazz == null) {
            clazz = class$com$tridium$box$BServerSessionChannel = BServerSessionChannel.class("[Lcom.tridium.box.BServerSessionChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        monitor = new Object();
    }

    static final class SessionLimitException
    extends BBoxService.BoxCommsFailed {
        final String getBsonErrorType() {
            return "BoxSessionLimitError";
        }

        private SessionLimitException(Context context, int n) {
            super(Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("service.exceededSessionLimit", new Object[]{String.valueOf(n)}));
        }
    }
}

