/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BBoxRecordType;
import com.tridium.box.BBoxService;
import com.tridium.box.BServerSessionChannel;
import com.tridium.box.BServerSessionHandler;
import com.tridium.box.json.BoxWriter;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BServerSession
extends BComponent {
    public static final Property userName = BServerSession.newProperty((int)65, (String)"", null);
    public static final Property created = BServerSession.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property lastPollChanges = BServerSession.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Action renew = BServerSession.newAction((int)20, null);
    public static final Action expire = BServerSession.newAction((int)20, null);
    public static final Type TYPE;
    private static final Log log;
    private static final BRelTime serverSessionExpiryTime;
    private Clock.Ticket expireTicket;
    static /* synthetic */ Class class$com$tridium$box$BServerSession;
    static /* synthetic */ Class class$com$tridium$box$BServerSessionHandler;

    public final String getUserName() {
        return this.getString(userName);
    }

    public final void setUserName(String string) {
        this.setString(userName, string, null);
    }

    public final BAbsTime getCreated() {
        return (BAbsTime)this.get(created);
    }

    public final void setCreated(BAbsTime bAbsTime) {
        this.set(created, (BValue)bAbsTime, null);
    }

    public final BAbsTime getLastPollChanges() {
        return (BAbsTime)this.get(lastPollChanges);
    }

    public final void setLastPollChanges(BAbsTime bAbsTime) {
        this.set(lastPollChanges, (BValue)bAbsTime, null);
    }

    public final void renew() {
        this.invoke(renew, null, null);
    }

    public final void expire() {
        this.invoke(expire, null, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BServerSessionChannel;
    }

    public final void started() throws Exception {
        this.getBoxService().incrementSessionCount();
        this.setCreated(BAbsTime.now());
        this.renew();
        if (log.isTraceOn()) {
            log.trace("Server Session Started: " + this.toPathString());
        }
    }

    public final void stopped() throws Exception {
        this.getBoxService().decrementSessionCount();
    }

    public final boolean isNavChild() {
        return false;
    }

    public final void pollChanges(BoxWriter boxWriter, Context context) throws Exception {
        Class clazz;
        this.setLastPollChanges(BAbsTime.now());
        this.renew();
        if (log.isTraceOn()) {
            log.trace("Server Session Poll Changes: " + this.toPathString());
        }
        if ((clazz = class$com$tridium$box$BServerSessionHandler) == null) {
            clazz = class$com$tridium$box$BServerSessionHandler = BServerSession.class("[Lcom.tridium.box.BServerSessionHandler;", false);
        }
        BServerSessionHandler[] bServerSessionHandlerArray = (BServerSessionHandler[])this.getChildren(clazz);
        boxWriter.array();
        int n = 0;
        while (n < bServerSessionHandlerArray.length) {
            boxWriter.object();
            boxWriter.key("scid").value((Object)SlotPath.unescape((String)bServerSessionHandlerArray[n].getName()));
            boxWriter.key("evs");
            bServerSessionHandlerArray[n].detachEvents(boxWriter, context);
            boxWriter.endObject();
            ++n;
        }
        boxWriter.endArray();
    }

    public final void makeServerSessionHandler(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        String string = SlotPath.escape((String)jSONObject.getString("scid"));
        Type type = Sys.getType((String)jSONObject.getString("scts"));
        Object object = jSONObject.get("scarg");
        BServerSessionHandler bServerSessionHandler = (BServerSessionHandler)type.getInstance();
        Property property = this.add(string, (BValue)bServerSessionHandler, 3);
        Object object2 = null;
        try {
            object2 = bServerSessionHandler.init(object, context);
        }
        catch (Exception exception) {
            this.remove(property);
            throw exception;
        }
        boxWriter.value(object2);
    }

    public final void removeServerSessionHandler(JSONObject jSONObject, Context context) throws Exception {
        String string = SlotPath.escape((String)jSONObject.getString("scid"));
        this.remove(string);
    }

    public final void service(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BServerSessionHandler bServerSessionHandler;
        String string = SlotPath.escape((String)jSONObject.getString("scid"));
        String string2 = jSONObject.getString("sck").intern();
        Object object = null;
        if (jSONObject.has("scarg")) {
            object = jSONObject.get("scarg");
        }
        if ((bServerSessionHandler = (BServerSessionHandler)this.get(string)) == null) {
            throw new Exception("Could not find Server Session Handler: " + string);
        }
        boolean bl = bServerSessionHandler.service(string2, object, boxWriter, context);
        if (!bl) {
            throw new Exception("Unsupported Key: " + string2 + " for Server Session Handler: " + string);
        }
    }

    public final void doRenew() {
        this.expireTicket.cancel();
        if (this.isRunning()) {
            this.expireTicket = Clock.schedule((BComponent)this, (BRelTime)serverSessionExpiryTime, (Action)expire, null);
        }
    }

    public final void doExpire() {
        BBoxService bBoxService;
        if (log.isTraceOn()) {
            log.trace("Server Session Expired: " + this.toPathString());
        }
        if ((bBoxService = this.getBoxService()).hasListeners()) {
            bBoxService.notifyListeners((Context)BFacets.DEFAULT, BBoxRecordType.status, "Server Session Expired: " + this.toPathString());
        }
        this.expireTicket.cancel();
        ((BComponent)this.getParent()).remove((BComplex)this);
    }

    private final BBoxService getBoxService() {
        return ((BServerSessionChannel)this.getParent()).getBoxService();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.expireTicket = Clock.expiredTicket;
    }

    public BServerSession() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$box$BServerSession;
        if (clazz == null) {
            clazz = class$com$tridium$box$BServerSession = BServerSession.class("[Lcom.tridium.box.BServerSession;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"box.serverSession");
        serverSessionExpiryTime = BRelTime.make((long)60000L);
    }
}

