/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.box;

import com.tridium.box.BServerSessionHandler;
import com.tridium.box.json.AllPermissionsContext;
import com.tridium.box.json.BlackListedTypes;
import com.tridium.box.json.BoxString;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.baja.agent.AgentFilter;
import javax.baja.box.BIServerSideCallHandler;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddOp;
import javax.baja.sync.ProxyBroker;
import javax.baja.sync.RenameOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncDecoder;
import javax.baja.sync.SyncEncoder;
import javax.baja.sync.SyncOp;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BComponentSpaceSessionHandler
extends BServerSessionHandler {
    public static final Property spaceOrd = BComponentSpaceSessionHandler.newProperty((int)1, (BValue)BOrd.NULL, null);
    public static final Type TYPE;
    private static final Log log;
    private BComponentSpace space;
    private ProxyBroker broker;
    static /* synthetic */ Class class$com$tridium$box$BComponentSpaceSessionHandler;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;
    static /* synthetic */ Class class$javax$baja$sys$Context;
    static /* synthetic */ Class class$javax$baja$sys$BValue;

    public final BOrd getSpaceOrd() {
        return (BOrd)this.get(spaceOrd);
    }

    public final void setSpaceOrd(BOrd bOrd) {
        this.set(spaceOrd, (BValue)bOrd, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final Object init(Object object, Context context) {
        BOrd bOrd = BOrd.make((String)object.toString());
        this.space = (BComponentSpace)bOrd.get(null, context);
        context.getUser().check((BIProtected)this.space, BPermissions.operatorRead);
        this.setSpaceOrd(bOrd);
        this.broker = new ProxyBroker(this.space);
        if (this.isTraceOn()) {
            this.trace("ComponentSpace Server Session Broker Started");
        }
        this.broker.start();
        return null;
    }

    public final void detachEvents(BoxWriter boxWriter, Context context) throws Exception {
        this.syncFromMaster(boxWriter, context);
    }

    public final boolean service(String string, Object object, BoxWriter boxWriter, Context context) throws Exception {
        boolean bl = false;
        if (string == "syncTo") {
            this.syncToMaster((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "sub") {
            this.subscribe((JSONArray)object, boxWriter, context);
            bl = true;
        } else if (string == "unsub") {
            this.unsubscribe((JSONArray)object, boxWriter, context);
            bl = true;
        } else if (string == "loadSlots") {
            this.loadSlots((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "loadSlotPath") {
            this.loadSlotPath((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "loadRoot") {
            this.loadRoot(boxWriter, context);
            bl = true;
        } else if (string == "handleToPath") {
            this.handleToPath((String)object, boxWriter, context);
            bl = true;
        } else if (string == "serviceToPath") {
            this.serviceToPath((String)object, boxWriter, context);
            bl = true;
        } else if (string == "invokeAction") {
            this.invokeAction((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "serverSideCall") {
            this.serverSideCall((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "getActionParameterDefault") {
            this.getActionParameterDefault((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "makeLink") {
            this.makeLink((JSONObject)object, boxWriter, context);
            bl = true;
        } else if (string == "navChildren") {
            this.getNavChildren((String)object, boxWriter, context);
            bl = true;
        }
        return bl;
    }

    public final void stopped() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    private final void subscribe(JSONArray jSONArray, BoxWriter boxWriter, Context context) throws Exception {
        OrdTarget ordTarget;
        if (this.isTraceOn()) {
            this.trace("Subscribe : " + jSONArray.join(","));
        }
        JSONArray jSONArray2 = new JSONArray();
        Class clazz = class$javax$baja$sys$BComponent;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BComponent = BComponentSpaceSessionHandler.class("[Ljavax.baja.sys.BComponent;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < jSONArray.length()) {
            ordTarget = BOrd.make((String)jSONArray.getString(n)).resolve((BObject)this.space);
            BComponent bComponent = ordTarget.getComponent();
            if (bComponent != null) {
                bComponent.loadSlots();
                BUser bUser = context.getUser();
                bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
                array.add((Object)bComponent);
            }
            ++n;
        }
        n = 0;
        while (n < array.size()) {
            ordTarget = (BComponent)array.get(n);
            this.broker.subscribeOp((BComponent)ordTarget, 0);
            jSONArray2.put(ordTarget.getHandle());
            ++n;
        }
        boxWriter.object();
        boxWriter.key("e");
        this.detachEvents(boxWriter, context);
        boxWriter.key("h").value((Object)jSONArray2);
        boxWriter.endObject();
    }

    private final void unsubscribe(JSONArray jSONArray, BoxWriter boxWriter, Context context) throws Exception {
        if (this.isTraceOn()) {
            this.trace("Unsubscribe: " + jSONArray.join(","));
        }
        int n = 0;
        while (n < jSONArray.length()) {
            OrdTarget ordTarget = BOrd.make((String)jSONArray.getString(n)).resolve((BObject)this.space);
            BComponent bComponent = ordTarget.getComponent();
            if (bComponent != null) {
                this.broker.unsubscribe(bComponent);
            }
            ++n;
        }
        boxWriter.value(null);
    }

    private final void loadSlots(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        OrdTarget ordTarget = BOrd.make((String)jSONObject.getString("o")).resolve((BObject)this.space, context);
        BComponent bComponent = ordTarget.getComponent();
        if (bComponent != null) {
            BUser bUser = context.getUser();
            bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
            int n = jSONObject.getInt("d");
            if (this.isTraceOn()) {
                this.trace("Load: " + bComponent.toPathString() + " depth: " + n);
            }
            this.broker.loadOp(bComponent, n);
        }
        boxWriter.value(null);
    }

    private final void loadSlotPath(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        JSONArray jSONArray = jSONObject.getJSONArray("spi");
        OrdTarget ordTarget = BOrd.make((String)jSONObject.getString("bo")).resolve((BObject)this.space, context);
        BObject bObject = ordTarget.get();
        if (this.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Load Slot Path: ");
            stringBuffer.append(jSONArray.join(","));
            stringBuffer.append("\nBase Ord: ").append(jSONObject.getString("bo"));
            this.trace(stringBuffer.toString());
        }
        boxWriter.array();
        int n = 0;
        while (n < jSONArray.length()) {
            JSONObject jSONObject2 = (JSONObject)jSONArray.get(n);
            BObject bObject2 = BOrd.make((String)jSONObject2.getString("o")).get(bObject, context);
            if (bObject2.isComponent()) {
                BComponent bComponent = bObject2.asComponent();
                bComponent.loadSlots();
                BUser bUser = context.getUser();
                bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
                String string = jSONObject2.getString("sn");
                Slot slot = bComponent.getSlot(string);
                if (slot == null) {
                    throw new Exception("Slot doesn't exist: " + string + " at " + bComponent.getNavOrd());
                }
                if (slot.isProperty()) {
                    BFacets bFacets;
                    Object object;
                    Property property = slot.asProperty();
                    BValue bValue = bComponent.get(property);
                    if (bValue instanceof BComponent) {
                        object = (BComponent)bValue;
                        object.loadSlots();
                        bUser.check((BIProtected)object, BPermissions.operatorRead);
                    }
                    boxWriter.object();
                    boxWriter.key("h").value(bComponent.getHandle());
                    object = new BsonSyncEncoder(new BsonEncoderPlugin(boxWriter), context);
                    boxWriter.key("n").value((Object)property.getName());
                    boxWriter.key("dn").value((Object)BsonEncoderPlugin.getSlotDisplayName((BComplex)bComponent, (Slot)property, context));
                    boxWriter.key("d").value((Object)BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)object, (BComplex)bComponent, property, context));
                    int n2 = bComponent.getFlags((Slot)property);
                    if (n2 > 0) {
                        boxWriter.key("f").value((Object)Flags.encodeToString((int)n2));
                    }
                    if (!(bFacets = bComponent.getSlotFacets((Slot)property)).isNull()) {
                        boxWriter.key("x").value((Object)bFacets.encodeToString());
                    }
                    boxWriter.key("v");
                    object.encode(null, bValue, -1);
                    object.flush();
                    boxWriter.endObject();
                }
            }
            ++n;
        }
        boxWriter.endArray();
    }

    private final void loadRoot(BoxWriter boxWriter, Context context) throws Exception {
        if (this.isTraceOn()) {
            this.trace("Load Root");
        }
        BComponent bComponent = this.space.getRootComponent();
        BUser bUser = context.getUser();
        bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
        boxWriter.object();
        boxWriter.key("h").value(bComponent.getHandle());
        boxWriter.key("t").value((Object)bComponent.getType().toString());
        boxWriter.endObject();
    }

    private final void handleToPath(String string, BoxWriter boxWriter, Context context) throws Exception {
        BComponent bComponent = (BComponent)BOrd.make((String)("h:" + string)).get((BObject)this.space, context);
        BUser bUser = context.getUser();
        bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
        boxWriter.value(bComponent.getSlotPath().getBody());
    }

    private final void serviceToPath(String string, BoxWriter boxWriter, Context context) throws Exception {
        BComponent bComponent = (BComponent)BOrd.make((String)("service:" + string)).get((BObject)this.space, context);
        BUser bUser = context.getUser();
        bUser.check((BIProtected)bComponent, BPermissions.operatorRead);
        boxWriter.value(bComponent.getSlotPath().getBody());
    }

    private final void invokeAction(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BComponent bComponent = this.space.findByHandle((Object)jSONObject.getString("h"));
        bComponent.loadSlots();
        Action action = bComponent.getAction(jSONObject.getString("a"));
        if (action == null) {
            throw new Exception("Could not find Action for Invocation: " + jSONObject.getString("a") + " on " + bComponent.getNavOrd());
        }
        JSONObject jSONObject2 = null;
        if (jSONObject.has("b")) {
            jSONObject2 = jSONObject.getJSONObject("b");
        }
        if (this.isTraceOn()) {
            if (jSONObject2 != null) {
                this.trace("Invoke Action arg: " + jSONObject2.toString(2));
            }
            this.trace("Invoking Action: " + bComponent.toPathString() + '.' + action.getName());
        }
        BValue bValue = null;
        if (jSONObject2 != null) {
            bValue = BComponentSpaceSessionHandler.unmarshal(jSONObject2);
        }
        BValue bValue2 = null;
        try {
            bValue2 = bComponent.invoke(action, bValue, context);
        }
        catch (Exception exception) {
            log.error("Invoking Action: " + bComponent.toPathString() + ' ' + action.getName(), (Throwable)exception);
            throw exception;
        }
        boxWriter.value(bValue2 == null ? null : new BoxString(BsonEncoderPlugin.marshal(bValue2, (Context)new AllPermissionsContext(context))));
    }

    private final void getActionParameterDefault(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BComponent bComponent = this.space.findByHandle((Object)jSONObject.getString("h"));
        bComponent.loadSlots();
        Action action = bComponent.getAction(jSONObject.getString("a"));
        if (action == null) {
            throw new Exception("Could not find Action for parameter default: " + jSONObject.getString("a") + " on " + bComponent.getNavOrd());
        }
        context.getUser().checkInvoke(bComponent, (Slot)action);
        if (this.isTraceOn()) {
            this.trace("getActionParameterDefault: " + bComponent.toPathString() + '.' + action.getName());
        }
        BValue bValue = null;
        try {
            bValue = bComponent.getActionParameterDefault(action);
        }
        catch (Exception exception) {
            log.error("getActionParameterDefault: " + bComponent.toPathString() + ' ' + action.getName(), (Throwable)exception);
            throw exception;
        }
        boxWriter.value(bValue == null ? null : new BoxString(BsonEncoderPlugin.marshal(bValue, (Context)new AllPermissionsContext(context))));
    }

    public final void serverSideCall(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        Object object;
        BComponent bComponent = this.space.findByHandle((Object)jSONObject.getString("h"));
        bComponent.loadSlots();
        String string = jSONObject.getString("ts");
        String string2 = jSONObject.getString("m");
        JSONObject jSONObject2 = null;
        if (jSONObject.has("b")) {
            jSONObject2 = jSONObject.getJSONObject("b");
        }
        if (this.isTraceOn()) {
            if (jSONObject2 != null) {
                this.trace("Server Side Call arg: " + jSONObject2.toString(2));
            }
            this.trace("Invoking Server Side Call: " + bComponent.toPathString() + " -> " + string + " - " + string2);
        }
        BValue bValue = null;
        if (jSONObject2 != null) {
            bValue = BComponentSpaceSessionHandler.unmarshal(jSONObject2);
        }
        BValue bValue2 = null;
        try {
            object = bComponent.getAgents(context).filter(AgentFilter.is((String)string)).getDefault();
            if (!object.getAgentType().is(BIServerSideCallHandler.TYPE)) {
                throw new Exception(string + " must implement BIServerSideCallHandler!");
            }
            BPermissions bPermissions = object.getRequiredPermissions();
            if (bPermissions == null || bPermissions == BPermissions.none) {
                bPermissions = BPermissions.operatorInvoke;
            }
            BUser bUser = context.getUser();
            bUser.check((BIProtected)bComponent, bPermissions);
            BIServerSideCallHandler bIServerSideCallHandler = (BIServerSideCallHandler)object.getAgentType().getInstance();
            boolean bl = false;
            Method[] methodArray = bIServerSideCallHandler.getClass().getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string2)) {
                    Class<?>[] classArray = methodArray[n].getParameterTypes();
                    if (classArray.length == 2) {
                        Class<?> clazz = classArray[0];
                        Class clazz2 = class$javax$baja$sys$BComponent;
                        if (clazz2 == null) {
                            clazz2 = BComponentSpaceSessionHandler.class("[Ljavax.baja.sys.BComponent;", false);
                        }
                        if (clazz.equals(clazz2)) {
                            Class<?> clazz3 = classArray[1];
                            Class clazz4 = class$javax$baja$sys$Context;
                            if (clazz4 == null) {
                                clazz4 = BComponentSpaceSessionHandler.class("[Ljavax.baja.sys.Context;", false);
                            }
                            if (clazz3.equals(clazz4)) {
                                bValue2 = (BValue)methodArray[n].invoke((Object)bIServerSideCallHandler, bComponent, context);
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (classArray.length == 3) {
                        Class<?> clazz = classArray[0];
                        Class clazz5 = class$javax$baja$sys$BComponent;
                        if (clazz5 == null) {
                            clazz5 = BComponentSpaceSessionHandler.class("[Ljavax.baja.sys.BComponent;", false);
                        }
                        if (clazz.equals(clazz5)) {
                            Class<?> clazz6 = classArray[1];
                            Class clazz7 = class$javax$baja$sys$BValue;
                            if (clazz7 == null) {
                                clazz7 = BComponentSpaceSessionHandler.class("[Ljavax.baja.sys.BValue;", false);
                            }
                            if (clazz6.equals(clazz7)) {
                                Class<?> clazz8 = classArray[2];
                                Class clazz9 = class$javax$baja$sys$Context;
                                if (clazz9 == null) {
                                    clazz9 = BComponentSpaceSessionHandler.class("[Ljavax.baja.sys.Context;", false);
                                }
                                if (clazz8.equals(clazz9)) {
                                    bValue2 = (BValue)methodArray[n].invoke((Object)bIServerSideCallHandler, bComponent, bValue, context);
                                    bl = true;
                                    break;
                                }
                            }
                        }
                    }
                }
                ++n;
            }
            if (!bl) {
                throw new UnsupportedOperationException("Could not find valid Server Side Call: " + string2);
            }
        }
        catch (Exception exception) {
            log.error("Invoking Server Side Call: " + bComponent.toPathString() + " -> " + string + " - " + string2, (Throwable)exception);
            throw exception;
        }
        object = bValue2 != null && bValue2.isComponent() && bValue2.asComponent().isMounted() ? context : new AllPermissionsContext(context);
        boxWriter.value(bValue2 == null ? null : new BoxString(BsonEncoderPlugin.marshal(bValue2, (Context)object)));
    }

    private final void makeLink(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        BComponent bComponent = this.space.findByHandle((Object)jSONObject.getString("s"));
        if (bComponent == null) {
            throw new Exception("Could not find Source: " + jSONObject.getString("s"));
        }
        bComponent.loadSlots();
        Slot slot = bComponent.getSlot(jSONObject.getString("ss"));
        if (slot == null) {
            throw new Exception("Could not find Source Slot: " + jSONObject.getString("ss"));
        }
        BComponent bComponent2 = this.space.findByHandle((Object)jSONObject.getString("t"));
        if (bComponent2 == null) {
            throw new Exception("Could not find Target: " + jSONObject.getString("t"));
        }
        bComponent2.loadSlots();
        Slot slot2 = bComponent2.getSlot(jSONObject.getString("ts"));
        if (slot2 == null) {
            throw new Exception("Could not find Target Slot: " + jSONObject.getString("ts"));
        }
        BLink bLink = bComponent2.makeLink(bComponent, slot, slot2, context);
        boxWriter.value(new BoxString(BsonEncoderPlugin.marshal((BValue)bLink, (Context)new AllPermissionsContext(context))));
    }

    public final void getNavChildren(String string, BoxWriter boxWriter, Context context) throws Exception {
        BComponent bComponent = this.space.findByHandle((Object)string);
        if (bComponent == null) {
            throw new Exception("Could not find Component: " + string);
        }
        context.getUser().check((BIProtected)bComponent, BPermissions.operatorRead);
        BINavNode[] bINavNodeArray = bComponent.getNavChildren();
        boxWriter.array();
        int n = 0;
        while (n < bINavNodeArray.length) {
            boolean bl = false;
            if (bINavNodeArray[n] instanceof BIProtected) {
                if (context.getUser().getPermissionsFor((BIProtected)bINavNodeArray[n]).hasOperatorRead()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                boxWriter.value(bINavNodeArray[n].getNavOrd());
            }
            ++n;
        }
        boxWriter.endArray();
    }

    public final void syncFromMaster(BoxWriter boxWriter, Context context) throws Exception {
        SyncBuffer syncBuffer = this.broker.detachBuffer();
        BsonSyncEncoder bsonSyncEncoder = new BsonSyncEncoder(new BsonEncoderPlugin(boxWriter), context);
        syncBuffer.encode((SyncEncoder)bsonSyncEncoder);
        bsonSyncEncoder.flush();
        if (this.isTraceOn()) {
            this.trace("syncFromMaster");
        }
    }

    private final void syncToMaster(JSONObject jSONObject, BoxWriter boxWriter, Context context) throws Exception {
        if (this.isTraceOn()) {
            this.trace("syncToMaster: " + jSONObject.toString(2));
        }
        BsonSyncDecoder bsonSyncDecoder = new BsonSyncDecoder(new BsonDecoderPlugin(jSONObject));
        BsonSyncBuffer bsonSyncBuffer = new BsonSyncBuffer(this.space, false);
        bsonSyncBuffer.decode(bsonSyncDecoder);
        bsonSyncBuffer.commit(context);
        boxWriter.array();
        int n = 0;
        while (n < bsonSyncBuffer.commitOps.length) {
            String string;
            SyncOp syncOp = bsonSyncBuffer.commitOps[n];
            boxWriter.object();
            boxWriter.key("id").value((Object)String.valueOf((char)syncOp.getId()));
            if (syncOp instanceof AddOp && (string = ((AddOp)syncOp).getNewSlotName()) != null) {
                boxWriter.key("nn").value((Object)string);
            }
            boxWriter.endObject();
            ++n;
        }
        boxWriter.endArray();
    }

    private static final String getDisplay(ValueDocEncoder valueDocEncoder, BComplex bComplex, Property property, Context context) {
        BValue bValue = bComplex.get(property);
        if (valueDocEncoder.isTypeBlackListed(bValue.getType())) {
            return "";
        }
        Context context2 = ValueDocEncoder.getMergedContext((BComplex)bComplex, (Slot)property, (Context)context);
        return bValue.toString(context2);
    }

    private static final BValue unmarshal(JSONObject jSONObject) throws Exception {
        BsonDecoderPlugin bsonDecoderPlugin = new BsonDecoderPlugin(jSONObject);
        BsonValueDecoder bsonValueDecoder = new BsonValueDecoder(bsonDecoderPlugin);
        bsonValueDecoder.next();
        return bsonValueDecoder.decode();
    }

    private final boolean isTraceOn() {
        return log.isTraceOn();
    }

    private final void trace(String string) {
        log.trace(this.space.getNavOrd().toString() + " -> " + string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$box$BComponentSpaceSessionHandler;
        if (clazz == null) {
            clazz = class$com$tridium$box$BComponentSpaceSessionHandler = BComponentSpaceSessionHandler.class("[Lcom.tridium.box.BComponentSpaceSessionHandler;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"box.compSpaceHandler");
    }

    private static final class BsonSyncEncoder
    extends SyncEncoder {
        protected final void encodingSlot(BComplex bComplex, Slot slot) throws IOException {
            BsonEncoderPlugin.encodingSlotBson((ValueDocEncoder)this, bComplex, slot);
        }

        protected final void encodingValue(BValue bValue, Context context) throws IOException {
            BsonEncoderPlugin.encodingValueBson((ValueDocEncoder)this, bValue, context);
        }

        protected final void encodingSyncOp(SyncOp syncOp) throws IOException {
            BComponent bComponent = syncOp.getComponent();
            if (bComponent != null) {
                this.plugin.attr("cd", bComponent.toString(this.getContext()));
                this.plugin.attr("cdn", bComponent.getDisplayName(this.getContext()));
                if (syncOp instanceof SetOp) {
                    SetOp setOp = (SetOp)syncOp;
                    Property property = bComponent.getProperty(setOp.getSlotName());
                    if (property == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)bComponent, (Slot)property, this.getContext()));
                } else if (syncOp instanceof AddOp) {
                    AddOp addOp = (AddOp)syncOp;
                    Property property = bComponent.getProperty(addOp.getSlotName());
                    if (property == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)bComponent, (Slot)property, this.getContext()));
                } else if (syncOp instanceof RenameOp) {
                    RenameOp renameOp = (RenameOp)syncOp;
                    Property property = bComponent.getProperty(renameOp.getNewName());
                    if (property == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)bComponent, (Slot)property, this.getContext()));
                    this.plugin.attr("d", BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)this, (BComplex)bComponent, property, this.getContext()));
                } else if (syncOp instanceof SetFacetsOp) {
                    SetFacetsOp setFacetsOp = (SetFacetsOp)syncOp;
                    Slot slot = bComponent.getSlot(setFacetsOp.getSlotName());
                    if (slot == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)bComponent, (Slot)slot.asProperty(), this.getContext()));
                    if (slot.isProperty()) {
                        this.plugin.attr("d", BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)this, (BComplex)bComponent, slot.asProperty(), this.getContext()));
                    }
                } else if (syncOp instanceof SetFlagsOp) {
                    SetFlagsOp setFlagsOp = (SetFlagsOp)syncOp;
                    Slot slot = bComponent.getSlot(setFlagsOp.getSlotName());
                    if (slot == null) {
                        return;
                    }
                    this.plugin.attr("dn", BsonEncoderPlugin.getSlotDisplayName((BComplex)bComponent, slot, this.getContext()));
                    if (slot.isProperty()) {
                        this.plugin.attr("d", BComponentSpaceSessionHandler.getDisplay((ValueDocEncoder)this, (BComplex)bComponent, slot.asProperty(), this.getContext()));
                    }
                }
            }
        }

        public final boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }

        public BsonSyncEncoder(ValueDocEncoder.IEncoderPlugin iEncoderPlugin, Context context) throws Exception {
            super(iEncoderPlugin, context);
        }
    }

    private static final class BsonSyncDecoder
    extends SyncDecoder {
        public final boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }

        private BsonSyncDecoder(ValueDocDecoder.IDecoderPlugin iDecoderPlugin) throws Exception {
            super(iDecoderPlugin);
        }
    }

    private static final class BsonSyncBuffer
    extends SyncBuffer {
        private SyncOp[] commitOps;

        protected final SyncOp[] startCommit(SyncOp[] syncOpArray, Context context) {
            this.commitOps = super.startCommit(syncOpArray, context);
            return this.commitOps;
        }

        private BsonSyncBuffer(BComponentSpace bComponentSpace, boolean bl) {
            super(bComponentSpace, bl);
        }
    }

    private static final class BsonValueDecoder
    extends ValueDocDecoder {
        public final boolean isTypeBlackListed(Type type) {
            return BlackListedTypes.isTypeBlackListed(type);
        }

        public BsonValueDecoder(ValueDocDecoder.IDecoderPlugin iDecoderPlugin) throws Exception {
            super(iDecoderPlugin);
        }
    }
}

