/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.batch;

import com.tridium.bql.BSelect;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.expression.BPath;
import com.tridium.program.ui.batch.BAddDialog;
import com.tridium.program.ui.batch.BBatchEditor;
import com.tridium.program.ui.batch.BBatchTable;
import com.tridium.program.ui.batch.BRemoveDialog;
import com.tridium.program.ui.batch.BRenameDialog;
import com.tridium.program.ui.batch.BSetDialog;
import com.tridium.program.ui.batch.BSetFlagsDialog;
import com.tridium.program.ui.batch.BatchCompiler;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import java.util.ArrayList;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;

public class BatchCommands {
    private static BModule module = Sys.getModuleForClass((Class)(class$com$tridium$program$ui$batch$BBatchEditor == null ? (class$com$tridium$program$ui$batch$BBatchEditor = BatchCommands.class$("com.tridium.program.ui.batch.BBatchEditor")) : class$com$tridium$program$ui$batch$BBatchEditor));
    private static Lexicon lex = Lexicon.make((String)"program");
    private BBatchEditor editor;
    private BBqlQueryBuilder builder;
    FindObjects findObjects;
    Clear clear;
    ClearAll clearAll;
    SelectColumns selectCols;
    Rename rename;
    SlotAdd slotAdd;
    SlotEdit slotEdit;
    SlotRename slotRename;
    SlotRemove slotRemove;
    SlotFlags slotFlags;
    Hyperlink hyperlink;
    static /* synthetic */ Class class$com$tridium$program$ui$batch$BBatchEditor;

    public BatchCommands(BBatchEditor bBatchEditor) {
        this.editor = bBatchEditor;
        this.findObjects = new FindObjects();
        this.clear = new Clear();
        this.clearAll = new ClearAll();
        this.selectCols = new SelectColumns();
        this.rename = new Rename();
        this.slotAdd = new SlotAdd();
        this.slotEdit = new SlotEdit();
        this.slotRename = new SlotRename();
        this.slotRemove = new SlotRemove();
        this.slotFlags = new SlotFlags();
        this.hyperlink = new Hyperlink();
    }

    public void updateCommands() {
        boolean bl = this.editor.table.getModel().getRowCount() > 0;
        boolean bl2 = this.editor.table.getSelection().getRows().length > 0;
        boolean bl3 = this.editor.table.getSelection().getRows().length == 1;
        this.clear.setEnabled(bl && bl2);
        this.clearAll.setEnabled(bl);
        this.selectCols.setEnabled(bl);
        this.rename.setEnabled(bl);
        this.slotAdd.setEnabled(bl);
        this.slotEdit.setEnabled(bl);
        this.slotRename.setEnabled(bl);
        this.slotRemove.setEnabled(bl);
        this.slotFlags.setEnabled(bl);
        this.hyperlink.setEnabled(bl && bl3);
    }

    public BMenu buildMenu() {
        BMenu bMenu = new BMenu(lex.getText("batchEditor"));
        bMenu.add(null, (Command)this.findObjects);
        bMenu.add(null, (Command)this.clear);
        bMenu.add(null, (Command)this.clearAll);
        bMenu.add(null, (Command)this.selectCols);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)new PasteCommand((BTransferWidget)this.editor.table));
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)this.rename);
        bMenu.add(null, (Command)this.slotAdd);
        bMenu.add(null, (Command)this.slotEdit);
        bMenu.add(null, (Command)this.slotRename);
        bMenu.add(null, (Command)this.slotRemove);
        bMenu.add(null, (Command)this.slotFlags);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, (Command)this.hyperlink);
        return bMenu;
    }

    static void lease(BComponent[] bComponentArray) {
        try {
            BComponent.lease((BComponent[])bComponentArray, (int)0, (long)60000L);
        }
        catch (Throwable throwable) {
            System.out.println("Error leasing Components...");
            throwable.printStackTrace();
            for (int i = 0; i < bComponentArray.length; ++i) {
                try {
                    bComponentArray[i].lease(0, 60000L);
                    continue;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Hyperlink
    extends BatchCommand {
        public Hyperlink() {
            super("hyperlink");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = ((BatchCommands)BatchCommands.this).editor.table.getSelection().getRows();
            BComponent bComponent = (BComponent)((BatchCommands)BatchCommands.this).editor.table.model.kids.get(nArray[0]);
            BOrd bOrd = BOrd.make((String)("station:|" + bComponent.getSlotPath()));
            BatchCommands.this.editor.getWbShell().hyperlink(bOrd);
            return null;
        }
    }

    class SlotFlags
    extends BatchCommand {
        public SlotFlags() {
            super("slotFlags");
        }

        public CommandArtifact doInvoke() {
            String string = BSetFlagsDialog.open(BatchCommands.this.editor);
            if (string != null) {
                try {
                    BatchCompiler batchCompiler = new BatchCompiler(BatchCommands.this.editor, string);
                    batchCompiler.compile();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BatchCommands.this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)exception);
                }
            }
            return null;
        }
    }

    class SlotRemove
    extends BatchCommand {
        public SlotRemove() {
            super("slotRemove");
        }

        public CommandArtifact doInvoke() {
            String string = BRemoveDialog.open(BatchCommands.this.editor);
            if (string != null) {
                try {
                    BatchCompiler batchCompiler = new BatchCompiler(BatchCommands.this.editor, string);
                    batchCompiler.compile();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BatchCommands.this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)exception);
                }
            }
            return null;
        }
    }

    class SlotRename
    extends BatchCommand {
        public SlotRename() {
            super("slotRename");
        }

        public CommandArtifact doInvoke() {
            String string = BRenameDialog.open(BatchCommands.this.editor, true);
            if (string != null) {
                try {
                    BatchCompiler batchCompiler = new BatchCompiler(BatchCommands.this.editor, string);
                    batchCompiler.compile();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BatchCommands.this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)exception);
                }
            }
            return null;
        }
    }

    class SlotEdit
    extends BatchCommand {
        public SlotEdit() {
            super("slotEdit");
        }

        public CommandArtifact doInvoke() {
            String string = BSetDialog.open(BatchCommands.this.editor);
            if (string != null) {
                try {
                    BatchCompiler batchCompiler = new BatchCompiler(BatchCommands.this.editor, string);
                    batchCompiler.compile();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BatchCommands.this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)exception);
                }
            }
            return null;
        }
    }

    class SlotAdd
    extends BatchCommand {
        public SlotAdd() {
            super("slotAdd");
        }

        public CommandArtifact doInvoke() {
            String string = BAddDialog.open(BatchCommands.this.editor);
            if (string != null) {
                try {
                    BatchCompiler batchCompiler = new BatchCompiler(BatchCommands.this.editor, string);
                    batchCompiler.compile();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BatchCommands.this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)exception);
                }
            }
            return null;
        }
    }

    class Rename
    extends BatchCommand {
        public Rename() {
            super("rename");
        }

        public CommandArtifact doInvoke() {
            String string = BRenameDialog.open(BatchCommands.this.editor, false);
            if (string != null) {
                try {
                    BatchCompiler batchCompiler = new BatchCompiler(BatchCommands.this.editor, string);
                    batchCompiler.compile();
                }
                catch (Exception exception) {
                    BDialog.error((BWidget)BatchCommands.this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)exception);
                }
            }
            return null;
        }
    }

    class SelectColumns
    extends BatchCommand {
        public SelectColumns() {
            super("selectColumns");
        }

        public CommandArtifact doInvoke() {
            int n;
            BBatchTable.Model model = ((BatchCommands)BatchCommands.this).editor.table.model;
            BCheckList bCheckList = new BCheckList();
            String[] stringArray = model.getAllColumns();
            for (n = 0; n < stringArray.length; ++n) {
                bCheckList.getModel().addItem((Object)stringArray[n]);
            }
            for (n = 1; n < model.cols.size(); ++n) {
                int n2 = bCheckList.indexOfItem(model.cols.get(n));
                if (n2 < 0) continue;
                bCheckList.getSelection().select(n2);
            }
            BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bCheckList, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
            bConstrainedPane.setMinWidth(300.0);
            bConstrainedPane.setMaxWidth(300.0);
            bConstrainedPane.setMinHeight(300.0);
            bConstrainedPane.setMaxHeight(400.0);
            if (1 == BDialog.open((BWidget)BatchCommands.this.editor, (String)lex.getText("batchEditor.commands.selectColumns.label"), (Object)bConstrainedPane, (int)3)) {
                String string = (String)((BatchCommands)BatchCommands.this).editor.table.model.cols.get(0);
                model.cols.clear();
                model.cols.add(string);
                int[] nArray = bCheckList.getSelection().getItems();
                for (int i = 0; i < nArray.length; ++i) {
                    model.cols.add(bCheckList.getItem(nArray[i]));
                }
                ((BatchCommands)BatchCommands.this).editor.table.sizeColumnsToFit();
                ((BatchCommands)BatchCommands.this).editor.table.relayout();
            }
            return null;
        }
    }

    class ClearAll
    extends BatchCommand {
        public ClearAll() {
            super("clearAll");
        }

        public CommandArtifact doInvoke() {
            while (!((BatchCommands)BatchCommands.this).editor.table.model.kids.isEmpty()) {
                ((BatchCommands)BatchCommands.this).editor.table.model.kids.remove(0);
            }
            BatchCommands.this.updateCommands();
            return null;
        }
    }

    class Clear
    extends BatchCommand {
        public Clear() {
            super("clear");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = ((BatchCommands)BatchCommands.this).editor.table.getSelection().getRows();
            ((BatchCommands)BatchCommands.this).editor.table.getSelection().deselectAll();
            for (int i = 0; i < nArray.length; ++i) {
                ((BatchCommands)BatchCommands.this).editor.table.getSelection().deselectAll();
                ((BatchCommands)BatchCommands.this).editor.table.model.kids.remove(nArray[i] - i);
            }
            BatchCommands.this.updateCommands();
            return null;
        }
    }

    class FindObjects
    extends BatchCommand {
        public FindObjects() {
            super("findObjects");
        }

        public CommandArtifact doInvoke() {
            BOrd bOrd;
            if (BatchCommands.this.builder == null) {
                BatchCommands.this.builder = new BBqlQueryBuilder((BObject)((BatchCommands)BatchCommands.this).editor.service, BOrd.NULL, false);
            }
            if ((bOrd = BatchCommands.this.builder.open((BWidget)BatchCommands.this.editor)) != null && !bOrd.isNull()) {
                OrdQuery[] ordQueryArray = bOrd.parse();
                SelectQuery selectQuery = (SelectQuery)ordQueryArray[ordQueryArray.length - 1];
                BSelect bSelect = selectQuery.getSelect();
                BPath bPath = new BPath("toPathString");
                if (bSelect.hasProjection() && bSelect.getProjection().isDistinct()) {
                    bSelect.select(Columns.distinctProjection().add(Columns.make((BExpression)bPath)));
                } else {
                    bSelect.select(Columns.projection((BProjectionColumn)Columns.make((BExpression)bPath)));
                }
                ordQueryArray[ordQueryArray.length - 1] = new SelectQuery(bSelect);
                bOrd = BOrd.make((OrdQuery[])ordQueryArray);
                BICollection bICollection = (BICollection)bOrd.resolve((BObject)((BatchCommands)BatchCommands.this).editor.service).get();
                BITable bITable = bICollection.toTable();
                ColumnList columnList = bITable.getColumns();
                ArrayList<BObject> arrayList = new ArrayList<BObject>();
                for (int i = 0; i < bITable.size(); ++i) {
                    BOrd bOrd2 = BOrd.make((String)("station:|slot:" + bITable.get(i, columnList.get(0))));
                    bOrd2 = BOrd.make((BOrd)BatchCommands.this.editor.getWbShell().getActiveOrd(), (BOrd)bOrd2).normalize();
                    BObject bObject = bOrd2.resolve().get();
                    if (!(bObject instanceof BComponent) || ((BatchCommands)BatchCommands.this).editor.table.model.kids.contains(bObject)) continue;
                    arrayList.add(bObject);
                    ((BatchCommands)BatchCommands.this).editor.table.model.kids.add(bObject);
                }
                BatchCommands.lease(arrayList.toArray(new BComponent[arrayList.size()]));
                ((BatchCommands)BatchCommands.this).editor.table.sizeColumnsToFit();
                ((BatchCommands)BatchCommands.this).editor.table.relayout();
                BatchCommands.this.updateCommands();
            }
            return null;
        }
    }

    abstract class BatchCommand
    extends Command {
        public BatchCommand(String string) {
            super((BWidget)BatchCommands.this.editor, module, "batchEditor.commands." + string);
        }
    }
}

