/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BProgramCode;
import com.tridium.program.ui.BProgramEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BModule;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

public class Imports
extends TableModel {
    static final int PREDEFINED = 0;
    static final int USER_DEFINED = 1;
    static final int BY_PROPERTY = 2;
    static Import[] predefined = new Import[]{new Import("java", "java.util", 0), new Import("baja", "javax.baja.sys", 0), new Import("baja", "javax.baja.status", 0), new Import("baja", "javax.baja.util", 0), new Import("program", "com.tridium.program", 0)};
    static UiLexicon lex = UiLexicon.bajaui;
    static String lexModule = lex.getText("programEditor.module");
    static String lexPackage = lex.getText("programEditor.package");
    static String lexDefinition = lex.getText("programEditor.definition");
    static BImage importIcon = BImage.make((String)"module://icons/x16/module.png");
    final BProgramEditor editor;
    BTable table;
    private ArrayList list = new ArrayList();
    private HashMap map = new HashMap();

    Imports(BProgramEditor bProgramEditor) {
        this.editor = bProgramEditor;
        this.table = new BTable((TableModel)this);
        this.table.setController((TableController)new Controller());
    }

    public Import[] getAll() {
        return this.list.toArray(new Import[this.list.size()]);
    }

    public String[] getDependencies() {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(13);
        hashtable.put("baja", "baja");
        hashtable.put("program", "program");
        for (int i = 0; i < this.list.size(); ++i) {
            object = (Import)this.list.get(i);
            if (((Import)object).moduleName.equals("java")) continue;
            hashtable.put(((Import)object).moduleName, ((Import)object).moduleName);
        }
        String[] stringArray = new String[hashtable.size()];
        object = hashtable.keys();
        int n = 0;
        while (object.hasMoreElements()) {
            stringArray[n] = (String)object.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void updateImports() {
        Object object;
        int n;
        ArrayList<Import> arrayList = new ArrayList<Import>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (n = 0; n < predefined.length; ++n) {
            arrayList.add(predefined[n]);
            hashMap.put(predefined[n], predefined[n]);
        }
        for (n = 0; n < this.list.size(); ++n) {
            object = (Import)this.list.get(n);
            if (((Import)object).definition != 1 || hashMap.get(object) != null) continue;
            arrayList.add((Import)object);
            hashMap.put(object, object);
        }
        SlotCursor slotCursor = this.editor.program.getProperties();
        while (slotCursor.next()) {
            if (!slotCursor.property().isDynamic()) continue;
            object = slotCursor.get().getClass();
            String string = TextUtil.getPackageName((Class)object);
            BModule bModule = Sys.getModuleForClass((Class)object);
            Import import_ = new Import(bModule.getModuleName(), string, 2);
            if (hashMap.get(import_) != null) continue;
            arrayList.add(import_);
            hashMap.put(import_, import_);
        }
        this.list = arrayList;
        this.map = hashMap;
        this.updateTable();
    }

    void add(Import import_) {
        Import import_2 = (Import)this.map.get(import_);
        if (import_2 != null) {
            if (import_2.definition > import_.definition) {
                import_2.definition = import_.definition;
            }
        } else {
            this.list.add(import_);
            this.map.put(import_, import_);
        }
        this.updateTable();
        this.editor.setModified();
    }

    void remove(Import import_) {
        this.list.remove(import_);
        this.map.remove(import_);
        this.updateTable();
        this.editor.setModified();
    }

    void removeSelection() {
        int n;
        int[] nArray = this.table.getSelection().getRows();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        boolean bl = false;
        Import[] importArray = this.getAll();
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            if (importArray[n2].definition != 1) continue;
            importArray[n2] = null;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.list.clear();
        this.map.clear();
        for (n = 0; n < importArray.length; ++n) {
            if (importArray[n] == null) continue;
            this.list.add(importArray[n]);
            this.map.put(importArray[n], importArray[n]);
        }
        this.updateTable();
        this.editor.setModified();
    }

    public void save(BProgramCode bProgramCode) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            stringArray = (String[])this.list.get(i);
            if (stringArray.definition != 1) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(stringArray.moduleName).append(':').append(stringArray.packageName);
        }
        bProgramCode.setUserDefinedImports(stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringArray = this.getDependencies();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append(';');
            }
            stringBuffer2.append(stringArray[i]);
        }
        bProgramCode.setDependencies(stringBuffer2.toString());
    }

    public void load(BProgramCode bProgramCode) {
        this.list.clear();
        this.map.clear();
        String string = bProgramCode.getUserDefinedImports();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.add(new Import(string3, string4, 1));
        }
        this.updateImports();
    }

    public int getRowCount() {
        return this.list.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return lexModule;
            }
            case 1: {
                return lexPackage;
            }
            case 2: {
                return lexDefinition;
            }
        }
        return "???";
    }

    public Object getValueAt(int n, int n2) {
        Import import_ = (Import)this.list.get(n);
        switch (n2) {
            case 0: {
                return import_.moduleName;
            }
            case 1: {
                return import_.packageName;
            }
            case 2: {
                return import_.definitionToString();
            }
        }
        return "???";
    }

    public BImage getRowIcon(int n) {
        return importIcon;
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public void sortByColumn(int n, boolean bl) {
        Object[] objectArray = this.list.toArray(new Import[this.list.size()]);
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = this.getValueAt(i, n).toString();
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray, (boolean)bl);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        this.list = arrayList;
    }

    static class Import {
        public final String moduleName;
        public final String packageName;
        public int definition;

        public Import(String string, String string2, int n) {
            this.moduleName = string;
            this.packageName = string2;
            this.definition = n;
        }

        public int hashCode() {
            return this.moduleName.hashCode() ^ this.packageName.hashCode();
        }

        public boolean equals(Object object) {
            Import import_ = (Import)object;
            return this.moduleName.equals(import_.moduleName) && this.packageName.equals(import_.packageName);
        }

        public String definitionToString() {
            switch (this.definition) {
                case 0: {
                    return "Predefined";
                }
                case 1: {
                    return "User Defined";
                }
                case 2: {
                    return "By Property";
                }
            }
            return "???";
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            this.popup(bMouseEvent);
        }

        public void backgroundPopup(BMouseEvent bMouseEvent) {
            this.popup(bMouseEvent);
        }

        public void popup(BMouseEvent bMouseEvent) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, Imports.this.editor.commands.importType);
            bMenu.add(null, Imports.this.editor.commands.importPackage);
            bMenu.add(null, Imports.this.editor.commands.removeImport);
            bMenu.open((BWidget)Imports.this.table, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }
}

