/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.nsh.NShell;
import com.tridium.program.BCode;
import com.tridium.program.BProgramService;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.DependencyInfo;
import javax.baja.sys.BBlob;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbEditor;

public class Compiler
implements BConsole.ExecCallback {
    BWidget owner;
    public String className;
    File temp;
    File java;
    File classFile;
    File[] innerClassFiles;
    BCode code;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public Compiler(BWidget bWidget) {
        this.owner = bWidget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String string, BCode bCode, String string2) throws Exception {
        this.className = string;
        this.temp = new File(Sys.getBajaHome(), "temp");
        this.java = new File(this.temp, string + ".java");
        this.classFile = new File(this.temp, string + ".class");
        this.innerClassFiles = null;
        this.code = bCode;
        if (!this.temp.exists()) {
            this.temp.mkdirs();
        }
        FileWriter fileWriter = new FileWriter(this.java);
        try {
            this.writeSource(fileWriter, string2);
        }
        finally {
            fileWriter.close();
        }
        String string3 = Compiler.getDevkitTargetEdition(this.owner, null);
        String string4 = File.separator;
        String string5 = File.pathSeparator;
        StringBuffer stringBuffer = new StringBuffer();
        String string6 = Sys.getBajaHome() + string4 + "lib" + string4 + "editions" + string4 + (string3.startsWith("javac.") ? string3.substring(6) : string3) + string4;
        File file = new File(string6);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(string6 + stringArray[i] + string5);
            }
        }
        File file2 = new File(Sys.getBajaHome(), "bin");
        String[] stringArray2 = file2.list(new JarFilenameFilter());
        String string7 = string5 + Sys.getBajaHome() + string4 + "bin" + string4;
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append(string7).append(stringArray2[i]).append(string5);
        }
        stringBuffer.append(Sys.getBajaHome() + string4 + "modules" + string4 + "baja.jar");
        String[] stringArray3 = this.parseDependencies(bCode);
        String string8 = string5 + Sys.getBajaHome() + string4 + "modules" + string4;
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i].equals("baja")) continue;
            stringBuffer.append(string8).append(stringArray3[i]).append(".jar");
        }
        String string9 = null;
        try {
            string9 = Compiler.getCompileJavaCommand(string3, stringBuffer.toString(), this.temp.toString(), this.java.toString());
        }
        catch (Exception exception) {
            System.out.println("Problem loading '" + string3 + "' command from devkit.properties.");
            exception.printStackTrace();
            string9 = "jikes +E -classpath \"" + stringBuffer + "\" \"" + this.java + "\"";
        }
        this.exec(string9);
    }

    protected String[] parseDependencies(BCode bCode) throws Exception {
        HashSet hashSet = new HashSet();
        String[] stringArray = bCode.parseDependencies();
        for (int i = 0; i < stringArray.length; ++i) {
            this.accumDependencies(hashSet, stringArray[i]);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    protected void accumDependencies(Set set, String string) throws Exception {
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        DependencyInfo[] dependencyInfoArray = Sys.getRegistry().getModule(string).getDependencies();
        for (int i = 0; i < dependencyInfoArray.length; ++i) {
            this.accumDependencies(set, dependencyInfoArray[i].getModuleName());
        }
    }

    public void writeSource(FileWriter fileWriter, String string) throws Exception {
        fileWriter.write(string);
    }

    public void exec(String string) throws Exception {
        if (this.owner != null) {
            this.openConsole().exec(string, (BConsole.ExecCallback)this);
            return;
        }
        NShell nShell = new NShell(System.out);
        nShell.exec(string);
        nShell.execWaitUntilDone();
        this.compileSuccess(null);
        this.cleanup();
    }

    public BConsole openConsole() {
        return ((BNiagaraWbShell)this.owner.getShell()).openConsole();
    }

    public void consoleExecDone(BConsole bConsole, int n) {
        try {
            if (n == 0) {
                this.compileSuccess(bConsole);
            } else {
                this.compileFailed(bConsole);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.cleanup();
    }

    public void compileSuccess(BConsole bConsole) throws Exception {
        byte[] byArray = new byte[(int)this.classFile.length()];
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFile)));
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        this.code.setClassName(this.className);
        this.code.setClassFile(BBlob.make((byte[])byArray));
        File[] fileArray = this.classFile.getParentFile().listFiles();
        this.code.clearInnerClassFiles();
        Array array = new Array(class$java$io$File == null ? (class$java$io$File = Compiler.class$("java.io.File")) : class$java$io$File);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().startsWith(this.className + '$')) continue;
            array.add((Object)fileArray[i]);
            String string = fileArray[i].getName();
            string = string.substring(0, string.length() - 6);
            byArray = new byte[(int)fileArray[i].length()];
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileArray[i])));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            this.code.addInnerClassFile(string, BBlob.make((byte[])byArray));
        }
        this.innerClassFiles = (File[])array.trim();
    }

    public void compileFailed(BConsole bConsole) throws Exception {
        bConsole.next();
    }

    public void cleanup() {
        this.classFile.delete();
        if (this.innerClassFiles != null) {
            for (int i = 0; i < this.innerClassFiles.length; ++i) {
                this.innerClassFiles[i].delete();
            }
        }
        this.java.delete();
    }

    public static String getDevkitTargetEdition(BWidget bWidget, String string) {
        try {
            if (bWidget instanceof BWbEditor) {
                BProgramService bProgramService = (BProgramService)BOrd.make((String)"service:program:ProgramService").resolve(((BWbEditor)bWidget).getCurrentValue()).get();
                bProgramService.lease();
                BValue bValue = bProgramService.get("devkitTargetEdition");
                if (bValue instanceof BString) {
                    return bValue.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string == null ? "javac.j2me" : string;
    }

    public static String getCompileJavaCommand(String string, String string2, String string3, String string4) throws Exception {
        int n;
        if (!string4.startsWith("\"")) {
            string4 = "\"" + string4;
        }
        if (!string4.endsWith("\"")) {
            string4 = string4 + "\"";
        }
        Class<?> clazz = Class.forName("com.tridium.build.Env");
        Method method = clazz.getMethod("initEnv", class$java$lang$String == null ? (class$java$lang$String = Compiler.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Compiler.class$("java.lang.String")) : class$java$lang$String);
        method.invoke(null, null, "jar");
        Object object = clazz.getField("props").get(null);
        clazz = Class.forName("com.tridium.build.MacroProperties");
        method = clazz.getMethod("copy", null);
        object = method.invoke(object, null);
        method = clazz.getMethod("put", class$java$lang$Object == null ? (class$java$lang$Object = Compiler.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = Compiler.class$("java.lang.Object")) : class$java$lang$Object);
        method.invoke(object, "javac.classpath", string2);
        method.invoke(object, "javac.out", string3);
        method.invoke(object, "javac.src", string4);
        Method method2 = clazz.getMethod("getProperty", class$java$lang$String == null ? (class$java$lang$String = Compiler.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Compiler.class$("java.lang.String")) : class$java$lang$String);
        if (((String)method2.invoke(object, "debug", "false")).equalsIgnoreCase("true")) {
            method.invoke(object, "javac.debug", "-g");
        } else {
            method.invoke(object, "javac.debug", "");
        }
        method = clazz.getMethod("resolve", class$java$lang$String == null ? (class$java$lang$String = Compiler.class$("java.lang.String")) : class$java$lang$String);
        String string5 = (String)method.invoke(object, string);
        if (!string5.endsWith(string4)) {
            n = string5.lastIndexOf(string4);
            string5 = n > -1 ? string5.substring(0, n) : string5 + " ";
            string5 = string5 + string4;
        }
        if (!string5.startsWith("\"")) {
            n = string5.indexOf(32);
            while (n >= 0) {
                String string6 = string5.substring(0, n);
                File file = new File(string6);
                if (file.exists() && !file.isDirectory()) {
                    string5 = "\"" + string6 + "\"" + string5.substring(n);
                    break;
                }
                if ((n = string5.indexOf(32, n + 1)) >= 0 || !(file = new File(string5)).exists() || file.isDirectory()) continue;
                string5 = "\"" + string5 + "\"";
                break;
            }
        }
        return string5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class JarFilenameFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".jar");
        }
    }
}

