/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.module;

import com.tridium.program.BProgram;
import com.tridium.program.module.BuildException;
import com.tridium.program.module.BuildStep;
import com.tridium.program.module.ComponentWriter;
import com.tridium.program.module.IBuildListener;
import com.tridium.program.module.ValidateModel;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.file.FileUtil;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BProgramModule
extends BComponent {
    public static final Property moduleName = BProgramModule.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"mustBeSlotName", (boolean)true));
    public static final Property description = BProgramModule.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"max", (int)100));
    public static final Property vendor = BProgramModule.newProperty((int)0, (String)"", null);
    public static final Property vendorVersion = BProgramModule.newProperty((int)0, (String)"0", (BFacets)BFacets.make((String)"validator", (String)"baja:VersionValidator"));
    public static final Property dependencies = BProgramModule.newProperty((int)4, (BValue)BNameMap.DEFAULT, null);
    public static final Property programs = BProgramModule.newProperty((int)4, (BValue)new BFolder(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final Lexicon lex;
    private static final String packageName = "autogen";
    private static BuildStep[] buildSteps;
    private File buildRoot;
    HashMap typeMap;
    static /* synthetic */ Class class$com$tridium$program$module$BProgramModule;
    static /* synthetic */ Class class$com$tridium$program$BProgram;

    public final String getModuleName() {
        return this.getString(moduleName);
    }

    public final void setModuleName(String string) {
        this.setString(moduleName, string, null);
    }

    public final String getDescription() {
        return this.getString(description);
    }

    public final void setDescription(String string) {
        this.setString(description, string, null);
    }

    public final String getVendor() {
        return this.getString(vendor);
    }

    public final void setVendor(String string) {
        this.setString(vendor, string, null);
    }

    public final String getVendorVersion() {
        return this.getString(vendorVersion);
    }

    public final void setVendorVersion(String string) {
        this.setString(vendorVersion, string, null);
    }

    public final BNameMap getDependencies() {
        return (BNameMap)this.get(dependencies);
    }

    public final void setDependencies(BNameMap bNameMap) {
        this.set(dependencies, (BValue)bNameMap, null);
    }

    public final BFolder getPrograms() {
        return (BFolder)this.get(programs);
    }

    public final void setPrograms(BFolder bFolder) {
        this.set(programs, (BValue)bFolder, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public static final String toTypeName(BProgram bProgram) {
        return bProgram.getDisplayName(null);
    }

    public static final String toComponentName(BProgram bProgram) {
        if (bProgram.getParent() == null) {
            throw new IllegalStateException("Must be parented.");
        }
        String string = BProgramModule.toTypeName(bProgram);
        if (!Character.isUpperCase(string.charAt(0))) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("B").append(string.charAt(0));
        int n = 1;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c)) {
                return null;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final BNameMap rationalizeDependecies(BProgramModule bProgramModule) {
        HashSet<String> hashSet = new HashSet<String>();
        BNameMap bNameMap = bProgramModule.getDependencies();
        String[] stringArray = bNameMap.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!BProgram.isSpecialModule(stringArray[n])) {
                hashSet.add(stringArray[n]);
            }
            ++n;
        }
        BProgram[] bProgramArray = bProgramModule.listPrograms();
        int n2 = 0;
        while (n2 < bProgramArray.length) {
            String[] stringArray2 = TextUtil.split((String)bProgramArray[n2].getCode().getDependencies(), (char)';');
            int n3 = 0;
            while (n3 < stringArray2.length) {
                String string = stringArray2[n3];
                if (bNameMap.get(string) == null && !BProgram.isSpecialModule(string)) {
                    bNameMap = BNameMap.make((BNameMap)bNameMap, (String)string, (String)Sys.getRegistry().getModule(string).getVendorVersion().toString(2));
                }
                hashSet.remove(string);
                ++n3;
            }
            ++n2;
        }
        Object[] objectArray = hashSet.toArray();
        int n4 = 0;
        while (n4 < objectArray.length) {
            bNameMap = BNameMap.remove((BNameMap)bNameMap, (String)((String)objectArray[n4]));
            ++n4;
        }
        return bNameMap;
    }

    public final void buildModule(IBuildListener iBuildListener) throws BuildException {
        if (iBuildListener == null) {
            iBuildListener = new IBuildListener(){

                public final void updateDesc(String string) {
                }

                public final void setNumBuildSteps(int n) {
                }

                public final void nextStep(String string) {
                }

                public final BWidget getOwner() {
                    return null;
                }
            };
        }
        iBuildListener.setNumBuildSteps(buildSteps.length + this.listPrograms().length);
        iBuildListener.updateDesc(lex.getText("programModule.build", new Object[]{this.getModuleName()}));
        int n = 0;
        while (n < buildSteps.length) {
            buildSteps[n].runStep(this, iBuildListener);
            ++n;
        }
    }

    public final BProgram[] listPrograms() {
        BFolder bFolder = this.getPrograms();
        Class clazz = class$com$tridium$program$BProgram;
        if (clazz == null) {
            clazz = class$com$tridium$program$BProgram = BProgramModule.class("[Lcom.tridium.program.BProgram;", false);
        }
        return (BProgram[])bFolder.getChildren(clazz);
    }

    final File getBuildRoot() {
        return this.buildRoot;
    }

    final void setBuildRoot(File file) {
        this.buildRoot = file;
    }

    final String getPreferredSymbol() {
        return this.getModuleName();
    }

    public final BIcon getIcon() {
        return icon;
    }

    static final /* synthetic */ String access$1() {
        return packageName;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$program$module$BProgramModule;
        if (clazz == null) {
            clazz = class$com$tridium$program$module$BProgramModule = BProgramModule.class("[Lcom.tridium.program.module.BProgramModule;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((BIcon)BIcon.std((String)"module.png"), (BIcon)BIcon.std((String)"badges/script.png"));
        Class clazz2 = class$com$tridium$program$module$BProgramModule;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$program$module$BProgramModule = BProgramModule.class("[Lcom.tridium.program.module.BProgramModule;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        buildSteps = new BuildStep[]{new ValidateStep(), new InitStep(), new WriteComponentsStep(), new WriteBuildXmlStep(), new WriteModuleIncludeStep(), new WritePaletteStep(), new WriteLexiconStep(), new NiagaraBuildStep()};
    }

    static class ValidateStep
    extends BuildStep {
        private String modOrd;

        public void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.validate"));
            this.modOrd = this.module.getNavOrd().toString();
            boolean bl = false;
            ValidateModel validateModel = ValidateModel.make(this.module);
            if (validateModel.getErrCount() > 0) {
                bl = true;
                this.appendErrOrdLines(null, validateModel);
            }
            BProgram[] bProgramArray = this.module.listPrograms();
            int n = 0;
            while (n < bProgramArray.length) {
                validateModel = ValidateModel.make(bProgramArray[n]);
                if (validateModel.getErrCount() > 0) {
                    bl = true;
                    this.appendErrOrdLines(bProgramArray[n], validateModel);
                }
                ++n;
            }
            if (bl) {
                throw new BuildException(lex.getText("programModule.validate.failed"));
            }
        }

        private final void appendErrOrdLines(BProgram bProgram, ValidateModel validateModel) {
            StringBuffer stringBuffer = new StringBuffer().append(this.modOrd).append("|view:program:ProgramModuleBuilder");
            if (bProgram != null) {
                stringBuffer.append("?program=").append(BProgramModule.toTypeName(bProgram));
            }
            int n = validateModel.getErrCount();
            String string = stringBuffer.toString();
            int n2 = 0;
            while (n2 < n) {
                this.interest.updateDesc(string + "|| " + validateModel.getValueAt(n2, 0));
                ++n2;
            }
        }

        ValidateStep() {
        }
    }

    static class InitStep
    extends BuildStep {
        File temp;
        File buildDir;

        public void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.init"));
            this.temp = new File(Sys.getBajaHome(), "temp");
            this.buildDir = new File(this.temp, this.module.getModuleName());
            FileUtil.delete((File)this.buildDir);
            this.buildDir.mkdirs();
            this.module.setBuildRoot(this.buildDir);
            this.module.typeMap = new HashMap();
        }

        InitStep() {
        }
    }

    static class WriteComponentsStep
    extends BuildStep {
        File packageDir;

        public void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.convert"));
            File file = new File(this.module.getBuildRoot(), "src");
            this.packageDir = new File(file, BProgramModule.packageName);
            if (!this.packageDir.mkdirs()) {
                throw new BuildException(lex.getText("programModule.convert.failPkg", new Object[]{this.packageDir}));
            }
            BProgram[] bProgramArray = this.module.listPrograms();
            int n = 0;
            while (n < bProgramArray.length) {
                String string = BProgramModule.toComponentName(bProgramArray[n]);
                String string2 = string + ".java";
                this.interest.nextStep(lex.getText("programModule.convert.write", new Object[]{string}));
                this.module.typeMap.put(BProgramModule.toTypeName(bProgramArray[n]), "autogen." + string);
                FileWriter fileWriter = new FileWriter(new File(this.packageDir, string2));
                new ComponentWriter(fileWriter, bProgramArray[n], BProgramModule.packageName).generate();
                ++n;
            }
        }

        WriteComponentsStep() {
        }
    }

    static class WriteBuildXmlStep
    extends BuildStep {
        public void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.buildXML"));
            File file = new File(this.module.getBuildRoot(), "build.xml");
            XWriter xWriter = new XWriter(file);
            xWriter.prolog();
            this.writeComments(xWriter);
            this.writeModule(xWriter);
            xWriter.close();
        }

        private final void writeComments(XWriter xWriter) throws IOException {
            StringBuffer stringBuffer = new StringBuffer().append("<!--").append("\n").append("  - Module Build File").append("\n").append("  - Auto-generated by the Program Module-Builder.").append("\n").append("  - Date: ").append(BAbsTime.now()).append("\n").append("  -->").append("\n\n");
            xWriter.write(stringBuffer.toString());
        }

        private final void writeModule(XWriter xWriter) throws IOException {
            XElem xElem = new XElem("module");
            String string = this.module.getVendorVersion();
            if (string.length() == 0) {
                string = "0";
            }
            xElem.addAttr("name", this.module.getModuleName()).addAttr("bajaVersion", "0").addAttr("preferredSymbol", this.module.getPreferredSymbol()).addAttr("description", this.module.getDescription()).addAttr("vendor", this.module.getVendor()).addAttr("vendorVersion", string);
            this.addDependencies(xElem);
            this.addPackages(xElem);
            xElem.write(xWriter);
        }

        private final void addDependencies(XElem xElem) {
            BNameMap bNameMap = BProgramModule.rationalizeDependecies(this.module);
            this.module.setDependencies(bNameMap);
            Object[] objectArray = bNameMap.list();
            SortUtil.sort((Object[])objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = bNameMap.get((String)object).getFormat();
                ModuleInfo moduleInfo = Sys.getRegistry().getModule((String)object);
                xElem.addContent((XContent)new XElem("dependency").addAttr("name", (String)object).addAttr("vendor", moduleInfo.getVendor()).addAttr("vendorVersion", string));
                ++n;
            }
        }

        private final void addPackages(XElem xElem) {
            xElem.addContent((XContent)new XElem("package").addAttr("name", BProgramModule.packageName));
        }

        WriteBuildXmlStep() {
        }
    }

    static class WriteModuleIncludeStep
    extends BuildStep {
        public void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.include"));
            File file = new File(this.module.getBuildRoot(), "module-include.xml");
            try {
                XWriter xWriter = new XWriter(file);
                xWriter.prolog();
                this.writeComments(xWriter);
                this.writeTypes(xWriter);
                xWriter.close();
            }
            catch (Exception exception) {
                throw new BuildException(lex.getText("programModule.include.fail"), exception);
            }
        }

        private final void writeComments(XWriter xWriter) throws IOException {
            StringBuffer stringBuffer = new StringBuffer().append("<!--").append("\n").append("  - Module Include File").append("\n").append("  - Auto-generated by the Program Module-Builder.").append("\n").append("  - Date: ").append(BAbsTime.now()).append("\n").append("  -->").append("\n\n");
            xWriter.write(stringBuffer.toString());
        }

        private final void writeTypes(XWriter xWriter) throws IOException {
            XElem xElem = new XElem("types");
            Iterator iterator = this.module.typeMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.module.typeMap.get(string);
                XElem xElem2 = new XElem("type").addAttr("name", string).addAttr("class", string2);
                xElem.addContent((XContent)xElem2);
            }
            xElem.write(xWriter);
        }

        WriteModuleIncludeStep() {
        }
    }

    static class WritePaletteStep
    extends BuildStep {
        protected void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.palette"));
            File file = new File(this.module.getBuildRoot(), "module.palette");
            XWriter xWriter = new XWriter(file);
            xWriter.prolog();
            XElem xElem = new XElem("bajaObjectGraph").addAttr("version", "1.0");
            XElem xElem2 = new XElem("p").addAttr("m", "b=baja").addAttr("t", "b:UnrestrictedFolder");
            BProgram[] bProgramArray = this.module.listPrograms();
            SortUtil.sort((Object[])bProgramArray, (Object[])bProgramArray, (Comparator)new Comparator(){

                public final int compare(Object object, Object object2) {
                    String string = BProgramModule.toTypeName((BProgram)((Object)object));
                    String string2 = BProgramModule.toTypeName((BProgram)((Object)object2));
                    return string.compareTo(string2);
                }
            });
            int n = 0;
            while (n < bProgramArray.length) {
                xElem2.addContent((XContent)new XElem("p").addAttr("n", BProgramModule.toTypeName(bProgramArray[n])).addAttr("m", this.module.getPreferredSymbol() + '=' + this.module.getModuleName()).addAttr("t", this.module.getPreferredSymbol() + ':' + BProgramModule.toTypeName(bProgramArray[n])));
                ++n;
            }
            xElem.addContent((XContent)xElem2);
            xElem.write(xWriter);
            xWriter.close();
        }

        WritePaletteStep() {
        }
    }

    static class WriteLexiconStep
    extends BuildStep {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.lexicon"));
            File file = new File(this.module.getBuildRoot(), "module.lexicon");
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            try {
                printStream.println("#");
                printStream.println("# Lexicon auto-generated by the Program Module-Builder");
                printStream.println("#");
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                printStream.close();
                throw throwable;
            }
            {
                Object var4_5 = null;
                printStream.close();
                return;
            }
        }

        WriteLexiconStep() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class NiagaraBuildStep
    extends BuildStep
    implements BConsole.ExecCallback {
        String cmd;
        int exitCode;

        protected synchronized void doStep() throws Exception {
            this.interest.nextStep(lex.getText("programModule.nbuild"));
            this.cmd = "build \"" + this.module.getBuildRoot() + '\"';
            BWidget bWidget = this.interest.getOwner();
            if (bWidget != null) {
                ((BNiagaraWbShell)bWidget.getShell()).openConsole().exec(this.cmd, (BConsole.ExecCallback)this);
                this.wait();
                if (this.exitCode != 0) {
                    throw new BuildException(lex.getText("programModule.nbuild.fail"));
                }
            } else {
                throw new IllegalStateException("must be in workbench.");
            }
        }

        public synchronized void consoleExecDone(BConsole bConsole, int n) {
            this.exitCode = n;
            this.notify();
        }

        private final /* synthetic */ void this() {
            this.exitCode = -1;
        }

        NiagaraBuildStep() {
            this.this();
        }
    }
}

