/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Properties;

final class Support {
    Support() {
    }

    private static String getClassName(String algType, String algName, Provider p) {
        String class_name = ((Properties)p).getProperty("Alg.Alias." + algType + "." + algName);
        class_name = class_name == null ? ((Properties)p).getProperty(String.valueOf(algType) + "." + algName) : ((Properties)p).getProperty(String.valueOf(algType) + "." + class_name);
        return class_name;
    }

    static Object[] getImplementation(String type, String algorithm) throws CertificateException {
        Provider[] providers = Security.getProviders();
        if (providers == null || providers.length == 0) {
            throw new CertificateException("No providers installed");
        }
        int i = 0;
        while (i < providers.length) {
            Object[] res = Support.getImplementation(type, algorithm, providers[i]);
            if (res != null) {
                return res;
            }
            ++i;
        }
        throw new CertificateException("Certificate type not found. [" + type + "." + algorithm + "]");
    }

    static Object[] getImplementation(String type, String algorithm, String provider) throws CertificateException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider not found. [" + provider + "]");
        }
        Object[] res = Support.getImplementation(type, algorithm, p);
        if (res != null) {
            return res;
        }
        throw new CertificateException("Certificate type not found. [" + type + "." + algorithm + "]");
    }

    private static Object[] getImplementation(String algType, String algName, Provider p) {
        try {
            String class_name = ((Properties)p).getProperty("Alg.Alias." + algType + "." + algName);
            class_name = class_name == null ? ((Properties)p).getProperty(String.valueOf(algType) + "." + algName) : ((Properties)p).getProperty(String.valueOf(algType) + "." + class_name);
            if (class_name == null) {
                return null;
            }
            Object[] res = new Object[]{Class.forName(class_name).newInstance(), p};
            return res;
        }
        catch (LinkageError e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

