/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.Support;

public class CertificateFactory {
    private final CertificateFactorySpi spi;

    protected CertificateFactory(CertificateFactorySpi certFacSpi, Provider provider, String type) {
        this.spi = certFacSpi;
    }

    public final Certificate generateCertificate(InputStream inStream) throws CertificateException {
        return this.spi.engineGenerateCertificate(inStream);
    }

    public static CertificateFactory getInstance(String type) throws CertificateException {
        Object[] o = Support.getImplementation("CertificateFactory", type);
        return new CertificateFactory((CertificateFactorySpi)o[0], (Provider)o[1], type);
    }

    public static final CertificateFactory getInstance(String type, String provider) throws CertificateException, NoSuchProviderException {
        Object[] o = Support.getImplementation("CertificateFactory", type, provider);
        return new CertificateFactory((CertificateFactorySpi)o[0], (Provider)o[1], type);
    }
}

