/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;

public final class AsnObjectId
extends AsnObject {
    private static final int[] _rsaEncryption = new int[]{1, 2, 840, 113549, 1, 1, 1};
    private static final int[] _md4WithRSAEncryption = new int[]{1, 2, 840, 113549, 1, 1, 3};
    private static final int[] _md5WithRSAEncryption = new int[]{1, 2, 840, 113549, 1, 1, 4};
    private static final int[] _sha1WithRSAEncryption = new int[]{1, 2, 840, 113549, 1, 1, 5};
    private static final int[] _rsaOAEPEncryptionSET = new int[]{1, 2, 840, 113549, 1, 1, 6};
    private static final int[] _id_hmacWithSHA1 = new int[]{1, 2, 840, 113549, 2, 7};
    private static final int[] _rc2_CBC = new int[]{1, 2, 840, 113549, 3, 2};
    private static final int[] _des_EDE3_CBC = new int[]{1, 2, 840, 113549, 3, 7};
    private static final int[] _rc5_CBC_PAD = new int[]{1, 2, 840, 113549, 3, 9};
    private static final int[] _pbeWithMD2AndDES_CBC = new int[]{1, 2, 840, 113549, 1, 5, 1};
    private static final int[] _pbeWithMD5AndDES_CBC = new int[]{1, 2, 840, 113549, 1, 5, 3};
    private static final int[] _pbeWithMD2AndRC2_CBC = new int[]{1, 2, 840, 113549, 1, 5, 4};
    private static final int[] _pbeWithMD5AndRC2_CBC = new int[]{1, 2, 840, 113549, 1, 5, 6};
    private static final int[] _pbeWithSHA1AndDES_CBC = new int[]{1, 2, 840, 113549, 1, 5, 10};
    private static final int[] _pbeWithSHA1AndRC2_CBC = new int[]{1, 2, 840, 113549, 1, 5, 11};
    private static final int[] _id_PBKDF2 = new int[]{1, 2, 840, 113549, 1, 5, 12};
    private static final int[] _id_PBES2 = new int[]{1, 2, 840, 113549, 1, 5, 13};
    private static final int[] _id_PBMAC1 = new int[]{1, 2, 840, 113549, 1, 5, 14};
    public static final AsnObjectId OID_rsaEncryption = new AsnObjectId(_rsaEncryption);
    public static final AsnObjectId OID_md5WithRSAEncryption = new AsnObjectId(_md5WithRSAEncryption);
    private final int[] components;

    public AsnObjectId(AsnInputStream is) throws IOException {
        super((byte)6);
        int len = is.readLength();
        if (len < 2) {
            throw new IOException("Invalid OBJECT_ID.");
        }
        byte[] payload = is.readBytes(len);
        this.components = AsnObjectId.decodePayload(payload);
    }

    public AsnObjectId(int[] components) {
        super((byte)6);
        if (components.length < 2) {
            throw new IllegalArgumentException("Less than 2 components.");
        }
        if (components[0] < 0 || components[0] > 2) {
            throw new IllegalArgumentException("First comp must be 0, 1 or 2.");
        }
        if (components[1] >= components[0] * 40) {
            throw new IllegalArgumentException("Scnd comp >= (First comp*40).");
        }
        int i = 0;
        while (i < components.length) {
            if (components[i] < 0) {
                throw new IllegalArgumentException("Negative comp (" + i + ").");
            }
            ++i;
        }
        this.components = (int[])components.clone();
    }

    private static int[] decodePayload(byte[] payload) {
        int compCount = 2;
        int i = 1;
        while (i < payload.length) {
            if ((payload[i] & 0x80) == 0) {
                ++compCount;
            }
            ++i;
        }
        int[] comps = new int[compCount];
        comps[0] = payload[0] / 40;
        comps[1] = payload[0] % 40;
        int payloadOff = 1;
        int i2 = 2;
        while (i2 < comps.length) {
            byte b;
            int c = 0;
            do {
                b = payload[payloadOff++];
                c = c << 7 | b & 0x7F;
            } while ((b & 0x80) == 128);
            comps[i2] = c;
            ++i2;
        }
        return comps;
    }

    protected void encodePayload(AsnOutputStream os) throws IOException {
        os.writeByte((byte)(40 * this.components[0] + this.components[1]));
        int i = 2;
        while (i < this.components.length) {
            this.writeComponent(os, this.components[i]);
            ++i;
        }
    }

    private static int getEncodedComponentLen(int c) {
        if (c < 0) {
            throw new IllegalArgumentException("c: < 0");
        }
        if (c <= 127) {
            return 1;
        }
        if (c <= 16383) {
            return 2;
        }
        if (c <= 0x1FFFFF) {
            return 3;
        }
        if (c <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    protected int getEncodedLengthOfPayload(AsnOutputStream os) {
        int len = 1;
        int i = 2;
        while (i < this.components.length) {
            len += AsnObjectId.getEncodedComponentLen(this.components[i]);
            ++i;
        }
        return len;
    }

    public static void main(String[] argv) throws Exception {
        int[] comps = new int[]{1, 2, 840};
        AsnObjectId o = new AsnObjectId(comps);
        AsnOutputStream aos = new AsnOutputStream();
        aos.write(o);
        byte[] enc = aos.toByteArray();
        AsnInputStream ais = new AsnInputStream(enc);
        AsnObject oo = ais.read();
        System.out.println(oo);
    }

    public String toString(String indent) {
        String res = "OBJECT ID { ";
        int i = 0;
        while (i < this.components.length) {
            res = String.valueOf(res) + this.components[i] + " ";
            ++i;
        }
        return String.valueOf(indent) + res + "}";
    }

    private void writeComponent(AsnOutputStream os, int c) throws IOException {
        int len = AsnObjectId.getEncodedComponentLen(c);
        int i = len - 1;
        while (i > 0) {
            os.writeByte((byte)(c >>> i * 7 | 0x80));
            --i;
        }
        os.writeByte((byte)(c & 0x7F));
    }
}

