/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.crypto;

import com.tridium.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tks
extends KeyStoreSpi {
    public static final int MAGIC = 71077345;
    private static CryptoUtil pbe;
    private TreeMap aliases;

    public Enumeration engineAliases() {
        return new Aliases();
    }

    public boolean engineContainsAlias(String string) {
        boolean bl = false;
        if (this.aliases.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        this.aliases.remove(string);
    }

    public Certificate engineGetCertificate(String string) {
        Entry entry = this.entryOf(string);
        if (entry == null) {
            return null;
        }
        if (entry instanceof TrustEntry) {
            return ((TrustEntry)entry).cert;
        }
        KeyEntry keyEntry = (KeyEntry)entry;
        if (keyEntry.chain == null || keyEntry.chain.length == 0) {
            return null;
        }
        return keyEntry.chain[0];
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Iterator iterator = this.aliases.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.matches(certificate)) continue;
            return entry.alias;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Entry entry = this.entryOf(string);
        if (entry instanceof KeyEntry) {
            return ((KeyEntry)entry).chain;
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Entry entry = (Entry)this.aliases.get(string);
        if (entry == null) {
            return null;
        }
        return new Date(entry.creation);
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Entry entry = this.entryOf(string);
        if (entry == null) {
            throw new UnrecoverableKeyException("Alias not found: " + string);
        }
        if (entry instanceof TrustEntry) {
            throw new UnrecoverableKeyException("Alias not a key entry: " + string);
        }
        return ((KeyEntry)entry).decodeKey(cArray);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.engineIsKeyEntry(string) ^ true;
    }

    public boolean engineIsKeyEntry(String string) {
        Entry entry = this.entryOf(string);
        if (entry == null) {
            return false;
        }
        return entry instanceof KeyEntry;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream == null) {
            return;
        }
        try {
            if (this.readInt(inputStream) != 71077345) {
                throw new IOException("Not a tridium keystore.");
            }
            int n = this.readInt(inputStream);
            byte[] byArray = new byte[n];
            if (inputStream.read(byArray) != n) {
                throw new IOException("Corrupt keystore.");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray = Tks.decrypt(byArray, cArray));
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n2 = dataInputStream.readInt();
            if (n2 != 0) {
                throw new IOException("Unexpected version: " + n2);
            }
            int n3 = dataInputStream.readInt();
            while (--n3 >= 0) {
                int n4 = dataInputStream.readInt();
                Entry entry = n4 == 0 ? new KeyEntry() : new TrustEntry();
                entry.read(dataInputStream);
                this.aliases.put(entry.alias, entry);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw noSuchAlgorithmException;
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException(throwable.getMessage());
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Entry entry = this.entryOf(string);
        TrustEntry trustEntry = null;
        if (entry == null) {
            trustEntry = new TrustEntry();
            trustEntry.alias = string;
            trustEntry.creation = System.currentTimeMillis();
            trustEntry.cert = certificate;
            this.aliases.put(string, trustEntry);
        } else {
            if (entry instanceof KeyEntry) {
                throw new KeyStoreException("Alias in use for a key entry.");
            }
            trustEntry = (TrustEntry)entry;
            trustEntry.cert = certificate;
        }
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            Entry entry = this.entryOf(string);
            if (entry == null) {
                KeyEntry keyEntry = new KeyEntry();
                keyEntry.alias = string;
                keyEntry.creation = System.currentTimeMillis();
                keyEntry.chain = certificateArray;
                keyEntry.encodeKey(key, cArray);
                this.aliases.put(string, keyEntry);
            } else {
                KeyEntry keyEntry = (KeyEntry)entry;
                keyEntry.encodeKey(key, cArray);
                keyEntry.chain = certificateArray;
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception.getMessage());
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Unsupported Operation");
    }

    public int engineSize() {
        return this.aliases.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(this.aliases.size());
            Iterator iterator = this.aliases.values().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry instanceof KeyEntry) {
                    dataOutputStream.writeInt(0);
                } else {
                    dataOutputStream.writeInt(1);
                }
                entry.write(dataOutputStream);
            }
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byArray = Tks.encrypt(byArray, cArray);
            this.writeInt(outputStream, 71077345);
            this.writeInt(outputStream, byArray.length);
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw noSuchAlgorithmException;
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException(throwable.getMessage());
        }
    }

    static byte[] decrypt(byte[] byArray, char[] cArray) throws Exception {
        if (cArray == null || cArray.length == 0) {
            return byArray;
        }
        return pbe.decrypt(byArray, cArray);
    }

    static byte[] encrypt(byte[] byArray, char[] cArray) throws Exception {
        if (cArray == null || cArray.length == 0) {
            return byArray;
        }
        return pbe.encrypt(byArray, cArray);
    }

    int readInt(InputStream inputStream) throws IOException {
        return (inputStream.read() << 24) + (inputStream.read() << 16) + (inputStream.read() << 8) + inputStream.read();
    }

    void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 24 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    private final Entry entryOf(String string) {
        return (Entry)this.aliases.get(string);
    }

    private final /* synthetic */ void this() {
        this.aliases = new TreeMap(new EntryComparator());
    }

    public Tks() {
        this.this();
    }

    static {
        try {
            pbe = new CryptoUtil();
        }
        catch (Exception exception) {
            System.out.println("Unable to initialize Password Based Encryption.");
            exception.printStackTrace();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Aliases
    implements Enumeration {
        Iterator it;

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }

        private final /* synthetic */ void this() {
            this.it = Tks.this.aliases.keySet().iterator();
        }

        private Aliases() {
            this.this();
        }
    }

    static class TrustEntry
    extends Entry {
        Certificate cert;

        public boolean matches(Certificate certificate) {
            if (certificate == null) {
                boolean bl = false;
                if (this.cert == null) {
                    bl = true;
                }
                return bl;
            }
            if (this.cert == null) {
                return false;
            }
            return this.cert.equals(certificate);
        }

        public void read(DataInputStream dataInputStream) throws Exception {
            int n = dataInputStream.readInt();
            if (n != 0) {
                throw new Exception("Unexpected version: " + n);
            }
            super.read(dataInputStream);
            this.cert = this.readCert(dataInputStream);
        }

        public void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeInt(0);
            super.write(dataOutputStream);
            this.writeCert(this.cert, dataOutputStream);
        }

        TrustEntry() {
        }
    }

    static class KeyEntry
    extends Entry {
        String alg;
        Certificate[] chain;
        String format;
        byte[] key;
        boolean isPrivate;

        public Key decodeKey(char[] cArray) throws UnrecoverableKeyException {
            try {
                EncodedKeySpec encodedKeySpec;
                byte[] byArray = Tks.decrypt(this.key, cArray);
                if (this.format.equals("PKCS#8") || this.format.equals("PKCS8")) {
                    encodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                } else if (this.format.equals("X.509") || this.format.equals("X509")) {
                    encodedKeySpec = new X509EncodedKeySpec(byArray);
                } else {
                    throw new Exception("Unknown format: " + this.format);
                }
                KeyFactory keyFactory = KeyFactory.getInstance(this.alg);
                if (this.isPrivate) {
                    return keyFactory.generatePrivate(encodedKeySpec);
                }
                return keyFactory.generatePublic(encodedKeySpec);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new UnrecoverableKeyException(exception.getMessage());
            }
        }

        public void encodeKey(Key key, char[] cArray) throws Exception {
            this.alg = key.getAlgorithm();
            this.format = key.getFormat();
            this.key = Tks.encrypt(key.getEncoded(), cArray);
            this.isPrivate = key instanceof PrivateKey;
        }

        public boolean matches(Certificate certificate) {
            if (certificate == null) {
                if (this.chain == null) {
                    return true;
                }
                return this.chain.length == 0;
            }
            if (this.chain == null) {
                return false;
            }
            if (this.chain.length == 0) {
                return false;
            }
            return this.chain[0].equals(certificate);
        }

        public void read(DataInputStream dataInputStream) throws Exception {
            int n = dataInputStream.readInt();
            if (n != 0) {
                throw new Exception("Unexpected version: " + n);
            }
            super.read(dataInputStream);
            this.alg = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            this.chain = new Certificate[n2];
            n = 0;
            while (n < n2) {
                this.chain[n] = this.readCert(dataInputStream);
                ++n;
            }
            this.format = dataInputStream.readUTF();
            n = dataInputStream.readInt();
            if (n > 0) {
                this.key = new byte[n];
                dataInputStream.read(this.key);
            }
            this.isPrivate = dataInputStream.readBoolean();
        }

        public void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeInt(0);
            super.write(dataOutputStream);
            dataOutputStream.writeUTF(this.alg);
            int n = 0;
            if (this.chain != null) {
                n = this.chain.length;
            }
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                this.writeCert(this.chain[n2], dataOutputStream);
                ++n2;
            }
            dataOutputStream.writeUTF(this.format);
            n = 0;
            if (this.key != null) {
                n = this.key.length;
            }
            dataOutputStream.writeInt(n);
            if (n > 0) {
                dataOutputStream.write(this.key);
            }
            dataOutputStream.writeBoolean(this.isPrivate);
        }

        KeyEntry() {
        }
    }

    static abstract class Entry {
        String alias;
        long creation;

        public abstract boolean matches(Certificate var1);

        public void read(DataInputStream dataInputStream) throws Exception {
            int n = dataInputStream.readInt();
            if (n != 0) {
                throw new IOException("Unexpected version: " + n);
            }
            this.alias = dataInputStream.readUTF();
            this.creation = dataInputStream.readLong();
        }

        Certificate readCert(DataInputStream dataInputStream) throws Exception {
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.read(byArray);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(string);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }

        public final String toString() {
            return this.alias;
        }

        public void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeInt(0);
            dataOutputStream.writeUTF(this.alias);
            dataOutputStream.writeLong(this.creation);
        }

        void writeCert(Certificate certificate, DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeUTF(certificate.getType());
            byte[] byArray = certificate.getEncoded();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }

        Entry() {
        }
    }

    static class EntryComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return object.toString().compareTo(object2.toString());
        }

        EntryComparator() {
        }
    }
}

