/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.util;

import com.tridium.tls.datatypes.BBirAdjDelHistoryRecord;
import com.tridium.tls.datatypes.BDelVarHistoryRecord;
import com.tridium.tls.datatypes.BFuelMgmtHistoryRecord;
import com.tridium.tls.datatypes.BInTankInvHistoryRecord;
import com.tridium.tls.datatypes.BInTankStaHistoryRecord;
import com.tridium.tls.datatypes.BPriAlmHisHistoryRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.sys.BStruct;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public class TlsHistoryHelper {
    private static BHistoryId badHistoryId = null;
    private static BHistoryId dvHistoryId = null;
    private static BHistoryId fmHistoryId = null;
    private static BHistoryId itiHistoryId = null;
    private static BHistoryId itsHistoryId = null;
    private static BHistoryId pahHistoryId = null;
    private static BHistoryDatabase historyDatabase = null;

    public static void initHistory(Type type) throws ServiceNotFoundException {
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        historyDatabase = bHistoryService.getDatabase();
        if (historyDatabase == null) {
            System.out.println("Error: History database is null.");
        } else if (type == BBirAdjDelHistoryRecord.TYPE) {
            if (badHistoryId == null) {
                BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsBadHistory"), BTypeSpec.make((Type)BBirAdjDelHistoryRecord.TYPE));
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                badHistoryId = bHistoryConfig.getId();
                if (!historyDatabase.exists(badHistoryId)) {
                    historyDatabase.createHistory(bHistoryConfig);
                } else {
                    historyDatabase.reconfigureHistory(bHistoryConfig);
                }
            }
        } else if (type == BDelVarHistoryRecord.TYPE) {
            if (dvHistoryId == null) {
                BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsDvHistory"), BTypeSpec.make((Type)BDelVarHistoryRecord.TYPE));
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                dvHistoryId = bHistoryConfig.getId();
                if (!historyDatabase.exists(dvHistoryId)) {
                    historyDatabase.createHistory(bHistoryConfig);
                } else {
                    historyDatabase.reconfigureHistory(bHistoryConfig);
                }
            }
        } else if (type == BFuelMgmtHistoryRecord.TYPE) {
            if (fmHistoryId == null) {
                BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsFmHistory"), BTypeSpec.make((Type)BFuelMgmtHistoryRecord.TYPE));
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                fmHistoryId = bHistoryConfig.getId();
                if (!historyDatabase.exists(fmHistoryId)) {
                    historyDatabase.createHistory(bHistoryConfig);
                } else {
                    historyDatabase.reconfigureHistory(bHistoryConfig);
                }
            }
        } else if (type == BInTankInvHistoryRecord.TYPE) {
            if (itiHistoryId == null) {
                BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsItiHistory"), BTypeSpec.make((Type)BInTankInvHistoryRecord.TYPE));
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                itiHistoryId = bHistoryConfig.getId();
                if (!historyDatabase.exists(itiHistoryId)) {
                    historyDatabase.createHistory(bHistoryConfig);
                } else {
                    historyDatabase.reconfigureHistory(bHistoryConfig);
                }
            }
        } else if (type == BInTankStaHistoryRecord.TYPE) {
            if (itsHistoryId == null) {
                BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsItsHistory"), BTypeSpec.make((Type)BInTankStaHistoryRecord.TYPE));
                bHistoryConfig.setTimeZone(BTimeZone.getLocal());
                itsHistoryId = bHistoryConfig.getId();
                if (!historyDatabase.exists(itsHistoryId)) {
                    historyDatabase.createHistory(bHistoryConfig);
                } else {
                    historyDatabase.reconfigureHistory(bHistoryConfig);
                }
            }
        } else if (type == BPriAlmHisHistoryRecord.TYPE && pahHistoryId == null) {
            BHistoryConfig bHistoryConfig = new BHistoryConfig(BHistoryId.make((String)Sys.getStation().getStationName(), (String)"TlsPahHistory"), BTypeSpec.make((Type)BPriAlmHisHistoryRecord.TYPE));
            bHistoryConfig.setTimeZone(BTimeZone.getLocal());
            pahHistoryId = bHistoryConfig.getId();
            if (!historyDatabase.exists(pahHistoryId)) {
                historyDatabase.createHistory(bHistoryConfig);
            } else {
                historyDatabase.reconfigureHistory(bHistoryConfig);
            }
        }
    }

    public static void appendTlsHistory(BStruct bStruct) {
        try {
            if (bStruct.getType() == BBirAdjDelHistoryRecord.TYPE) {
                historyDatabase.getHistory(badHistoryId).append((BIHistoryRecordSet)((BBirAdjDelHistoryRecord)bStruct));
            } else if (bStruct.getType() == BDelVarHistoryRecord.TYPE) {
                historyDatabase.getHistory(dvHistoryId).append((BIHistoryRecordSet)((BDelVarHistoryRecord)bStruct));
            } else if (bStruct.getType() == BFuelMgmtHistoryRecord.TYPE) {
                historyDatabase.getHistory(fmHistoryId).append((BIHistoryRecordSet)((BFuelMgmtHistoryRecord)bStruct));
            } else if (bStruct.getType() == BInTankInvHistoryRecord.TYPE) {
                historyDatabase.getHistory(itiHistoryId).append((BIHistoryRecordSet)((BInTankInvHistoryRecord)bStruct));
            } else if (bStruct.getType() == BInTankStaHistoryRecord.TYPE) {
                historyDatabase.getHistory(itsHistoryId).append((BIHistoryRecordSet)((BInTankStaHistoryRecord)bStruct));
            } else if (bStruct.getType() == BPriAlmHisHistoryRecord.TYPE) {
                historyDatabase.getHistory(pahHistoryId).append((BIHistoryRecordSet)((BPriAlmHisHistoryRecord)bStruct));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BHistoryId getTlsHistoryId(Type type) {
        if (type == BBirAdjDelHistoryRecord.TYPE) {
            return badHistoryId;
        }
        if (type == BDelVarHistoryRecord.TYPE) {
            return dvHistoryId;
        }
        if (type == BFuelMgmtHistoryRecord.TYPE) {
            return fmHistoryId;
        }
        if (type == BInTankInvHistoryRecord.TYPE) {
            return itiHistoryId;
        }
        if (type == BInTankStaHistoryRecord.TYPE) {
            return itsHistoryId;
        }
        if (type == BPriAlmHisHistoryRecord.TYPE) {
            return pahHistoryId;
        }
        return null;
    }

    public void setTlsHistoryId(Type type, BHistoryId bHistoryId) {
        if (type == BBirAdjDelHistoryRecord.TYPE) {
            badHistoryId = bHistoryId;
        } else if (type == BDelVarHistoryRecord.TYPE) {
            dvHistoryId = bHistoryId;
        } else if (type == BFuelMgmtHistoryRecord.TYPE) {
            fmHistoryId = bHistoryId;
        } else if (type == BInTankInvHistoryRecord.TYPE) {
            itiHistoryId = bHistoryId;
        } else if (type == BInTankStaHistoryRecord.TYPE) {
            itsHistoryId = bHistoryId;
        } else if (type == BPriAlmHisHistoryRecord.TYPE) {
            pahHistoryId = bHistoryId;
        }
    }

    public BHistoryDatabase getHistoryDatabase() {
        return historyDatabase;
    }

    public void setHistoryDatabase(BHistoryDatabase bHistoryDatabase) {
        historyDatabase = bHistoryDatabase;
    }
}

