/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BInTankInvHistoryRecord;
import com.tridium.tls.datatypes.BInTankInventoryEntry;
import com.tridium.tls.datatypes.BInTankInventoryTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350InventoryReport;
import com.tridium.tls.messages.Tls350InventoryReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350ItiDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTls350InTankInvProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350InTankInvProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)30), null);
    public static final Property inTankInventoryTable = BTls350InTankInvProxyExt.newProperty((int)0, (BValue)new BInTankInventoryTable(), null);
    public static final Property maxOldEntriesSaved = BTls350InTankInvProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Type TYPE;
    private Vector iTIEntriesVector;
    static /* synthetic */ Class class$com$tridium$tls$point$BTls350InTankInvProxyExt;
    static /* synthetic */ Class class$com$tridium$tls$datatypes$BInTankInventoryEntry;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime bRelTime) {
        this.set(minimumPollInterval, (BValue)bRelTime, null);
    }

    public BInTankInventoryTable getInTankInventoryTable() {
        return (BInTankInventoryTable)this.get(inTankInventoryTable);
    }

    public void setInTankInventoryTable(BInTankInventoryTable bInTankInventoryTable) {
        this.set(inTankInventoryTable, (BValue)bInTankInventoryTable, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int n) {
        this.setInt(maxOldEntriesSaved, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            TlsHistoryHelper.initHistory(BInTankInvHistoryRecord.TYPE);
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        super.stopped();
    }

    public void poll() {
        if (!this.pollIntervalCheck(this.getMinimumPollInterval().getMillis())) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        int n;
        boolean bl;
        boolean bl2 = false;
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            bl2 = bl = true;
        }
        if ((n = ((BTls350FuelTankDevice)this.device()).getTankNumber()) <= 0) {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit ... tank number not initialized");
            }
            return;
        }
        Tls350InventoryReport tls350InventoryReport = new Tls350InventoryReport(n, this);
        Tls350InventoryReportResponse tls350InventoryReportResponse = (Tls350InventoryReportResponse)this.network().sendSync(tls350InventoryReport);
        if (tls350InventoryReportResponse != null) {
            if (tls350InventoryReportResponse.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                if (n != tls350InventoryReportResponse.getMessageTank()) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + tls350InventoryReportResponse.getMessageTank() + " may be lost\n\n");
                    }
                    return;
                }
                if (tls350InventoryReportResponse.getProduct() == 0) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... poll response contains no productCode... nothing to record tankNumber=" + tls350InventoryReportResponse.getMessageTank());
                    }
                    return;
                }
                BAbsTime bAbsTime = tls350InventoryReportResponse.getReadTime();
                if (bAbsTime == null) {
                    bAbsTime = BAbsTime.make();
                }
                int n2 = tls350InventoryReportResponse.getProduct();
                boolean bl3 = tls350InventoryReportResponse.isDeliveryInProcess();
                boolean bl4 = tls350InventoryReportResponse.isLeakTestInProcess();
                boolean bl5 = tls350InventoryReportResponse.isInvalidFuelHeight();
                float f = tls350InventoryReportResponse.getVolume();
                float f2 = tls350InventoryReportResponse.getTcVolume();
                float f3 = tls350InventoryReportResponse.getUllage();
                float f4 = tls350InventoryReportResponse.getFuelLevel();
                float f5 = tls350InventoryReportResponse.getWaterLevel();
                float f6 = tls350InventoryReportResponse.getTemperature();
                float f7 = tls350InventoryReportResponse.getWaterVolume();
                this.iTIEntriesVector = new Vector();
                BInTankInventoryEntry bInTankInventoryEntry = new BInTankInventoryEntry();
                bInTankInventoryEntry.setStore(Sys.getStation().getStationName());
                bInTankInventoryEntry.setTank(n);
                bInTankInventoryEntry.setReadTime(bAbsTime);
                bInTankInventoryEntry.setProductCode(n2);
                bInTankInventoryEntry.setDelInProgress(bl3);
                bInTankInventoryEntry.setLeakTestInProg(bl4);
                bInTankInventoryEntry.setInvlFuelHgtAlm(bl5);
                bInTankInventoryEntry.setVolume(f);
                bInTankInventoryEntry.setTcVolume(f2);
                bInTankInventoryEntry.setUllage(f3);
                bInTankInventoryEntry.setFuelLevel(f4);
                bInTankInventoryEntry.setWaterLevel(f5);
                bInTankInventoryEntry.setTemperature(f6);
                bInTankInventoryEntry.setWaterVolume(f7);
                this.iTIEntriesVector.addElement(bInTankInventoryEntry);
                if (this.iTIEntriesVector.size() > 0) {
                    this.setValue(this.iTIEntriesVector);
                    return;
                }
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)bStatusString);
                this.updateDemuxedProxyPoints();
            } else {
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
    }

    public void setValue(Vector vector) {
        Object object;
        BInTankInventoryEntry[] bInTankInventoryEntryArray = new BInTankInventoryEntry[vector.size()];
        vector.copyInto((Object[])bInTankInventoryEntryArray);
        BInTankInventoryTable bInTankInventoryTable = new BInTankInventoryTable();
        int n = 0;
        while (n < bInTankInventoryEntryArray.length) {
            try {
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                object = bInTankInventoryEntryArray[n].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + (String)object);
                }
                bStatusString.setValue((String)object);
                this.readOk((BStatusValue)bStatusString);
                this.getInTankInventoryTable().add("inTankInventoryEntry?", (BValue)bInTankInventoryEntryArray[n]);
                bInTankInventoryTable.add("inTankInventoryEntry?", (BValue)((BInTankInventoryEntry)bInTankInventoryEntryArray[n].newCopy()));
                BInTankInvHistoryRecord bInTankInvHistoryRecord = new BInTankInvHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), bInTankInventoryEntryArray[n]);
                TlsHistoryHelper.appendTlsHistory((BStruct)bInTankInvHistoryRecord);
            }
            catch (Exception exception) {
                this.readFail(exception.toString());
            }
            ++n;
        }
        this.updateDemuxedProxyPoints();
        BInTankInventoryEntry[] bInTankInventoryEntryArray2 = this.getInTankInventoryTable().getSortedCopy();
        if (bInTankInventoryEntryArray2 == null || bInTankInventoryEntryArray2.length == 0) {
            return;
        }
        int n2 = bInTankInventoryEntryArray2.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350InTankInvProxyExt setValue sortedValues.length=" + bInTankInventoryEntryArray2.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (n2 > 0) {
            object = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                ((Vector)object).addElement(bInTankInventoryEntryArray2[n3]);
                ++n3;
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                BInTankInventoryEntry bInTankInventoryEntry = (BInTankInventoryEntry)((Object)enumeration.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350InTankInvProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + bInTankInventoryEntry.createCommaDelimitedString());
                }
                this.getInTankInventoryTable().remove((BComplex)bInTankInventoryEntry);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, bInTankInventoryTable));
    }

    private final void updateDemuxedProxyPoints() {
        BInTankInventoryEntry[] bInTankInventoryEntryArray = this.getInTankInventoryTable().getSortedCopy();
        if (bInTankInventoryEntryArray == null || bInTankInventoryEntryArray.length == 0) {
            return;
        }
        BInTankInventoryEntry bInTankInventoryEntry = bInTankInventoryEntryArray[bInTankInventoryEntryArray.length - 1];
        String[] stringArray = CsMgrBaseUtil.createStringArrayOfAllNames((String)bInTankInventoryEntry.createCommaDelimitedString());
        if (stringArray != null && stringArray.length > 0) {
            BControlPoint[] bControlPointArray;
            BTls350ItiDemuxedPointDeviceExt bTls350ItiDemuxedPointDeviceExt = null;
            BDeviceExt[] bDeviceExtArray = this.getDevice().getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BTls350ItiDemuxedPointDeviceExt) {
                    bTls350ItiDemuxedPointDeviceExt = (BTls350ItiDemuxedPointDeviceExt)bDeviceExtArray[n];
                    break;
                }
                ++n;
            }
            if (bTls350ItiDemuxedPointDeviceExt != null && (bControlPointArray = bTls350ItiDemuxedPointDeviceExt.getPoints()) != null && bControlPointArray.length > 0) {
                int n2 = 0;
                while (n2 < bControlPointArray.length) {
                    if (bControlPointArray[n2].getProxyExt().getType() == BTls350DemuxedProxyExt.TYPE) {
                        ((BTls350DemuxedProxyExt)bControlPointArray[n2].getProxyExt()).updateValueFrom(stringArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public void readDataNow() {
        this.pollForDataNow();
    }

    public void clearDataNow() {
        BInTankInventoryEntry[] bInTankInventoryEntryArray;
        this.getInTankInventoryTable().lease(2);
        BInTankInventoryTable bInTankInventoryTable = this.getInTankInventoryTable();
        Class clazz = class$com$tridium$tls$datatypes$BInTankInventoryEntry;
        if (clazz == null) {
            clazz = class$com$tridium$tls$datatypes$BInTankInventoryEntry = BTls350InTankInvProxyExt.class("[Lcom.tridium.tls.datatypes.BInTankInventoryEntry;", false);
        }
        if ((bInTankInventoryEntryArray = (BInTankInventoryEntry[])bInTankInventoryTable.getChildren(clazz)) != null && bInTankInventoryEntryArray.length > 0) {
            int n = 0;
            while (n < bInTankInventoryEntryArray.length) {
                this.getInTankInventoryTable().remove((BComplex)bInTankInventoryEntryArray[n]);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$tls$point$BTls350InTankInvProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$tls$point$BTls350InTankInvProxyExt = BTls350InTankInvProxyExt.class("[Lcom.tridium.tls.point.BTls350InTankInvProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

