/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BBirAdjDelHistoryRecord;
import com.tridium.tls.datatypes.BBirAdjustedDeliveryEntry;
import com.tridium.tls.datatypes.BBirAdjustedDeliveryTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350BirAdjustedDeliveryReport;
import com.tridium.tls.messages.Tls350BirAdjustedDeliveryReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350BadDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTls350BirAdjDelProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    public static final Property minimumPollInterval = BTls350BirAdjDelProxyExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)2), null);
    public static final Property birAdjustedDeliveryTable = BTls350BirAdjDelProxyExt.newProperty((int)0, (BValue)new BBirAdjustedDeliveryTable(), null);
    public static final Property maxOldEntriesSaved = BTls350BirAdjDelProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    public static final Action purgeHashtable = BTls350BirAdjDelProxyExt.newAction((int)4, null);
    public static final Type TYPE;
    private Vector bADEntriesVector;
    private Hashtable bADHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;
    static /* synthetic */ Class class$com$tridium$tls$point$BTls350BirAdjDelProxyExt;
    static /* synthetic */ Class class$com$tridium$tls$datatypes$BBirAdjustedDeliveryEntry;

    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    public void setMinimumPollInterval(BRelTime bRelTime) {
        this.set(minimumPollInterval, (BValue)bRelTime, null);
    }

    public BBirAdjustedDeliveryTable getBirAdjustedDeliveryTable() {
        return (BBirAdjustedDeliveryTable)this.get(birAdjustedDeliveryTable);
    }

    public void setBirAdjustedDeliveryTable(BBirAdjustedDeliveryTable bBirAdjustedDeliveryTable) {
        this.set(birAdjustedDeliveryTable, (BValue)bBirAdjustedDeliveryTable, null);
    }

    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    public void setMaxOldEntriesSaved(int n) {
        this.setInt(maxOldEntriesSaved, n, null);
    }

    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BBirAdjustedDeliveryEntry[] bBirAdjustedDeliveryEntryArray = this.getBirAdjustedDeliveryTable().getEntries();
            this.bADHashtable = new Hashtable(bBirAdjustedDeliveryEntryArray.length * 2);
            int n = 0;
            while (n < bBirAdjustedDeliveryEntryArray.length) {
                Long l = bBirAdjustedDeliveryEntryArray[n].getHTKey();
                this.bADHashtable.put(l, bBirAdjustedDeliveryEntryArray[n]);
                ++n;
            }
            TlsHistoryHelper.initHistory(BBirAdjDelHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.bADHashtable = null;
        super.stopped();
    }

    public void poll() {
        if (!this.pollIntervalCheck(this.getMinimumPollInterval().getMillis())) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        int n;
        boolean bl;
        boolean bl2 = false;
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            bl2 = bl = true;
        }
        if ((n = ((BTls350FuelTankDevice)this.device()).getTankNumber()) <= 0) {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit ... tank number not initialized");
            }
            return;
        }
        Tls350BirAdjustedDeliveryReport tls350BirAdjustedDeliveryReport = new Tls350BirAdjustedDeliveryReport(n, this);
        Tls350BirAdjustedDeliveryReportResponse tls350BirAdjustedDeliveryReportResponse = (Tls350BirAdjustedDeliveryReportResponse)this.network().sendSync(tls350BirAdjustedDeliveryReport);
        if (tls350BirAdjustedDeliveryReportResponse != null) {
            if (tls350BirAdjustedDeliveryReportResponse.getSuccessfulResponse()) {
                this.device().setPollSinceLastPingFlag();
                Tls350BirAdjustedDeliveryReportResponse.BirAdjustedDelivery[] birAdjustedDeliveryArray = tls350BirAdjustedDeliveryReportResponse.getBirAdjustedDeliveryEntries();
                if (birAdjustedDeliveryArray == null || birAdjustedDeliveryArray.length <= 0) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow exit... response has no entries");
                    }
                    return;
                }
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow continue... process " + birAdjustedDeliveryArray.length + " entries");
                }
                if (n != birAdjustedDeliveryArray[0].getTankNumber()) {
                    if (bl) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + birAdjustedDeliveryArray[0].getTankNumber() + " may be lost\n\n");
                    }
                    return;
                }
                this.bADEntriesVector = new Vector();
                int n2 = 0;
                while (n2 < birAdjustedDeliveryArray.length) {
                    BBirAdjustedDeliveryEntry bBirAdjustedDeliveryEntry = new BBirAdjustedDeliveryEntry();
                    bBirAdjustedDeliveryEntry.setStore(Sys.getStation().getStationName());
                    bBirAdjustedDeliveryEntry.setTank(n);
                    bBirAdjustedDeliveryEntry.setStartDateTime(birAdjustedDeliveryArray[n2].getDeliveryStartDateTime());
                    bBirAdjustedDeliveryEntry.setEndDateTime(birAdjustedDeliveryArray[n2].getDeliveryEndDateTime());
                    bBirAdjustedDeliveryEntry.setStartVolume(birAdjustedDeliveryArray[n2].getStartVolume());
                    bBirAdjustedDeliveryEntry.setEndVolume(birAdjustedDeliveryArray[n2].getEndVolume());
                    bBirAdjustedDeliveryEntry.setAdjustedDelVolume(birAdjustedDeliveryArray[n2].getAdjustedDelivery());
                    bBirAdjustedDeliveryEntry.setAdjustedTcDelVolume(birAdjustedDeliveryArray[n2].getAdjustedTcDelivery());
                    bBirAdjustedDeliveryEntry.setStartFuelHeight(birAdjustedDeliveryArray[n2].getStartFuelHeight());
                    bBirAdjustedDeliveryEntry.setStartFuelTemp1(birAdjustedDeliveryArray[n2].getStartFuelTemp1());
                    bBirAdjustedDeliveryEntry.setStartFuelTemp2(birAdjustedDeliveryArray[n2].getStartFuelTemp2());
                    bBirAdjustedDeliveryEntry.setStartFuelTemp3(birAdjustedDeliveryArray[n2].getStartFuelTemp3());
                    bBirAdjustedDeliveryEntry.setStartFuelTemp4(birAdjustedDeliveryArray[n2].getStartFuelTemp4());
                    bBirAdjustedDeliveryEntry.setStartFuelTemp5(birAdjustedDeliveryArray[n2].getStartFuelTemp5());
                    bBirAdjustedDeliveryEntry.setStartFuelTemp6(birAdjustedDeliveryArray[n2].getStartFuelTemp6());
                    bBirAdjustedDeliveryEntry.setEndFuelHeight(birAdjustedDeliveryArray[n2].getEndFuelHeight());
                    bBirAdjustedDeliveryEntry.setEndFuelTemp1(birAdjustedDeliveryArray[n2].getEndFuelTemp1());
                    bBirAdjustedDeliveryEntry.setEndFuelTemp2(birAdjustedDeliveryArray[n2].getEndFuelTemp2());
                    bBirAdjustedDeliveryEntry.setEndFuelTemp3(birAdjustedDeliveryArray[n2].getEndFuelTemp3());
                    bBirAdjustedDeliveryEntry.setEndFuelTemp4(birAdjustedDeliveryArray[n2].getEndFuelTemp4());
                    bBirAdjustedDeliveryEntry.setEndFuelTemp5(birAdjustedDeliveryArray[n2].getEndFuelTemp5());
                    bBirAdjustedDeliveryEntry.setEndFuelTemp6(birAdjustedDeliveryArray[n2].getEndFuelTemp6());
                    bBirAdjustedDeliveryEntry.setTotDispensedDurDel(birAdjustedDeliveryArray[n2].getTotDispensedDurDel());
                    bBirAdjustedDeliveryEntry.setStartFuelTempAvg(birAdjustedDeliveryArray[n2].getStartFuelTempAvg());
                    bBirAdjustedDeliveryEntry.setEndFuelTempAvg(birAdjustedDeliveryArray[n2].getEndFuelTempAvg());
                    BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (bBirAdjustedDeliveryEntry.getEndDateTime().isBefore(bAbsTime)) {
                        if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bBirAdjustedDeliveryEntry.toDebugString() + " for " + this.getName());
                        }
                    } else {
                        Long l = bBirAdjustedDeliveryEntry.getHTKey();
                        if (this.bADHashtable == null || this.bADHashtable.get(l) == null) {
                            this.bADHashtable.put(l, bBirAdjustedDeliveryEntry);
                            this.bADEntriesVector.addElement(bBirAdjustedDeliveryEntry);
                            if (bl) {
                                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + bBirAdjustedDeliveryEntry.toDebugString() + " for " + this.getName());
                            }
                        } else if (bl) {
                            this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + bBirAdjustedDeliveryEntry.toDebugString() + " for " + this.getName());
                        }
                    }
                    ++n2;
                }
                if (this.bADEntriesVector.size() > 0) {
                    this.setValue(this.bADEntriesVector);
                    return;
                }
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)bStatusString);
                this.updateDemuxedProxyPoints();
            } else {
                if (bl) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (bl) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector vector) {
        Object object;
        BBirAdjustedDeliveryEntry[] bBirAdjustedDeliveryEntryArray = new BBirAdjustedDeliveryEntry[vector.size()];
        vector.copyInto((Object[])bBirAdjustedDeliveryEntryArray);
        BBirAdjustedDeliveryTable bBirAdjustedDeliveryTable = new BBirAdjustedDeliveryTable();
        int n = 0;
        while (n < bBirAdjustedDeliveryEntryArray.length) {
            try {
                BStatusString bStatusString = (BStatusString)this.getReadValue().newCopy();
                object = bBirAdjustedDeliveryEntryArray[n].createCommaDelimitedString();
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + (String)object);
                }
                bStatusString.setValue((String)object);
                this.readOk((BStatusValue)bStatusString);
                this.getBirAdjustedDeliveryTable().add("birAdjustedDeliveryEntry?", (BValue)bBirAdjustedDeliveryEntryArray[n]);
                bBirAdjustedDeliveryTable.add("birAdjustedDeliveryEntry?", (BValue)((BBirAdjustedDeliveryEntry)bBirAdjustedDeliveryEntryArray[n].newCopy()));
                BBirAdjDelHistoryRecord bBirAdjDelHistoryRecord = new BBirAdjDelHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), bBirAdjustedDeliveryEntryArray[n]);
                TlsHistoryHelper.appendTlsHistory((BStruct)bBirAdjDelHistoryRecord);
            }
            catch (Exception exception) {
                this.readFail(exception.toString());
            }
            ++n;
        }
        this.updateDemuxedProxyPoints();
        BBirAdjustedDeliveryEntry[] bBirAdjustedDeliveryEntryArray2 = this.getBirAdjustedDeliveryTable().getSortedCopy();
        if (bBirAdjustedDeliveryEntryArray2 == null || bBirAdjustedDeliveryEntryArray2.length == 0) {
            return;
        }
        int n2 = bBirAdjustedDeliveryEntryArray2.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350BirAdjDelProxyExt setValue sortedValues.length=" + bBirAdjustedDeliveryEntryArray2.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (n2 > 0) {
            object = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                ((Vector)object).addElement(bBirAdjustedDeliveryEntryArray2[n3]);
                ++n3;
            }
            Enumeration enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                BBirAdjustedDeliveryEntry bBirAdjustedDeliveryEntry = (BBirAdjustedDeliveryEntry)((Object)enumeration.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350BirAdjDelProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + bBirAdjustedDeliveryEntry.createCommaDelimitedString());
                }
                this.getBirAdjustedDeliveryTable().remove((BComplex)bBirAdjustedDeliveryEntry);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, bBirAdjustedDeliveryTable));
    }

    private final void updateDemuxedProxyPoints() {
        BBirAdjustedDeliveryEntry[] bBirAdjustedDeliveryEntryArray = this.getBirAdjustedDeliveryTable().getSortedCopy();
        if (bBirAdjustedDeliveryEntryArray == null || bBirAdjustedDeliveryEntryArray.length == 0) {
            return;
        }
        BBirAdjustedDeliveryEntry bBirAdjustedDeliveryEntry = bBirAdjustedDeliveryEntryArray[bBirAdjustedDeliveryEntryArray.length - 1];
        String[] stringArray = CsMgrBaseUtil.createStringArrayOfAllNames((String)bBirAdjustedDeliveryEntry.createCommaDelimitedString());
        if (stringArray != null && stringArray.length > 0) {
            BControlPoint[] bControlPointArray;
            BTls350BadDemuxedPointDeviceExt bTls350BadDemuxedPointDeviceExt = null;
            BDeviceExt[] bDeviceExtArray = this.getDevice().getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BTls350BadDemuxedPointDeviceExt) {
                    bTls350BadDemuxedPointDeviceExt = (BTls350BadDemuxedPointDeviceExt)bDeviceExtArray[n];
                    break;
                }
                ++n;
            }
            if (bTls350BadDemuxedPointDeviceExt != null && (bControlPointArray = bTls350BadDemuxedPointDeviceExt.getPoints()) != null && bControlPointArray.length > 0) {
                int n2 = 0;
                while (n2 < bControlPointArray.length) {
                    if (bControlPointArray[n2].getProxyExt().getType() == BTls350DemuxedProxyExt.TYPE) {
                        ((BTls350DemuxedProxyExt)bControlPointArray[n2].getProxyExt()).updateValueFrom(stringArray);
                    }
                    ++n2;
                }
            }
        }
    }

    public void readDataNow() {
        this.pollForDataNow();
    }

    public void clearDataNow() {
        BBirAdjustedDeliveryEntry[] bBirAdjustedDeliveryEntryArray;
        this.getBirAdjustedDeliveryTable().lease(2);
        BBirAdjustedDeliveryTable bBirAdjustedDeliveryTable = this.getBirAdjustedDeliveryTable();
        Class clazz = class$com$tridium$tls$datatypes$BBirAdjustedDeliveryEntry;
        if (clazz == null) {
            clazz = class$com$tridium$tls$datatypes$BBirAdjustedDeliveryEntry = BTls350BirAdjDelProxyExt.class("[Lcom.tridium.tls.datatypes.BBirAdjustedDeliveryEntry;", false);
        }
        if ((bBirAdjustedDeliveryEntryArray = (BBirAdjustedDeliveryEntry[])bBirAdjustedDeliveryTable.getChildren(clazz)) != null && bBirAdjustedDeliveryEntryArray.length > 0) {
            int n = 0;
            while (n < bBirAdjustedDeliveryEntryArray.length) {
                this.getBirAdjustedDeliveryTable().remove((BComplex)bBirAdjustedDeliveryEntryArray[n]);
                ++n;
            }
        }
        this.bADHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context context) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration enumeration = this.bADHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Long l = (Long)enumeration.nextElement();
            BBirAdjustedDeliveryEntry bBirAdjustedDeliveryEntry = (BBirAdjustedDeliveryEntry)((Object)this.bADHashtable.get(l));
            BAbsTime bAbsTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!bBirAdjustedDeliveryEntry.getEndDateTime().isBefore(bAbsTime)) continue;
            this.bADHashtable.remove(l);
        }
        this.reschedPurgeHashtable();
    }

    private final void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime bAbsTime = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)bAbsTime, (Action)purgeHashtable, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$tls$point$BTls350BirAdjDelProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$tls$point$BTls350BirAdjDelProxyExt = BTls350BirAdjDelProxyExt.class("[Lcom.tridium.tls.point.BTls350BirAdjDelProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

