/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.TlsMessageConst;
import java.io.ByteArrayOutputStream;

public class TlsOutputStream
extends ByteArrayOutputStream
implements TlsMessageConst {
    public void writeFloat(float f) {
        int n = Float.floatToIntBits(f);
        this.write((byte)(n & 0xFF));
        this.write((byte)(n >> 8 & 0xFF));
        this.write((byte)(n >> 16 & 0xFF));
        this.write((byte)(n >> 24 & 0xFF));
    }

    public void writeInt(int n) {
        this.write(n & 0xFF);
        this.write(n >> 8 & 0xFF);
    }

    public void writeInt(int n, int n2) {
        switch (n2) {
            case 4: {
                this.write(n & 0xFF);
                this.write(n >> 8 & 0xFF);
                this.write(n >> 16 & 0xFF);
                this.write(n >> 24 & 0xFF);
                break;
            }
            case 3: {
                this.write(n & 0xFF);
                this.write(n >> 8 & 0xFF);
                this.write(n >> 16 & 0xFF);
                break;
            }
            case 2: {
                this.write(n & 0xFF);
                this.write(n >> 8 & 0xFF);
            }
        }
    }

    public void writeInt(byte by) {
        this.write(by);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n) {
        int n2 = byArray.length > n ? n : byArray.length;
        this.write(byArray, 0, n2);
        while (n2 < n) {
            this.write(0);
            ++n2;
        }
    }

    public void writeString(String string, int n) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length > --n ? n : byArray.length;
        this.write(byArray, n2);
        if (n > n2) {
            this.pad(n - n2);
        }
        this.write(0);
    }

    public void pad(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.write(0);
            ++n2;
        }
    }

    public int getCount() {
        return this.count;
    }

    public int writeCrc() {
        int n = 0;
        this.write(n & 0xFF);
        this.write((n & 0xFF00) >> 8);
        return n;
    }

    public void writeCksum() {
    }

    public void writeAsciiInt(int n, int n2) {
        String string = "0000000000" + n;
        int n3 = string.length() - n2;
        while (n3 < string.length()) {
            this.write(string.charAt(n3) & 0xFF);
            ++n3;
        }
    }

    public void writeString(String string) {
        this.write(string.getBytes());
    }
}

