/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.TlsMessageConst;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;

public class TlsInputStream
extends ByteArrayInputStream
implements TlsMessageConst {
    public int readInt() {
        return this.read() | this.read() << 8;
    }

    public int readInt(int n) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 24;
                break;
            }
            case 3: {
                n2 = this.read() & 0xFF | (this.read() & 0xFF) << 8 | (this.read() & 0xFF) << 16;
                break;
            }
            case 2: {
                n2 = this.read() & 0xFF | (this.read() & 0xFF) << 8;
            }
        }
        return n2;
    }

    public long readLong(int n) {
        long l = 0L;
        switch (n) {
            case 1: {
                l = this.read() & 0xFF;
                break;
            }
            case 2: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8;
                break;
            }
            case 3: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16;
                break;
            }
            case 4: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24;
                break;
            }
            case 5: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32;
                break;
            }
            case 6: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32 | (long)(this.read() & 0xFF) << 40;
                break;
            }
            case 7: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32 | (long)(this.read() & 0xFF) << 40 | (long)(this.read() & 0xFF) << 48;
                break;
            }
            case 8: {
                l = (long)(this.read() & 0xFF) | (long)(this.read() & 0xFF) << 8 | (long)(this.read() & 0xFF) << 16 | (long)(this.read() & 0xFF) << 24 | (long)(this.read() & 0xFF) << 32 | (long)(this.read() & 0xFF) << 40 | (long)(this.read() & 0xFF) << 48 | (long)(this.read() & 0xFF) << 56;
                break;
            }
        }
        return l;
    }

    public float readFloat() {
        int n = this.read() & 0xFF;
        n |= this.read() << 8 & 0xFF00;
        n |= this.read() << 16 & 0xFF0000;
        return Float.intBitsToFloat(n |= this.read() << 24 & 0xFF000000);
    }

    public String readString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        boolean bl = false;
        while (n2++ < n) {
            int n3 = this.read();
            if (n3 == -1) {
                bl = true;
            }
            char c = (char)n3;
            if (bl) continue;
            if (c == '\u0000') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public byte[] readByteArray(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)this.read();
            ++n2;
        }
        return byArray;
    }

    public void read(ByteArrayOutputStream byteArrayOutputStream, int n) {
        while (n-- > 0) {
            byteArrayOutputStream.write((byte)this.read());
        }
    }

    public BAbsTime readDateTime(boolean bl) {
        int n = 0;
        BAbsTime bAbsTime = BAbsTime.now();
        int n2 = bAbsTime.getYear();
        if (bl) {
            int n3 = this.readAsciiInt(2);
            n = n3 + 2000;
            if (n > n2) {
                n = n3 + 1900;
            }
            int n4 = this.readAsciiInt(2);
            int n5 = this.readAsciiInt(2);
            int n6 = this.readAsciiInt(2);
            int n7 = this.readAsciiInt(2);
            bAbsTime = BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n4 - 1)), (int)n5, (int)n6, (int)n7);
        } else {
            int n8 = this.readAsciiInt(2) - 1;
            int n9 = this.readAsciiInt(2);
            int n10 = this.readAsciiInt(2);
            int n11 = this.readAsciiInt(2);
            bAbsTime = BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n8 - 1)), (int)n9, (int)n10, (int)n11);
        }
        return bAbsTime;
    }

    public int readAsciiInt(int n) {
        int n2 = 0;
        int n3 = (int)Math.pow(10.0, n - 1);
        int n4 = 0;
        while (n4 < n) {
            char c = (char)this.read();
            int n5 = Character.getNumericValue(c);
            if (n5 == -1) {
                return -1;
            }
            n2 += n5 * n3;
            n3 /= 10;
            ++n4;
        }
        return n2;
    }

    public float readAsciiFloat(int n, int n2) {
        float f = this.readAsciiInt(n);
        return f / (float)n2;
    }

    public float readAsciiFloat() {
        long l;
        String string = this.readString(8);
        try {
            l = Long.parseLong(string.trim(), 16);
        }
        catch (Exception exception) {
            System.out.println(" Integer.parseInt threw exception: " + exception);
            return Float.NaN;
        }
        return Float.intBitsToFloat((int)l);
    }

    public TlsInputStream(byte[] byArray) {
        super(byArray);
    }

    public TlsInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }
}

