/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350InTankStaProxyExt;
import javax.baja.sys.BAbsTime;
import javax.baja.util.ByteArrayUtil;

public class Tls350StatusReportResponse
extends Tls350Response
implements TlsMessageConst {
    public int messageTank;
    public BAbsTime readTime;
    public int numAlarms;
    public int[] alarmTypes;
    private BTls350InTankStaProxyExt ext;
    private boolean debug;

    public BAbsTime getReadTime() {
        return this.readTime;
    }

    public int getMessageTank() {
        return this.messageTank;
    }

    public int getNumAlarms() {
        return this.numAlarms;
    }

    public int[] getAlarmTypes() {
        if (this.debug) {
            this.ext.getLog().trace("TlsStaResponse :readResponse alarmTypes.length=" + this.alarmTypes.length);
        }
        return this.alarmTypes;
    }

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = super.readResponse(byArray);
        if (this.debug) {
            this.ext.getLog().trace("TlsStaResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (tlsInputStream.available() < 16 || !this.functionCode.equalsIgnoreCase("205")) {
            this.alarmTypes = new int[0];
            this.messageTank = this.tank;
            return tlsInputStream;
        }
        this.readTime = tlsInputStream.readDateTime(true);
        boolean bl = false;
        while (!bl) {
            tlsInputStream.mark(0);
            String string = tlsInputStream.readString(2);
            if (string.equals("&&")) {
                this.alarmTypes = new int[0];
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            tlsInputStream.reset();
            if (tlsInputStream.available() < 8) {
                this.alarmTypes = new int[0];
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            this.messageTank = tlsInputStream.readAsciiInt(2);
            String string2 = tlsInputStream.readString(2);
            try {
                this.numAlarms = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("StatusReportResponse could not convert numAlarmsStr from str-hex-int... numAlarmsStr=" + string2);
                return tlsInputStream;
            }
            if (this.numAlarms == 0) {
                this.alarmTypes = new int[0];
                return tlsInputStream;
            }
            String string3 = "";
            this.alarmTypes = new int[this.numAlarms];
            int n = 0;
            while (n < this.numAlarms) {
                this.alarmTypes[n] = tlsInputStream.readAsciiInt(2);
                string3 = n == 0 ? "" + this.alarmTypes[n] : string3 + ", " + this.alarmTypes[n];
                if (this.debug) {
                    this.ext.getLog().trace("TlsStaResponse :readResponse nextEntry=" + string3);
                }
                ++n;
            }
            bl = true;
        }
        return tlsInputStream;
    }

    public Tls350StatusReportResponse() {
    }

    public Tls350StatusReportResponse(BTls350InTankStaProxyExt bTls350InTankStaProxyExt) {
        this.ext = bTls350InTankStaProxyExt;
        boolean bl = false;
        if (bTls350InTankStaProxyExt != null && bTls350InTankStaProxyExt.getLog().isTraceOn() && bTls350InTankStaProxyExt.device().getUserData().indexOf("msg") != -1) {
            bl = true;
        }
        this.debug = bl;
    }
}

