/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsOutputStream;
import com.tridium.tls.messages.TlsReceivedMessage;
import java.io.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tls350Message
extends Message
implements TlsMessageConst {
    public String functionCode;
    public int tank;
    public int errorCode;
    public byte[] messageData;

    public void write(OutputStream outputStream) {
        try {
            outputStream.write(this.getByteArray());
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public byte[] getByteArray() {
        TlsOutputStream tlsOutputStream = new TlsOutputStream();
        tlsOutputStream.write(1);
        tlsOutputStream.write(105);
        tlsOutputStream.writeString(this.functionCode);
        tlsOutputStream.writeAsciiInt(this.tank, 2);
        tlsOutputStream.writeCksum();
        return tlsOutputStream.toByteArray();
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        TlsReceivedMessage tlsReceivedMessage = (TlsReceivedMessage)receivedMessage;
        byte[] byArray = tlsReceivedMessage.getBytes();
        Tls350Response tls350Response = new Tls350Response();
        tls350Response.readResponse(byArray);
        return tls350Response;
    }

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = new TlsInputStream(byArray);
        tlsInputStream.read();
        this.functionCode = tlsInputStream.readString(3);
        this.tank = tlsInputStream.readAsciiInt(2);
        this.messageData = new byte[tlsInputStream.available() - 1];
        int n = 0;
        while (n < this.messageData.length) {
            this.messageData[n] = (byte)(tlsInputStream.read() & 0xFF);
            ++n;
        }
        tlsInputStream = new TlsInputStream(this.messageData);
        return tlsInputStream;
    }

    public void dataToString(StringBuffer stringBuffer) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n----msg header ----");
        stringBuffer.append("\n functionCode  = " + this.functionCode);
        stringBuffer.append("\n tank          = 0x" + Integer.toHexString(this.tank));
        stringBuffer.append("\n----msg data ----");
        if (this.messageData != null) {
            int n = 0;
            while (n < this.messageData.length) {
                stringBuffer.append("\n data[" + n + "]      = " + Integer.toHexString(this.messageData[n] & 0xFF));
                ++n;
            }
        } else {
            stringBuffer.append("\n data[]        = none");
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.errorCode = 0;
    }

    public Tls350Message() {
        this.this();
    }

    public Tls350Message(String string, int n) {
        this.this();
        this.functionCode = string;
        this.tank = n;
    }

    public Tls350Message(String string) {
        this.this();
        this.functionCode = string;
        this.tank = 0;
    }
}

