/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350InTankInvProxyExt;
import javax.baja.sys.BAbsTime;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tls350InventoryReportResponse
extends Tls350Response {
    public static final int STATUS_DELIVERY_IN_PROCESS = 1;
    public static final int STATUS_LEAK_TEST_IN_PROCESS = 2;
    public static final int STATUS_INVALID_FUEL_HEIGHT = 4;
    public BAbsTime readTime;
    public int statusBits;
    public int product;
    public int messageTank;
    public int numValues;
    public float volume;
    public float tcVolume;
    public float ullage;
    public float fuelLevel;
    public float waterLevel;
    public float temperature;
    public float waterVolume;
    private BTls350InTankInvProxyExt ext;
    private boolean debug;
    private boolean debug_negative;

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = super.readResponse(byArray);
        if (this.debug) {
            this.ext.getLog().trace("TlsInvResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (tlsInputStream.available() < 16 || !this.functionCode.equalsIgnoreCase("201")) {
            this.messageTank = this.tank;
            return tlsInputStream;
        }
        this.readTime = tlsInputStream.readDateTime(true);
        boolean bl = false;
        while (!bl) {
            tlsInputStream.mark(0);
            String string = tlsInputStream.readString(2);
            if (string.equals("&&")) {
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            tlsInputStream.reset();
            if (tlsInputStream.available() < 8) {
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            this.messageTank = tlsInputStream.readAsciiInt(2);
            this.product = tlsInputStream.readAsciiInt(1);
            this.statusBits = tlsInputStream.readAsciiInt(4);
            String string2 = tlsInputStream.readString(2);
            try {
                this.numValues = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("InventoryReportResponse could not convert numValuesStr from str-hex-int... numValuesStr=" + string2);
                return tlsInputStream;
            }
            if (this.numValues == 0) {
                return tlsInputStream;
            }
            String string3 = "";
            int n = 0;
            while (n < this.numValues) {
                float f = tlsInputStream.readAsciiFloat();
                if (f < 0.0f && this.debug_negative) {
                    System.out.println("IRR (-) value=" + f + " i=" + n);
                    System.out.println("IRR - ba=" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)byArray.length));
                }
                switch (n) {
                    case 0: {
                        this.volume = f;
                        string3 = string3 + this.volume;
                        break;
                    }
                    case 1: {
                        this.tcVolume = f;
                        string3 = string3 + ", " + this.tcVolume;
                        break;
                    }
                    case 2: {
                        this.ullage = f;
                        string3 = string3 + ", " + this.ullage;
                        break;
                    }
                    case 3: {
                        this.fuelLevel = f;
                        string3 = string3 + ", " + this.fuelLevel;
                        break;
                    }
                    case 4: {
                        this.waterLevel = f;
                        string3 = string3 + ", " + this.waterLevel;
                        break;
                    }
                    case 5: {
                        this.temperature = f;
                        string3 = string3 + ", " + this.temperature;
                        break;
                    }
                    case 6: {
                        this.waterVolume = f;
                        string3 = string3 + ", " + this.waterVolume;
                        break;
                    }
                }
                ++n;
            }
            if (this.debug) {
                this.ext.getLog().trace("TlsInvResponse :readResponse nextEntry=" + string3);
            }
            bl = true;
        }
        return tlsInputStream;
    }

    public BAbsTime getReadTime() {
        return this.readTime;
    }

    public int getMessageTank() {
        return this.messageTank;
    }

    public int getProduct() {
        return this.product;
    }

    public boolean isDeliveryInProcess() {
        boolean bl = false;
        if ((this.statusBits & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isLeakTestInProcess() {
        boolean bl = false;
        if ((this.statusBits & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isInvalidFuelHeight() {
        boolean bl = false;
        if ((this.statusBits & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public float getVolume() {
        if (this.volume < 0.0f) {
            return 0.0f;
        }
        return this.volume;
    }

    public float getTcVolume() {
        if (this.tcVolume < 0.0f) {
            return 0.0f;
        }
        return this.tcVolume;
    }

    public float getUllage() {
        if (this.ullage < 0.0f) {
            return 0.0f;
        }
        return this.ullage;
    }

    public float getFuelLevel() {
        if (this.fuelLevel < 0.0f) {
            return 0.0f;
        }
        return this.fuelLevel;
    }

    public float getWaterLevel() {
        if (this.waterLevel < 0.0f) {
            return 0.0f;
        }
        return this.waterLevel;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getWaterVolume() {
        if (this.waterVolume < 0.0f) {
            return 0.0f;
        }
        return this.waterVolume;
    }

    private final /* synthetic */ void this() {
        this.statusBits = 0;
        this.product = 0;
        this.messageTank = 0;
        this.numValues = 0;
        this.volume = Float.NaN;
        this.tcVolume = Float.NaN;
        this.ullage = Float.NaN;
        this.fuelLevel = Float.NaN;
        this.waterLevel = Float.NaN;
        this.temperature = Float.NaN;
        this.waterVolume = Float.NaN;
    }

    public Tls350InventoryReportResponse() {
        this.this();
    }

    public Tls350InventoryReportResponse(BTls350InTankInvProxyExt bTls350InTankInvProxyExt) {
        this.this();
        this.ext = bTls350InTankInvProxyExt;
        boolean bl = false;
        if (bTls350InTankInvProxyExt != null && bTls350InTankInvProxyExt.getLog().isTraceOn() && bTls350InTankInvProxyExt.device().getUserData().indexOf("msg") != -1) {
            bl = true;
        }
        this.debug = bl;
        boolean bl2 = false;
        if (bTls350InTankInvProxyExt != null && bTls350InTankInvProxyExt.getLog().isTraceOn() && bTls350InTankInvProxyExt.device().getUserData().indexOf("negv") != -1) {
            bl2 = true;
        }
        this.debug_negative = bl2;
    }
}

