/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350FuelMgmtProxyExt;
import java.util.Vector;
import javax.baja.sys.BAbsTime;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tls350FuelManagementReportResponse
extends Tls350Response {
    public BAbsTime readTime;
    public int messageTank;
    public int numTankProdCodePairs;
    public int numberFieldsToFollowInt;
    public FuelManagement[] fuelManagementEntries;
    private BTls350FuelMgmtProxyExt ext;
    private boolean debug;

    public FuelManagement[] getFuelManagementEntries() {
        if (this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse fuelManagementEntries.length=" + this.fuelManagementEntries.length);
        }
        return this.fuelManagementEntries;
    }

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = super.readResponse(byArray);
        if (this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (tlsInputStream.available() < 16 || !this.functionCode.equalsIgnoreCase("281")) {
            this.fuelManagementEntries = new FuelManagement[0];
            this.messageTank = this.tank;
            return tlsInputStream;
        }
        this.readTime = tlsInputStream.readDateTime(true);
        if (this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse readTime=" + this.readTime.encodeToString());
        }
        boolean bl = false;
        Vector<FuelManagement> vector = new Vector<FuelManagement>();
        while (!bl) {
            tlsInputStream.mark(0);
            String string = tlsInputStream.readString(2);
            if (string.equals("&&")) {
                this.fuelManagementEntries = new FuelManagement[0];
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            tlsInputStream.reset();
            if (tlsInputStream.available() < 8) {
                this.fuelManagementEntries = new FuelManagement[0];
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            String string2 = tlsInputStream.readString(2);
            try {
                this.numTankProdCodePairs = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("FuelManagementReportResponse could not convert numTankProdCodePairsStr from str-hex-int... numTankProdCodePairsStr=" + string2);
                return tlsInputStream;
            }
            if (this.debug) {
                this.ext.getLog().trace("TlsFMResponse :readResponse numTankProdCodePairs=" + this.numTankProdCodePairs);
            }
            if (this.numTankProdCodePairs != 0) {
                FuelManagement fuelManagement = new FuelManagement();
                int n = 0;
                while (n < this.numTankProdCodePairs) {
                    fuelManagement.setCurrentDateTime(this.readTime);
                    fuelManagement.setTankNumber(tlsInputStream.readAsciiInt(2));
                    fuelManagement.setProductCode(tlsInputStream.readString(1));
                    String string3 = tlsInputStream.readString(2);
                    try {
                        this.numberFieldsToFollowInt = Integer.parseInt(string3, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("AdjustedDeliveryReportResponse could not convert numberFieldsToFollowIntStr from str-hex-int... numberFieldsToFollowIntStr=" + string3);
                        return tlsInputStream;
                    }
                    int n2 = 0;
                    while (n2 < 10) {
                        switch (n2) {
                            case 0: {
                                fuelManagement.setDaysRemaining(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 1: {
                                fuelManagement.setPresentInventory(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 2: {
                                fuelManagement.setPresentUllage(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 3: {
                                fuelManagement.setSundaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 4: {
                                fuelManagement.setMondaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 5: {
                                fuelManagement.setTuesdaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 6: {
                                fuelManagement.setWednesdaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 7: {
                                fuelManagement.setThursdaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 8: {
                                fuelManagement.setFridaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                            case 9: {
                                fuelManagement.setSaturdaySales(n2 < this.numberFieldsToFollowInt ? tlsInputStream.readAsciiFloat() : Float.NaN);
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (this.debug) {
                        this.ext.getLog().trace("TlsFMResponse :readResponse nextEntry=" + fuelManagement.getFuelManagementLogString());
                    }
                    vector.addElement(fuelManagement);
                    ++n;
                }
            }
            bl = true;
        }
        if (vector != null && this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse entries.size()=" + vector.size());
        }
        if (vector == null || vector.size() <= 0) {
            this.fuelManagementEntries = new FuelManagement[0];
        } else {
            this.fuelManagementEntries = new FuelManagement[vector.size()];
            vector.copyInto(this.fuelManagementEntries);
        }
        if (this.fuelManagementEntries != null && this.debug) {
            this.ext.getLog().trace("TlsFMResponse :readResponse fuelManagementEntries.length=" + this.fuelManagementEntries.length);
        }
        return tlsInputStream;
    }

    private final /* synthetic */ void this() {
        this.messageTank = 0;
        this.fuelManagementEntries = null;
    }

    public Tls350FuelManagementReportResponse() {
        this.this();
    }

    public Tls350FuelManagementReportResponse(BTls350FuelMgmtProxyExt bTls350FuelMgmtProxyExt) {
        this.this();
        this.ext = bTls350FuelMgmtProxyExt;
        boolean bl = false;
        if (bTls350FuelMgmtProxyExt != null && bTls350FuelMgmtProxyExt.getLog().isTraceOn() && bTls350FuelMgmtProxyExt.device().getUserData().indexOf("msg") != -1) {
            bl = true;
        }
        this.debug = bl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FuelManagement {
        BAbsTime currentDateTime;
        int tankNumber;
        String productCode;
        float daysRemaining;
        float presentInventory;
        float presentUllage;
        float sundaySales;
        float mondaySales;
        float tuesdaySales;
        float wednesdaySales;
        float thursdaySales;
        float fridaySales;
        float saturdaySales;

        public void setCurrentDateTime(BAbsTime bAbsTime) {
            this.currentDateTime = bAbsTime;
        }

        public void setTankNumber(int n) {
            this.tankNumber = n;
        }

        public void setProductCode(String string) {
            this.productCode = string;
        }

        public void setDaysRemaining(float f) {
            this.daysRemaining = f;
        }

        public void setPresentInventory(float f) {
            this.presentInventory = f;
        }

        public void setPresentUllage(float f) {
            this.presentUllage = f;
        }

        public void setSundaySales(float f) {
            this.sundaySales = f;
        }

        public void setMondaySales(float f) {
            this.mondaySales = f;
        }

        public void setTuesdaySales(float f) {
            this.tuesdaySales = f;
        }

        public void setWednesdaySales(float f) {
            this.wednesdaySales = f;
        }

        public void setThursdaySales(float f) {
            this.thursdaySales = f;
        }

        public void setFridaySales(float f) {
            this.fridaySales = f;
        }

        public void setSaturdaySales(float f) {
            this.saturdaySales = f;
        }

        public BAbsTime getCurrentDateTime() {
            return this.currentDateTime;
        }

        public int getTankNumber() {
            return this.tankNumber;
        }

        public String getProductCode() {
            return this.productCode;
        }

        public float getDaysRemaining() {
            return this.daysRemaining;
        }

        public float getPresentInventory() {
            return this.presentInventory;
        }

        public float getPresentUllage() {
            return this.presentUllage;
        }

        public float getSundaySales() {
            return this.sundaySales;
        }

        public float getMondaySales() {
            return this.mondaySales;
        }

        public float getTuesdaySales() {
            return this.tuesdaySales;
        }

        public float getWednesdaySales() {
            return this.wednesdaySales;
        }

        public float getThursdaySales() {
            return this.thursdaySales;
        }

        public float getFridaySales() {
            return this.fridaySales;
        }

        public float getSaturdaySales() {
            return this.saturdaySales;
        }

        public String getFuelManagementLogString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.currentDateTime.encodeToString());
            stringBuffer.append(", ");
            stringBuffer.append(this.tankNumber);
            stringBuffer.append(", ");
            stringBuffer.append(this.productCode);
            stringBuffer.append(", ");
            stringBuffer.append(this.daysRemaining);
            stringBuffer.append(", ");
            stringBuffer.append(this.presentInventory);
            stringBuffer.append(", ");
            stringBuffer.append(this.presentUllage);
            stringBuffer.append(", ");
            stringBuffer.append(this.sundaySales);
            stringBuffer.append(", ");
            stringBuffer.append(this.mondaySales);
            stringBuffer.append(", ");
            stringBuffer.append(this.tuesdaySales);
            stringBuffer.append(", ");
            stringBuffer.append(this.wednesdaySales);
            stringBuffer.append(", ");
            stringBuffer.append(this.thursdaySales);
            stringBuffer.append(", ");
            stringBuffer.append(this.fridaySales);
            stringBuffer.append(", ");
            stringBuffer.append(this.saturdaySales);
            return stringBuffer.toString();
        }

        private final /* synthetic */ void this() {
            this.daysRemaining = Float.NaN;
            this.presentInventory = Float.NaN;
            this.presentUllage = Float.NaN;
            this.sundaySales = Float.NaN;
            this.mondaySales = Float.NaN;
            this.tuesdaySales = Float.NaN;
            this.wednesdaySales = Float.NaN;
            this.thursdaySales = Float.NaN;
            this.fridaySales = Float.NaN;
            this.saturdaySales = Float.NaN;
        }

        public FuelManagement() {
            this.this();
        }
    }
}

