/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.tls.messages.Tls350Response;
import com.tridium.tls.messages.TlsInputStream;
import com.tridium.tls.point.BTls350DelVarProxyExt;
import javax.baja.sys.BAbsTime;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Tls350DeliveryVarianceReportResponse
extends Tls350Response {
    public BAbsTime messageReadTime;
    public int messageTank;
    public String messageProduct;
    public int messageProbe;
    public int messageNumDeliveries;
    public int messageNumValues;
    public DeliveryVariance[] deliveries;
    private BTls350DelVarProxyExt ext;
    private boolean debug;

    public DeliveryVariance[] getDeliveryVariances() {
        if (this.debug) {
            this.ext.getLog().trace("TlsDVResponse :readResponse deliveries.length=" + this.deliveries.length);
        }
        return this.deliveries;
    }

    public TlsInputStream readResponse(byte[] byArray) {
        TlsInputStream tlsInputStream = super.readResponse(byArray);
        if (this.debug) {
            this.ext.getLog().trace("TlsDVResponse :readResponse mD[]=" + ByteArrayUtil.toHexString((byte[])this.messageData, (int)0, (int)this.messageData.length));
        }
        if (tlsInputStream.available() < 16 || !this.functionCode.equalsIgnoreCase("227")) {
            this.deliveries = new DeliveryVariance[0];
            this.messageTank = this.tank;
            return tlsInputStream;
        }
        this.messageReadTime = tlsInputStream.readDateTime(true);
        boolean bl = false;
        while (!bl) {
            tlsInputStream.mark(0);
            String string = tlsInputStream.readString(2);
            if (string.equals("&&")) {
                this.deliveries = new DeliveryVariance[0];
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            tlsInputStream.reset();
            if (tlsInputStream.available() < 8) {
                this.deliveries = new DeliveryVariance[0];
                this.messageTank = this.tank;
                return tlsInputStream;
            }
            this.messageTank = tlsInputStream.readAsciiInt(2);
            this.messageProduct = tlsInputStream.readString(1);
            this.messageProbe = tlsInputStream.readAsciiInt(2);
            this.messageNumDeliveries = tlsInputStream.readAsciiInt(3);
            this.deliveries = new DeliveryVariance[this.messageNumDeliveries];
            int n = 0;
            while (n < this.messageNumDeliveries) {
                this.deliveries[n] = new DeliveryVariance();
                this.deliveries[n].setTankNumber(this.messageTank);
                this.deliveries[n].setProduct(this.messageProduct);
                this.deliveries[n].setProbe(this.messageProbe);
                this.deliveries[n].setDeliveryTime(tlsInputStream.readDateTime(true));
                String string2 = tlsInputStream.readString(2);
                try {
                    this.messageNumValues = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("DeliveryVarianceReportResponse could not convert messageNumValues from str-hex-int... numValuesStr=" + string2);
                    return tlsInputStream;
                }
                int n2 = 0;
                while (n2 < this.messageNumValues) {
                    switch (n2) {
                        case 0: {
                            this.deliveries[n].setTicketVolume(tlsInputStream.readAsciiFloat());
                            break;
                        }
                        case 1: {
                            this.deliveries[n].setGuagedVolume(tlsInputStream.readAsciiFloat());
                            break;
                        }
                        case 2: {
                            this.deliveries[n].setDeliveryVariance(tlsInputStream.readAsciiFloat());
                            break;
                        }
                    }
                    if (this.debug) {
                        this.ext.getLog().trace("TlsDVResponse :readResponse deliveries[" + n + "]=" + this.deliveries[n].getDVLogString());
                    }
                    ++n2;
                }
                ++n;
            }
            bl = true;
        }
        return tlsInputStream;
    }

    private final /* synthetic */ void this() {
        this.messageTank = 0;
        this.messageProbe = 0;
        this.messageNumDeliveries = 0;
        this.messageNumValues = 0;
    }

    public Tls350DeliveryVarianceReportResponse() {
        this.this();
    }

    public Tls350DeliveryVarianceReportResponse(BTls350DelVarProxyExt bTls350DelVarProxyExt) {
        this.this();
        this.ext = bTls350DelVarProxyExt;
        boolean bl = false;
        if (bTls350DelVarProxyExt != null && bTls350DelVarProxyExt.getLog().isTraceOn() && bTls350DelVarProxyExt.device().getUserData().indexOf("msg") != -1) {
            bl = true;
        }
        this.debug = bl;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DeliveryVariance {
        int tankNumber;
        String product;
        int probe;
        BAbsTime deliveryTime;
        float ticketVolume;
        float guagedVolume;
        float deliveryVarance;

        public void setTankNumber(int n) {
            this.tankNumber = n;
        }

        public void setProduct(String string) {
            this.product = string;
        }

        public void setProbe(int n) {
            this.probe = n;
        }

        public void setDeliveryTime(BAbsTime bAbsTime) {
            this.deliveryTime = bAbsTime;
        }

        public void setTicketVolume(float f) {
            this.ticketVolume = f;
        }

        public void setGuagedVolume(float f) {
            this.guagedVolume = f;
        }

        public void setDeliveryVariance(float f) {
            this.deliveryVarance = f;
        }

        public int getTankNumber() {
            return this.tankNumber;
        }

        public String getProduct() {
            return this.product;
        }

        public int getProbe() {
            return this.probe;
        }

        public BAbsTime getDeliveryTime() {
            return this.deliveryTime;
        }

        public float getTicketVolume() {
            return this.ticketVolume;
        }

        public float getGuagedVolume() {
            return this.guagedVolume;
        }

        public float getDeliveryVarance() {
            return this.deliveryVarance;
        }

        public String getDVLogString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.tankNumber);
            stringBuffer.append(", ");
            stringBuffer.append(this.product);
            stringBuffer.append(", ");
            stringBuffer.append(this.probe);
            stringBuffer.append(", ");
            stringBuffer.append(this.deliveryTime.toString(null));
            stringBuffer.append(", ");
            stringBuffer.append(this.ticketVolume);
            stringBuffer.append(", ");
            stringBuffer.append(this.guagedVolume);
            stringBuffer.append(", ");
            stringBuffer.append(this.deliveryVarance);
            return stringBuffer.toString();
        }

        private final /* synthetic */ void this() {
            this.ticketVolume = Float.NaN;
            this.guagedVolume = Float.NaN;
            this.deliveryVarance = Float.NaN;
        }

        public DeliveryVariance() {
            this.this();
        }
    }
}

