/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.consoles;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.BTlsDeviceFolder;
import com.tridium.tls.comm.TlsTcpIpComm;
import com.tridium.tls.comm.TlsTcpIpCommReceiver;
import com.tridium.tls.comm.TlsTcpIpCommTransmitter;
import com.tridium.tls.devices.BTls250FuelTankDevice;
import com.tridium.tls.devices.BTls350ConsoleDevice;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.enums.BTlsCommTypeEnum;
import com.tridium.tls.enums.BTlsSocketStateEnum;
import com.tridium.tls.messages.TlsMessageConst;
import java.net.InetAddress;
import javax.baja.driver.BDevice;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTlsTcpIpConsole
extends BTlsConsole
implements TlsMessageConst {
    public static final Property commType = BTlsTcpIpConsole.newProperty((int)0, (BValue)BTlsCommTypeEnum.tcpip, null);
    public static final Property maxFailsUntilDeviceDown = BTlsTcpIpConsole.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    public static final Property ipAddress = BTlsTcpIpConsole.newProperty((int)16, (String)"###.###.###.###", null);
    public static final Property port = BTlsTcpIpConsole.newProperty((int)16, (int)10001, (BFacets)BFacets.makeInt(null, (int)0, (int)99999));
    public static final Property shareTcpipConnection = BTlsTcpIpConsole.newProperty((int)0, (boolean)false, null);
    public static final Property statusTcpipConnection = BTlsTcpIpConsole.newProperty((int)1, (BValue)BTlsSocketStateEnum.Closed, null);
    public static final Type TYPE;
    protected Subscriber subscriber;
    protected boolean commActive;
    protected boolean networkInitialized;
    private long totalCrcErrors;
    private long totalLrcErrors;
    static /* synthetic */ Class class$com$tridium$tls$consoles$BTlsTcpIpConsole;

    public BTlsCommTypeEnum getCommType() {
        return (BTlsCommTypeEnum)this.get(commType);
    }

    public void setCommType(BTlsCommTypeEnum bTlsCommTypeEnum) {
        this.set(commType, (BValue)bTlsCommTypeEnum, null);
    }

    public int getMaxFailsUntilDeviceDown() {
        return this.getInt(maxFailsUntilDeviceDown);
    }

    public void setMaxFailsUntilDeviceDown(int n) {
        this.setInt(maxFailsUntilDeviceDown, n, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String string) {
        this.setString(ipAddress, string, null);
    }

    public int getPort() {
        return this.getInt(port);
    }

    public void setPort(int n) {
        this.setInt(port, n, null);
    }

    public boolean getShareTcpipConnection() {
        return this.getBoolean(shareTcpipConnection);
    }

    public void setShareTcpipConnection(boolean bl) {
        this.setBoolean(shareTcpipConnection, bl, null);
    }

    public BTlsSocketStateEnum getStatusTcpipConnection() {
        return (BTlsSocketStateEnum)this.get(statusTcpipConnection);
    }

    public void setStatusTcpipConnection(BTlsSocketStateEnum bTlsSocketStateEnum) {
        this.set(statusTcpipConnection, (BValue)bTlsSocketStateEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
    }

    public void serviceStopped() throws Exception {
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
        super.serviceStopped();
    }

    public Type getDeviceType() {
        return BTlsDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BTlsDeviceFolder.TYPE;
    }

    protected Comm makeComm() {
        return new TlsTcpIpComm(this, new TlsTcpIpCommReceiver(), new TlsTcpIpCommTransmitter());
    }

    public void startComm() throws Exception {
        super.startComm();
        if (!(this.isDisabled() || this.isFatalFault() || this.isDown() || this.initializeNetwork())) {
            this.getLog().warning("Unable to initialize network " + this.getName() + "!!");
        }
    }

    public void stopComm() throws Exception {
        super.stopComm();
        this.commActive = false;
        this.networkInitialized = false;
    }

    protected boolean initializeNetwork() {
        if (this.networkInitialized) {
            return true;
        }
        this.commActive = true;
        if (!this.getComm().isCommStarted()) {
            if (this.getLog().isTraceOn()) {
                this.getLog().warning("Unable to start Tcp/Ip Comm for " + this);
            }
            this.commActive = false;
            return false;
        }
        this.networkInitialized = true;
        return true;
    }

    protected BTlsDevice findDeviceInNetwork(int n) {
        BDevice[] bDeviceArray = this.getDevices();
        int n2 = 0;
        while (n2 < bDeviceArray.length) {
            if (bDeviceArray[n2] instanceof BTlsDevice) {
                if (bDeviceArray[n2] instanceof BTls350ConsoleDevice && n == 0) {
                    return (BTls350ConsoleDevice)bDeviceArray[n2];
                }
                if (bDeviceArray[n2] instanceof BTls350FuelTankDevice) {
                    if (((BTls350FuelTankDevice)bDeviceArray[n2]).getTankNumber() == n) {
                        return (BTls350FuelTankDevice)bDeviceArray[n2];
                    }
                } else if (bDeviceArray[n2] instanceof BTls250FuelTankDevice && ((BTls250FuelTankDevice)bDeviceArray[n2]).getTankNumber() == n) {
                    return (BTls250FuelTankDevice)bDeviceArray[n2];
                }
            }
            ++n2;
        }
        return null;
    }

    public boolean isCommActive() {
        boolean bl = false;
        if (this.commActive && !this.isDisabled() && !this.isDown() && !this.isFatalFault()) {
            bl = true;
        }
        return bl;
    }

    public InetAddress getInetAddr() {
        InetAddress inetAddress;
        try {
            String string = this.getIpAddress().trim();
            inetAddress = string.equalsIgnoreCase("###.###.###.###") || string.length() == 0 ? null : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            inetAddress = null;
        }
        return inetAddress;
    }

    public void changed(Property property, Context context) {
        block4: {
            super.changed(property, context);
            try {
                if ((property.equals((Object)ipAddress) || property.equals((Object)port)) && this.getComm() != null && this.getComm().isCommStarted()) {
                    this.getComm().stop();
                    InetAddress inetAddress = this.getInetAddr();
                    if (inetAddress == null && this.getLog() != null) {
                        this.getLog().error("\nCould not resolve IP address [" + this.getIpAddress() + "].");
                    }
                    this.getComm().start();
                }
            }
            catch (Exception exception) {
                if (this.getLog() == null) break block4;
                this.getLog().error("Caught exception in BTlsTcpIpConsole.changed()", (Throwable)exception);
            }
        }
    }

    protected void processNameSubscriberEvent(BComponentEvent bComponentEvent) {
    }

    protected Subscriber getNameSubscriber() {
        return this.subscriber;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"TlsNetwork", 2);
        spyWriter.prop((Object)"Total CRC Errors", (Object)new Long(this.totalCrcErrors));
        spyWriter.prop((Object)"Total LRC Errors", (Object)new Long(this.totalLrcErrors));
        spyWriter.endProps();
    }

    public final void incrementCrcErrors() {
        ++this.totalCrcErrors;
    }

    public final void incrementLrcErrors() {
        ++this.totalLrcErrors;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.commActive = false;
        this.networkInitialized = false;
        this.totalCrcErrors = 0L;
        this.totalLrcErrors = 0L;
    }

    public BTlsTcpIpConsole() {
        this.this();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setResponseTimeout(BRelTime.make((long)5000L));
    }

    static {
        Class clazz = class$com$tridium$tls$consoles$BTlsTcpIpConsole;
        if (clazz == null) {
            clazz = class$com$tridium$tls$consoles$BTlsTcpIpConsole = BTlsTcpIpConsole.class("[Lcom.tridium.tls.consoles.BTlsTcpIpConsole;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NameSubscriber
    extends Subscriber {
        private BTlsTcpIpConsole net;

        public void event(BComponentEvent bComponentEvent) {
            this.net.processNameSubscriberEvent(bComponentEvent);
        }

        public NameSubscriber(BTlsTcpIpConsole bTlsTcpIpConsole2) {
            this.net = bTlsTcpIpConsole2;
        }
    }
}

