/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.consoles;

import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.BTlsDeviceFolder;
import com.tridium.tls.enums.BTlsCommTypeEnum;
import com.tridium.tls.messages.TlsMessageConst;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialHelper;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BTlsSerialConsole
extends BTlsConsole
implements BISerialHelperParent,
TlsMessageConst {
    public static final Property interMessageDelay = BTlsSerialConsole.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property serialPortConfig = BTlsSerialConsole.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Property commType = BTlsSerialConsole.newProperty((int)0, (BValue)BTlsCommTypeEnum.serial, null);
    public static final Type TYPE;
    private Subscriber subscriber;
    private String serialInitError;
    static /* synthetic */ Class class$com$tridium$tls$consoles$BTlsSerialConsole;

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public BTlsCommTypeEnum getCommType() {
        return (BTlsCommTypeEnum)this.get(commType);
    }

    public void setCommType(BTlsCommTypeEnum bTlsCommTypeEnum) {
        this.set(commType, (BValue)bTlsCommTypeEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        this.subscriber = new NameSubscriber(this);
        this.subscriber.subscribe((BComponent)this.getParent());
        this.subscriber.subscribe((BComponent)this.getSerialPortConfig());
        this.getSerialPortConfig().setSerialHelperParent((BISerialHelperParent)this);
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        this.subscriber.unsubscribeAll();
        this.subscriber = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startComm() throws Exception {
        String string;
        block6: {
            try {
                try {
                    super.startComm();
                    this.serialInitError = null;
                }
                catch (Exception exception) {
                    this.serialInitError = "Could not enable serial communication (" + exception + ')';
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                String string2 = this.checkSerialConfig();
                if (string2 == null) {
                    this.configOk();
                    throw throwable;
                }
                this.configFail(string2);
                throw throwable;
            }
            {
                Object var2_4 = null;
                string = this.checkSerialConfig();
                if (string != null) break block6;
            }
            this.configOk();
            return;
        }
        this.configFail(string);
    }

    protected String checkSerialConfig() {
        if (this.getSerialPortConfig().getPortName().equals("none")) {
            return "No port selected for serial communication.";
        }
        return this.serialInitError;
    }

    public final void reopenPort() {
        try {
            String string = this.getSerialPortConfig().getPortName();
            if (string.equals("none")) {
                this.configFail("No port selected for serial communication.");
                this.stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception exception) {
            this.getLog().error("BSerialNetwork caught exception in reopenPort(): ", (Throwable)exception);
        }
    }

    private final void restartSerialNetwork() throws Exception {
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Restarting serial comm ***");
            }
            this.stopComm();
            this.startComm();
        }
    }

    public Type getDeviceType() {
        return BTlsDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BTlsDeviceFolder.TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.serialInitError = null;
    }

    public BTlsSerialConsole() {
        this.this();
        this.getSerialPortConfig().setBaudRate((BBaudRate)BSerialBaudRate.baud9600);
        this.getSerialPortConfig().setDataBits(BSerialDataBits.dataBits8);
        this.getSerialPortConfig().setStopBits(BSerialStopBits.stopBits2);
        this.getSerialPortConfig().setParity(BSerialParity.none);
        this.setRetryCount(1);
        this.setResponseTimeout(BRelTime.make((long)2000L));
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    static {
        Class clazz = class$com$tridium$tls$consoles$BTlsSerialConsole;
        if (clazz == null) {
            clazz = class$com$tridium$tls$consoles$BTlsSerialConsole = BTlsSerialConsole.class("[Lcom.tridium.tls.consoles.BTlsSerialConsole;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NameSubscriber
    extends Subscriber {
        private BTlsSerialConsole net;

        public void event(BComponentEvent bComponentEvent) {
        }

        public NameSubscriber(BTlsSerialConsole bTlsSerialConsole2) {
            this.net = bTlsSerialConsole2;
        }
    }
}

