/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransaction;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.tls.TlsException;
import com.tridium.tls.comm.TlsTcpIpCommReceiver;
import com.tridium.tls.comm.TlsTcpIpCommTransmitter;
import com.tridium.tls.consoles.BTlsTcpIpConsole;
import com.tridium.tls.enums.BTlsSocketStateEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public class TlsTcpIpComm
extends Comm {
    protected Thread tcpRxThread;
    private Socket commSocket;
    private BTlsTcpIpConsole network;
    private int socketConnectionAttemptCount;
    private boolean socketConnectionAttemptAlarmLastSent;

    protected boolean started() throws Exception {
        this.getCommReceiver().setAlive(true);
        this.tcpRxThread = new Thread((Runnable)this.getCommReceiver(), " " + this.network.getName());
        this.tcpRxThread.start();
        this.tcpRxThread.setPriority(5);
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.tcpRxThread != null) {
            int n = (int)this.network.getResponseTimeout().getMillis();
            try {
                ((Object)((Object)this)).wait(n + 1000);
            }
            catch (Exception exception) {}
            this.closeSocket();
            this.tcpRxThread.interrupt();
            this.closeSocket();
        }
    }

    public void closeSocket() {
        if (this.commSocket != null) {
            try {
                this.commSocket.close();
                if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                    this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- closeSocket()... SOCKET connection closed !!!!!!");
                }
            }
            catch (Exception exception) {
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- closeSocket()... SOCKET connection close failed !!!!!!");
            }
            this.commSocket = null;
            this.network.setStatusTcpipConnection(BTlsSocketStateEnum.Closed);
        }
    }

    private final void connectSocket() throws Exception {
        if (this.network == null) {
            throw new TlsException(102);
        }
        InetAddress inetAddress = this.network.getInetAddr();
        if (inetAddress == null) {
            throw new TlsException(103);
        }
        this.commSocket = new Socket(inetAddress, this.network.getPort());
        this.network.setStatusTcpipConnection(BTlsSocketStateEnum.Connected);
    }

    protected synchronized boolean initSocketConnection() {
        try {
            this.closeSocket();
            this.connectSocket();
            this.getCommReceiver().setInputStream((InputStream)new BufferedInputStream(this.commSocket.getInputStream()));
            this.getCommTransmitter().setOutputStream((OutputStream)new BufferedOutputStream(this.commSocket.getOutputStream()));
        }
        catch (SocketException socketException) {
            if (this.network.getLog().isTraceOn()) {
                BAbsTime bAbsTime = BAbsTime.make();
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- initSocketConnection()... SocketException e=" + socketException + "!!!!!! time=" + bAbsTime);
                this.network.getLog().trace(" Ip: " + this.network.getInetAddr() + ": " + this.network.getPort());
            }
            ++this.socketConnectionAttemptCount;
            if (this.socketConnectionAttemptCount > 10 && !this.socketConnectionAttemptAlarmLastSent) {
                this.socketConnectionAttemptAlarmLastSent = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            return false;
        }
        catch (Exception exception) {
            if (this.network.getLog().isTraceOn()) {
                BAbsTime bAbsTime = BAbsTime.make();
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- initSocketConnection()... Exception e=" + exception + "!!!!!! time=" + bAbsTime);
                this.network.getLog().trace(" Ip: " + this.network.getInetAddr() + ": " + this.network.getPort());
            }
            if (this.socketConnectionAttemptCount > 10 && !this.socketConnectionAttemptAlarmLastSent) {
                this.socketConnectionAttemptAlarmLastSent = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception2) {}
            return false;
        }
        this.socketConnectionAttemptCount = 0;
        if (this.socketConnectionAttemptAlarmLastSent) {
            this.socketConnectionAttemptAlarmLastSent = false;
        }
        return true;
    }

    public void transmitNoResponse(Message message) throws TlsException {
        if (message == null) {
            this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- transmitNoResponse(.)... msg==null!!!!!!");
            return;
        }
        if (!this.isCommStarted()) {
            throw new TlsException("Communication handler service not started.");
        }
        if (this.network.isCommActive()) {
            if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- transmitNoResponse(.)... init socket connection if sharing!!!!!!");
            }
            if (!((TlsTcpIpComm)this.network.getComm()).initSocketConnection()) {
                return;
            }
        }
        this.getCommTransmitter().writeMessage(message);
        this.network.incrementSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Message processTransmit(Message message, BRelTime bRelTime) throws TlsException {
        Object object;
        if (!this.isCommStarted()) {
            throw new TlsException("Communication handler service not started.");
        }
        if (this.network.isCommActive()) {
            if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                this.network.getLog().trace(this.network.getName() + "(TlsTcpIpComm)- processTransmit(..)... init socket connection if sharing!!!!!!");
            }
            if (!((TlsTcpIpComm)this.network.getComm()).initSocketConnection()) {
                return null;
            }
        }
        CommTransaction commTransaction = this.getCommTransactionManager().getCommTransaction(message);
        CommTransaction commTransaction2 = commTransaction;
        synchronized (commTransaction2) {
            block20: {
                if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                    this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - processTransmit(..)... getting xmtr and passing outgoing message");
                }
                this.getCommTransmitter().writeMessage(message);
                this.network.incrementSent();
                try {
                    if (commTransaction.isComplete()) break block20;
                    if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                        this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - processTransmit(..)... waiting responseTimeout for response");
                    }
                    commTransaction.wait(bRelTime.getMillis());
                    if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                        this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - processTransmit(..)... wake from waiting responseTimeout for response");
                    }
                    if (!commTransaction.isComplete()) {
                        if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                            object = commTransaction.getRequestMessage().getTag();
                            this.network.getLog().trace(this.network.getName() + "TlsTcpIpComm - processTransmit(..)... CommTransaction timed out (tag: " + object + ')');
                            if (object != Message.DEFAULT_TAG) {
                                try {
                                    Message message2 = commTransaction.getRequestMessage();
                                    if (message2 != null) {
                                        this.network.getLog().trace(this.network.getName() + "TlsTcpIpComm - processTransmit(..)... Failure to get response for sent message: " + message2.toDebugString());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (this.network.getLog().isTraceOn() && this.network.getUserData().indexOf("comm") != -1) {
                            this.network.getLog().trace(this.network.getName() + " TlsTcpIpComm - TlsTcpIpComm - processTransmit(..)... response was null... <" + (Object)((Object)this) + '>');
                        }
                        commTransaction.setResponseMessage(null);
                        this.network.incrementTimeouts();
                    }
                    commTransaction.setComplete(true);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = commTransaction.getResponseMessage();
        if (this.network.getShareTcpipConnection()) {
            this.closeSocket();
            this.network.setStatusTcpipConnection(BTlsSocketStateEnum.Closed);
        }
        this.getCommTransactionManager().freeCommTransaction(commTransaction);
        return object;
    }

    public TlsTcpIpComm(BTlsTcpIpConsole bTlsTcpIpConsole, TlsTcpIpCommReceiver tlsTcpIpCommReceiver, TlsTcpIpCommTransmitter tlsTcpIpCommTransmitter) {
        super((BBasicNetwork)bTlsTcpIpConsole, (CommReceiver)tlsTcpIpCommReceiver, (CommTransmitter)tlsTcpIpCommTransmitter);
        this.network = bTlsTcpIpConsole;
    }
}

