/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.MoveGlyphsCommand;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;

public class MoveState
extends WsState {
    private double x;
    private double y;
    private double w;
    private double h;
    private double xo;
    private double yo;
    private Point original;

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.transition(new NormalState(this.ws));
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        this.computeMovePt(d, d2);
        int n = (int)((this.x - this.original.x) / (double)this.ws.grid.wixel);
        int n2 = (int)((this.y - this.original.y) / (double)this.ws.grid.wixel);
        new MoveGlyphsCommand(this.ws, this.selection.getComponentGlyphs(), n, n2).invoke();
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.w;
        double d4 = this.h;
        double d5 = bMouseEvent.getX();
        double d6 = bMouseEvent.getY();
        this.computeMovePt(d5, d6);
        double d7 = Math.min(this.x, d);
        double d8 = Math.min(this.y, d2);
        double d9 = Math.max(this.x + this.w, d + d3) - d7;
        double d10 = Math.max(this.y + this.h, d2 + d4) - d8;
        this.ws.getCanvas().repaint(d7 - 1.0, d8 - 1.0, d9 + (double)2, d10 + (double)2);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.pulseViewport(bMouseEvent)) {
            this.mouseDragged(bMouseEvent);
        }
    }

    private final void computeMovePt(double d, double d2) {
        this.x = d - this.xo;
        this.y = d2 - this.yo;
        this.x = this.snapToGrid(this.x);
        this.y = this.snapToGrid(this.y);
        double d3 = BWsOptions.make().getMaxWidth() * this.ws.grid.wixel;
        double d4 = BWsOptions.make().getMaxHeight() * this.ws.grid.wixel;
        if (this.x + this.w > d3) {
            this.x = d3 - this.w;
        }
        if (this.y + this.h > d4) {
            this.y = d4 - this.h;
        }
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
    }

    public void paintFx(Graphics graphics) {
        graphics.setBrush(BColor.black);
        graphics.strokeRect(this.x, this.y, this.w, this.h);
    }

    public MoveState(BWireSheetPane bWireSheetPane, RectGeom rectGeom, double d, double d2) {
        super(bWireSheetPane);
        this.x = rectGeom.x;
        this.y = rectGeom.y;
        this.w = rectGeom.width;
        this.h = rectGeom.height;
        this.xo = d - rectGeom.x;
        this.yo = d2 - rectGeom.y;
        this.original = new Point(this.x, this.y);
        BWsCanvas bWsCanvas = bWireSheetPane.getCanvas();
        bWsCanvas.setMouseCursor(WsConst.moveCursor);
        bWsCanvas.repaint();
    }
}

