/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.WsSelectedState;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.ui.Subject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WsSelection
implements WsConst {
    public final BWireSheetPane ws;
    private ArrayList selection;
    private HashMap byKey;
    private Array selectionIndexArray;
    static /* synthetic */ Class class$java$lang$Integer;

    public synchronized Glyph[] get() {
        return this.selection.toArray(new Glyph[this.selection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void select(Glyph glyph) {
        if (!glyph.isSelectable()) {
            throw new IllegalStateException();
        }
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            if (glyph.isSelected()) {
                return;
            }
            this.selection.add(glyph);
            glyph.setSelected(true);
            glyph.getParent().toTop(glyph);
        }
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unselect(Glyph glyph) {
        if (!glyph.isSelectable()) {
            throw new IllegalStateException();
        }
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            if (!glyph.isSelected()) {
                return;
            }
            int n = 0;
            while (n < this.selection.size()) {
                if (this.selection.get(n) == glyph) {
                    this.selection.remove(n);
                    break;
                }
                ++n;
            }
            glyph.setSelected(false);
        }
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectAll() {
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            ComponentGlyph[] componentGlyphArray = this.ws.controller.getAllComponentGlyphs();
            int n = 0;
            while (true) {
                if (n >= componentGlyphArray.length) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.selectionChanged();
                    return;
                }
                ComponentGlyph componentGlyph = componentGlyphArray[n];
                if (componentGlyph.isSelectable()) {
                    this.select(componentGlyph);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unselectAll() {
        WsSelection wsSelection = this;
        synchronized (wsSelection) {
            int n = 0;
            while (true) {
                if (n >= this.selection.size()) {
                    this.selection.clear();
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 4] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.selectionChanged();
                    return;
                }
                ((Glyph)this.selection.get(n)).setSelected(false);
                ++n;
            }
        }
    }

    private final void selectionChanged() {
        this.ws.controller.updateTransferStates();
        this.ws.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ComponentGlyph[] getComponentGlyphs() {
        ArrayList arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < this.selection.size()) {
                if (this.selection.get(n) instanceof ComponentGlyph) {
                    arrayList2.add(this.selection.get(n));
                }
                ++n;
            }
            return arrayList2.toArray(new ComponentGlyph[arrayList2.size()]);
        }
    }

    public BComponent[] getComponents() {
        ComponentGlyph[] componentGlyphArray = this.getComponentGlyphs();
        BComponent[] bComponentArray = new BComponent[componentGlyphArray.length];
        int n = 0;
        while (n < bComponentArray.length) {
            bComponentArray[n] = componentGlyphArray[n].component;
            ++n;
        }
        return bComponentArray;
    }

    public void setComponents(BComponent[] bComponentArray) {
        this.unselectAll();
        int n = 0;
        while (n < bComponentArray.length) {
            BOrd bOrd = bComponentArray[n].getHandleOrd();
            ComponentGlyph componentGlyph = this.ws.controller.toComponentGlyph(bOrd);
            if (componentGlyph != null) {
                this.select(componentGlyph);
            }
            ++n;
        }
    }

    public Subject getSubject() {
        return new Subject((Object[])this.getComponents());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LinkGlyph[] getLinkGlyphs() {
        ArrayList arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < this.selection.size()) {
                if (this.selection.get(n) instanceof LinkGlyph) {
                    arrayList2.add(this.selection.get(n));
                }
                ++n;
            }
            return arrayList2.toArray(new LinkGlyph[arrayList2.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BLink[] getLinks() {
        ArrayList arrayList = this.selection;
        synchronized (arrayList) {
            ArrayList<BLink> arrayList2 = new ArrayList<BLink>();
            int n = 0;
            while (n < this.selection.size()) {
                if (this.selection.get(n) instanceof LinkLinkGlyph) {
                    arrayList2.add(((LinkLinkGlyph)this.selection.get((int)n)).link);
                } else if (this.selection.get(n) instanceof LinkKnobGlyph) {
                    arrayList2.add(((LinkKnobGlyph)this.selection.get(n)).getLink());
                }
                ++n;
            }
            return arrayList2.toArray(new BLink[arrayList2.size()]);
        }
    }

    public WsSelectedState[] saveSelectedStates() {
        Glyph[] glyphArray = this.get();
        WsSelectedState[] wsSelectedStateArray = new WsSelectedState[glyphArray.length];
        int n = 0;
        while (n < glyphArray.length) {
            wsSelectedStateArray[n] = glyphArray[n].saveSelectedState();
            ++n;
        }
        return wsSelectedStateArray;
    }

    public void restoreSelectedStates(WsSelectedState[] wsSelectedStateArray) {
        this.unselectAll();
        int n = 0;
        while (n < wsSelectedStateArray.length) {
            Glyph glyph = (Glyph)this.byKey.get(wsSelectedStateArray[n]);
            if (glyph != null) {
                this.select(glyph);
                glyph.restoreSelectedState(wsSelectedStateArray[n]);
            } else {
                wsSelectedStateArray[n].cancelRestore();
            }
            ++n;
        }
    }

    public Glyph getSelectableGlyphAt(int n, int n2) {
        return this.ws.getCanvas().getRootGlyph().getSelectableGlyphAt(n, n2);
    }

    public ResizeZone getResizeAt(double d, double d2) {
        int n = 0;
        while (n < this.selection.size()) {
            Glyph glyph = (Glyph)this.selection.get(n);
            ResizeZone resizeZone = glyph.getResizeAt(d, d2);
            if (resizeZone != null) {
                return resizeZone;
            }
            ++n;
        }
        return null;
    }

    public RectGeom getSelectionPixelBounds() {
        RectGeom rectGeom = null;
        Glyph[] glyphArray = this.get();
        int n = 0;
        while (n < glyphArray.length) {
            Glyph glyph = glyphArray[n];
            if (glyph instanceof ComponentGlyph) {
                RectGeom rectGeom2 = new RectGeom((double)glyph.x, (double)glyph.y, (double)glyph.pw, (double)glyph.ph);
                if (rectGeom == null) {
                    rectGeom = rectGeom2;
                } else {
                    RectGeom.bounds((IRectGeom)rectGeom2, (IRectGeom)rectGeom, (RectGeom)rectGeom);
                }
            }
            ++n;
        }
        return rectGeom;
    }

    WsSelectedState[] preLoad() {
        WsSelectedState[] wsSelectedStateArray = this.saveSelectedStates();
        this.selection.clear();
        this.byKey.clear();
        return wsSelectedStateArray;
    }

    void postLoad(WsSelectedState[] wsSelectedStateArray) {
        this.addToKeyMap(this.ws.getCanvas().rootGlyph);
        this.restoreSelectedStates(wsSelectedStateArray);
    }

    private final void addToKeyMap(Glyph glyph) {
        Glyph[] glyphArray;
        if (glyph.isSelectable()) {
            glyphArray = glyph.saveSelectedState();
            if (this.byKey.get(glyphArray) != null) {
                throw new IllegalStateException("Duplicate selection keys: " + glyphArray);
            }
            this.byKey.put(glyphArray, glyph);
        }
        glyphArray = glyph.getChildGlyphs();
        int n = 0;
        while (n < glyphArray.length) {
            this.addToKeyMap(glyphArray[n]);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int registerNewStdSelectionIndex() {
        Array array = this.selectionIndexArray;
        synchronized (array) {
            int n = 0;
            while (true) {
                Integer n2;
                if (!this.selectionIndexArray.contains((Object)(n2 = new Integer(n)))) {
                    this.selectionIndexArray.add((Object)n2);
                    return n2;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void registerStdSelectionIndex(int n) {
        Array array = this.selectionIndexArray;
        synchronized (array) {
            Integer n2 = new Integer(n);
            if (!this.selectionIndexArray.contains((Object)n2)) {
                this.selectionIndexArray.add((Object)n2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void unregisterStdSelectionIndex(int n) {
        Array array = this.selectionIndexArray;
        synchronized (array) {
            this.selectionIndexArray.remove((Object)new Integer(n));
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.selection = new ArrayList();
        this.byKey = new HashMap();
        Class clazz = class$java$lang$Integer;
        if (clazz == null) {
            clazz = class$java$lang$Integer = WsSelection.class("[Ljava.lang.Integer;", false);
        }
        this.selectionIndexArray = new Array(clazz);
    }

    public WsSelection(BWireSheetPane bWireSheetPane) {
        this.this();
        this.ws = bWireSheetPane;
    }
}

