/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.commands.ArrangeCommand;
import com.tridium.wiresheet.commands.DeleteLinksCommand;
import com.tridium.wiresheet.commands.EditLinkCommand;
import com.tridium.wiresheet.commands.SelectAllCommand;
import com.tridium.wiresheet.commands.ZoomInCommand;
import com.tridium.wiresheet.commands.ZoomOutCommand;
import com.tridium.wiresheet.commands.ZoomResetCommand;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.util.UiLexicon;

public class WsCommands
implements WsConst {
    static boolean lastThumbnailVisible = true;
    public final BWireSheetPane ws;
    public BWidgetShell wsShell;
    public BWsOptions wsOptions;
    public SelectAllCommand selectAll;
    public DeleteLinksCommand deleteLinks;
    public EditLinkCommand editLink;
    public ZoomInCommand zoomIn;
    public ZoomOutCommand zoomOut;
    public ZoomResetCommand zoomReset;
    public OptionToggle showThumbnail;
    public OptionToggle showGrid;
    public OptionToggle showStatusColors;
    public ArrangeCommand arrange;

    public void init() {
        this.wsShell = this.ws.getShell();
        this.wsOptions = BWsOptions.make();
        this.arrange = new ArrangeCommand(this.ws);
        this.selectAll = new SelectAllCommand(this.ws);
        this.deleteLinks = new DeleteLinksCommand(this.ws);
        this.editLink = new EditLinkCommand(this.ws);
        this.zoomIn = new ZoomInCommand(this.ws);
        this.zoomOut = new ZoomOutCommand(this.ws);
        this.zoomReset = new ZoomResetCommand(this.ws);
        this.showThumbnail = new OptionToggle(BWsOptions.showThumbnail);
        this.showGrid = new OptionToggle(BWsOptions.showGrid);
        this.showStatusColors = new OptionToggle(BWsOptions.showStatusColors);
        this.ws.controller.updateTransferStates();
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = UiLexicon.bajaui.buildMenu("menu.wireSheet.label");
        bMenu.add("deleteLinks", (Command)this.deleteLinks);
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("arrange", (Command)this.arrange);
        bMenu.add("selectAll", (Command)this.selectAll);
        bMenu.add("sep2", (BValue)new BSeparator());
        bMenu.add("showThumbnail", (Command)this.showThumbnail);
        bMenu.add("showGrid", (Command)this.showGrid);
        bMenu.add("showStatusColors", (Command)this.showStatusColors);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("zoomIn", (Command)this.zoomIn);
        bToolBar.add("zoomOut", (Command)this.zoomOut);
        bToolBar.add("zoomReset", (Command)this.zoomReset);
        bToolBar.add("sep1", (BValue)new BSeparator());
        bToolBar.add("delLinks", (Command)this.deleteLinks);
        return bToolBar;
    }

    public WsCommands(BWireSheetPane bWireSheetPane) {
        this.ws = bWireSheetPane;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class OptionToggle
    extends WsToggleCommand {
        Property prop;

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            WsCommands.this.wsOptions.setBoolean(this.prop, bl);
            WsCommands.this.ws.repaint();
        }

        public OptionToggle(Property property) {
            super("commands." + property.getName());
            this.prop = property;
            this.setSelected(WsCommands.this.wsOptions.getBoolean(property));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class WsToggleCommand
    extends ToggleCommand {
        public WsToggleCommand(String string) {
            super((BWidget)(WsCommands.this.wsShell != null ? WsCommands.this.wsShell : WsCommands.this.ws), UiLexicon.bajaui.module, string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class WsCommand
    extends Command {
        public WsCommand(String string) {
            super((BWidget)WsCommands.this.wsShell, UiLexicon.bajaui.module, string);
        }
    }
}

